<?php

    require_once __DIR__ . '/vendor/autoload.php';
    include_once 'model/customers_model.php';
    include_once 'model/sales_model.php';
    include_once 'model/common_model.php';

    $customer_id = isset($_GET['customer_id']) ? intval($_GET['customer_id']) : 0;

    if ($customer_id === 0) {
        die("Invalid customer ID.");
    }

    $customers_model = new customers_model();
    $sales_model = new sales_model();
    $common_model = new common_model();

    $invoices = $customers_model->getActiveInvoicesByCustomer($customer_id);
    $company = $common_model->getCompanyDetails();

    $output_dir = __DIR__ . '/invoices/';
    if (!file_exists($output_dir)) {
        mkdir($output_dir, 0777, true);
    }

    // FTP config
    $ftp_host = "poweronline-mw.com";
    $ftp_user = "smplus";
    $ftp_pass = "Grace@2024";
    $remote_dir = "/powertex/invoices/";

    $conn_id = ftp_connect($ftp_host);
    $login_result = ftp_login($conn_id, $ftp_user, $ftp_pass);
    ftp_pasv($conn_id, true);

    if (!$conn_id || !$login_result) {
        die("FTP connection failed.");
    }

    $pdf_files = []; // Store generated files for batch upload

    foreach ($invoices as $inv) {
        $invoice_number = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $inv['invoice_number']);
        $filename = "invoice_{$invoice_number}.pdf";
        $filepath = $output_dir . $filename;

        $items = $sales_model->getReceiptItems($inv['invoice_number']);

        // ✅ Optimized mPDF instance
        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4',
            'tempDir' => __DIR__ . '/tmp', // helps WAMP
            'margin_top' => 10,
            'margin_bottom' => 10,
            'default_font_size' => 12,
            'default_font' => 'dejavusans',
        ]);
        $mpdf->keep_table_proportions = true;
        $mpdf->autoScriptToLang = false;
        $mpdf->autoLangToFont = false;

        // ✅ Existing invoice HTML layout (no changes made)
        $html = '
        <div style="font-family: Arial, sans-serif; font-size: 14px; max-width: 1200px; margin: auto;">
            <table width="100%" style="border-collapse: collapse; margin-bottom: 15px;">
                <tr>
                    <td style="width: 33%; vertical-align: middle; font-size: 18px;">
                        <strong>TPIN No.</strong> ' . htmlspecialchars($company['tpin']) . '
                    </td>
                    <td style="width: 33%; text-align: center;">
                        <img src="images/' . htmlspecialchars($company['logo']) . '" style="height: 50px;"><br>
                    </td>
                    <td style="width: 33%; text-align: right; vertical-align: top; font-size: 16px;">
                        <strong>INVOICE No. </strong> ' . htmlspecialchars($inv['invoice_number']) . '
                    </td>
                </tr>
            </table>

            <table width="100%" style="font-size: 13px;">
                <tr>
                    <td style="width: 33%;">
                        <strong>Corporate Office</strong><br>
                        AREA 47/3/1210 HSE68<br>
                        LILONGWE<br>
                        Tel: 0880 006 822, Hotline: 0883 742 305<br>
                        Email: powertexmw@gmail.com<br>
                        Website: www.powertexmw.com
                    </td>
                    <td style="width: 33%; text-align: center;">
                        <strong>Blantyre Office</strong><br>
                        Claim Building<br>
                        Gly Jones Road<br>
                        Tel: 0887 626 530<br>
                        Email: powertexmw@gmail.com
                    </td>
                    <td style="width: 33%; text-align:right;">
                        <strong>BRANCHES</strong><br>
                        Zomba - 0883 742 305<br>
                        Murray Road (LLZ) - 0887 626 529<br>
                        Area 13 (LLZ) - 0887 626 528<br>
                        Limbe - 0887 361 420
                    </td>
                </tr>
            </table>

            <p style="font-weight: bold; font-size: 13px; margin-top: 8px;">
                ' . strtoupper(htmlspecialchars($inv['customer_name'])) . '
            </p>
            <hr style="margin: 3px 0;">
            <p style="text-align: right; font-size: 11px;">
                <strong><u>Date:</u></strong><u> ' . date('d M Y', strtotime($inv['invoice_date'])) . '</u>
            </p>

            <table border="1" cellpadding="8" cellspacing="0" width="100%" style="font-size: 13px; border-collapse: collapse;">
                <thead style="background: #f2f2f2;">
                    <tr>
                        <th style="text-align:center;">QTY</th>
                        <th>DESCRIPTION</th>
                        <th style="text-align:right;">Selling Price</th>
                        <th style="text-align:right;">TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
                    foreach ($items as $item) {
                        $html .= '
                        <tr>
                            <td style="text-align: center;">' . htmlspecialchars($item['quantity']) . '</td>
                            <td>' . htmlspecialchars($item['description']) . '</td>
                            <td style="text-align: right;">' . number_format($item['selling_price'], 2) . '</td>
                            <td style="text-align: right;">' . number_format($item['total'], 2) . '</td>
                        </tr>';
                    }
                $html .= '
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="2"></td>
                        <td style="text-align:right;"><strong>Subtotal</strong></td>
                        <td style="text-align:right;"><strong>' . number_format($inv['subtotal'], 2) . '</strong></td>
                    </tr>
                    <tr>
                        <td colspan="2"></td>
                        <td style="text-align:right;"><strong>Plus 16.5% VAT</strong></td>
                        <td style="text-align:right;"><strong>' . number_format($inv['vat'], 2) . '</strong></td>
                    </tr>
                    <tr>
                        <td colspan="2"></td>
                        <td style="text-align:right;"><strong>Grand Total</strong></td>
                        <td style="text-align:right;"><strong>' . number_format($inv['grand_total'], 2) . '</strong></td>
                    </tr>
                </tfoot>
            </table>

            <table width="100%" style="margin-top: 20px; font-size: 12px;">
                <tr>
                    <td style="text-align: left;">
                        <strong>Customer Tel:</strong> ' . htmlspecialchars($inv['customer_contact']) . '
                    </td>
                    <td style="text-align: right;">Signature: ';
                        if (!empty($company['directors_signature']) && file_exists(__DIR__ . '/signatures/' . $company['directors_signature'])) {
                            $html .= '<img src="signatures/' . $company['directors_signature'] . '" width="80">';
                        } else {
                            $html .= '____________________________';
                        }
                    $html .= '</td>
                </tr>
            </table>
        </div>';

        $mpdf->WriteHTML($html);
        $mpdf->Output($filepath, \Mpdf\Output\Destination::FILE);

        $pdf_files[] = [
            'local' => $filepath,
            'remote' => $remote_dir . $filename,
            'name' => $filename,
        ];
    }

    $upload_results = [];

    foreach ($pdf_files as $file) {
        $success = ftp_put($conn_id, $file['remote'], $file['local'], FTP_BINARY);
        $upload_results[] = [
            'file' => $file['name'],
            'uploaded' => $success
        ];
    }

    ftp_close($conn_id);

    // Final JSON response
    header('Content-Type: application/json');

    if (count($pdf_files) === 0) {
        http_response_code(404);
        echo json_encode([
            'status' => 'no_invoices',
            'message' => 'No active invoices for this customer.'
        ]);
    } else {
        $all_uploaded = array_reduce($upload_results, fn($carry, $item) => $carry && $item['uploaded'], true);
        
        http_response_code(200); // ✅ Add this

        echo json_encode([
            'status' => $all_uploaded ? 'success' : 'partial',
            'uploaded_files' => $upload_results
        ]);
    }

    exit();

