<?php
    include_once 'model/sales_model.php';
    

    $sales_model = new sales_model();
    
    $incomplete_transactions = $sales_model->getIncompleteTransactions();

?>

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD - Incomplete Transactions</title>
            <?php include_once 'css_links.php'; ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">

                    <?php include 'menu_finance.php'; ?>

                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Sales </small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                            <!-- Left side: Title -->
                                            <div>
                                                <h2 class="mb-0">Sales Management</h2>
                                            </div>

                                            <!-- Center: Title -->
                                            <div class="text-center flex-grow-1">
                                                <h5 class="mb-0">Review Incomplete Transactions</h5>
                                            </div>

                                            <!-- Right side: Back Button -->
                                            <ul class="nav navbar-right panel_toolbox mb-0">
                                                <li>
                                                    <a class="dropdown-item" href="dashboard.php">
                                                        <button class="btn btn-secondary btn-sm">
                                                            <i class="fa fa-arrow-left"></i> Back
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box table-responsive">                                                          
                                                        <?php if (!empty($incomplete_transactions)) { ?>
                                                            <table class="table table-bordered">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Transaction Date</th>
                                                                        <th>Transaction Type</th>
                                                                        <th>Sales Number</th>
                                                                        <th>Operator</th> 
                                                                        <th>Status</th> 
                                                                        <th>Total Bill</th>    
                                                                        <th style="width:10%;text-align: center;">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php foreach ($incomplete_transactions['transactions'] as $data): ?>
                                                                    <?php
                                                                        // Default color
                                                                        $bgClass = 'table-info';

                                                                        // Calculate age of the transaction in hours
                                                                        $hoursElapsed = (time() - strtotime($data['date_captured'])) / 3600;

                                                                        if ($data['transaction_status'] === 'Cancelled Payment') {
                                                                            $bgClass = 'bg-danger text-white';
                                                                        } elseif ($data['transaction_status'] === 'Unsaved Invoice') {
                                                                            $bgClass = 'bg-warning text-black';
                                                                        } elseif ($data['transaction_status'] === 'Incomplete Cash Sale') {
                                                                            if ($hoursElapsed > 24) {
                                                                                $bgClass = 'bg-danger text-white';
                                                                            } else {
                                                                                $bgClass = 'bg-info text-white';
                                                                            }
                                                                        }
                                                                    ?>
                                                                    <tr>
                                                                        <td><?= date('d F Y', strtotime($data['date_captured'])) ?></td>
                                                                        <td><?= htmlspecialchars($data['transaction_type']) ?></td>
                                                                        <td><?= htmlspecialchars($data['transaction_id']) ?></td>
                                                                        <td><?= htmlspecialchars($data['operator_name']) ?></td>
                                                                        <td class="<?= $bgClass ?>"><?= htmlspecialchars($data['transaction_status']) ?></td>
                                                                        <td style="text-align: right;"><?= number_format($data['total_amount'], 2) ?></td>
                                                                        <td style="text-align: center;">
                                                                            <button 
                                                                                class="btn btn-info btn-sm view-sales-items" 
                                                                                data-transaction="<?= htmlspecialchars($data['transaction_id']) ?>"
                                                                                data-operator="<?= htmlspecialchars($data['operator_name'])?>"
                                                                                title="View Sales Items">
                                                                                <i class="fa fa-eye"></i>
                                                                            </button>

                                                                            <button onclick="showDisabledNotification()" class="btn btn-info btn-sm" title="Settings">
                                                                                <i class="fa fa-cog"></i>
                                                                            </button>
                                                                        </td>

                                                                    </tr>
                                                                <?php endforeach; ?>


                                                            </table>
                                                        <?php } else { ?>
                                                            <div class="alert alert-info">
                                                                Incomplete Transactions at The moment
                                                            </div>
                                                        <?php } ?>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <!-- Modal -->
                    <div class="modal fade" id="salesItemsModal" tabindex="-1" role="dialog" aria-labelledby="salesItemsModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <div>
                                        <h3 class="modal-title">Incomplete Sale Items List</h3>
                                        <h5 class="modal-title text-muted">Sales Number: <span id="salesNumberDisplay"></span></h5>
                                        <span id="operatorName" class="text-primary d-block" style="font-size: 15px;"></span>
                                    </div>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span>&times;</span>
                                    </button>
                                </div>


                                <div class="modal-body" id="salesItemsContent">
                                    <p class="text-center">Loading...</p>
                                </div>
                            </div>
                        </div>
                    </div>


                    <?php 
                        include_once 'footer.php'; 
                    ?>
                </div>
            </div>

            <?php 
                include_once 'libraries.php'; 
            ?>
            <script>
                function showDisabledNotification() {
                    const type = 'warning';
                    const title = 'Feature Disabled';
                    const message = 'This feature is currently disabled.';

                    toastr[type](message, title);
                }
            </script>
            <script>
                $(document).on('click', '.view-sales-items', function () {
                    const salesNumber = $(this).data('transaction');
                    const operator_name = $(this).data('operator');

                    // Set sales number and operator name
                    $('#salesNumberDisplay').text(salesNumber);
                    $('#operatorName').text(`Operator: ${operator_name}`);

                    // Show modal with loading spinner
                    $('#salesItemsContent').html('<div class="text-center"><i class="fa fa-spinner fa-spin fa-2x text-primary"></i><p>Loading sales items...</p></div>');
                    $('#salesItemsModal').modal('show');

                    // Load item data after delay
                    setTimeout(() => {
                        $.ajax({
                            url: 'get_sales_items.php',
                            type: 'POST',
                            data: { sales_number: salesNumber },
                            success: function (response) {
                                $('#salesItemsContent').html(response);
                            },
                            error: function () {
                                $('#salesItemsContent').html('<div class="alert alert-danger">Failed to load data.</div>');
                            }
                        });
                    }, 3000);
                });
            </script>



        </body>
    </html>
