<?php
    include_once 'model/finance_model.php';
    include_once 'model/common_model.php';
    include_once 'model/sales_model.php';

    if (!isset($_GET['receipt_number'])) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Error',
            'message' => 'Invalid Receipt Number.'
        ];
        header('location:invoice_payments.php');
        exit();
    }

    $receipt_number = $_GET['receipt_number'];
    $finance_model = new finance_model();
    $common_model = new common_model();
    $sales_model = new sales_model();

    $company = $common_model->getCompanyDetails();
    // Fetch receipt details
    $receipt_data = $finance_model->getReceiptDetails($receipt_number);
    $customer_id =  $receipt_data['customer'];
    $amount_in_words = $receipt_data['amount_in_words'] = convertNumberToWords($receipt_data['amount_paid']);
    $sales_number = $receipt_data['sale_id'];
    $receipt_items = $sales_model->getReceiptItems($sales_number);

    function convertNumberToWords($number) {
        $formatter = new NumberFormatter("en", NumberFormatter::SPELLOUT);
        $words = $formatter->format($number);

        // Capitalize first letter & append "Kwacha"
        return ucwords($words) . " Kwacha";
    }

    $product_names = array_map(function($item) {
        return $item['product_name'];
    }, $receipt_items);

    $receipt_data['product_name'] = implode(', ', $product_names);

    

    if (!$receipt_data && !$company) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Not Found',
            'message' => 'No receipt found for the given number.'
        ];
        header('location:invoice_payments.php');
        exit();
    }
?>

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>Invoice Receipt</title>
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <?php include_once 'css_links.php'; ?>           
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
                    <?php 
                        include 'menu_finance.php'; 
                    ?>

                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Invoice Payment Details</small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                            <!-- Left side: Title -->
                                            <div>
                                                <h2 class="mb-0">Sales Management </h2>
                                            </div>

                                            <!-- Center: Title -->
                                            <div class="text-center flex-grow-1">
                                                <h5 class="mb-0">Invoice payment Receipt</h5>
                                            </div>

                                            <!-- Right side: Back Button -->
                                            <ul class="nav navbar-right panel_toolbox mb-0 d-flex align-items-center" style="gap: 8px;">
                                                <?php include 'components/action_buttons.php'; ?>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:void(0);" onclick="history.back();">
                                                        <button class="btn btn-secondary btn-sm">
                                                            <i class="fa fa-arrow-left"></i> Back
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        
                                        
                                        <div class="x_content">
                                            <div class="row justify-content-left">
                                                <div class="col-md-4">
                                                    <!-- Stylish Wrapper -->
                                                   <div id="print-area" style="border: 1px solid #e0e0e0; padding: 25px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.05); background: #fff; position: relative;">
                                                    <?php if (isset($receipt_data['payment_state']) && $receipt_data['payment_state'] == 0): ?>
                                                        <div class="cancelled-watermark">CANCELLED</div>
                                                    <?php endif; ?>

                                                    <?php if (isset($receipt_data['payment_state']) && $receipt_data['payment_state'] == 0): ?>
                                                        <div style="position: absolute; top: 250px; left: 20px; right: 0; text-align: left; z-index: 1000; pointer-events: none;">
                                                            <span style="
                                                                display: inline-block;
                                                                transform: rotate(-30deg);
                                                                font-size: 35px;
                                                                color: rgba(220, 53, 69, 0.3);
                                                                font-weight: bold;
                                                                border: 4px dashed rgba(220, 53, 69, 0.4);
                                                                padding: 10px 40px;
                                                                background-color: rgba(255, 255, 255, 0.2);
                                                            ">CANCELLED PAYMENT</span>
                                                        </div>
                                                    <?php endif; ?>




                                                        
                                                        <!-- Receipt Number -->
                                                        <div class="text-center mb-3">
                                                            <h4 style="font-weight: 600; color: #333;">RECEIPT No: <?= $receipt_number ?></h4>
                                                        </div>

                                                        <!-- Company Logo -->
                                                        <div class="text-center mb-3">
                                                            <?php if (!empty($company['logo'])): ?>
                                                                <img src="images/<?= $company['logo'] ?>" alt="Company Logo" height="80" style="border-radius: 4px;">
                                                            <?php endif; ?>
                                                        </div>

                                                        <!-- Company Contact Info -->
                                                        <div class="text-center mb-4" style="font-size: 15px; color: #555; line-height: 1.6;">
                                                            <?= nl2br($company['physical_location']) ?><br>
                                                            <?= $company['postal_address'] ?><br>
                                                            Tel: <?= $company['phone_number'] ?> / <?= $company['alt_phone'] ?><br>
                                                            Email: <?= $company['email'] ?>
                                                        </div>

                                                        <!-- Date Issued -->
                                                        <div class="text-right mb-4" style="font-size: 15px; color: #333;">
                                                            <strong>Date:</strong> <?= date('d F, Y', strtotime($receipt_data['payment_date'])) ?>
                                                        </div>

                                                        <!-- Receipt Body -->
                                                        <div class="mb-4" style="font-size: 16px; color: #333;">
                                                            <p><strong>Received from:</strong> <span style="border-bottom: 1px dotted #666;"><?= $receipt_data['customer_name'] ?></span></p>
                                                            <p><strong>The sum of:</strong> <span style="border-bottom: 1px dotted #666;"><?= $amount_in_words ?> only</span></p>
                                                            <p style="font-size: 20px;"><strong>Amount:</strong> <span style="border-bottom: 1px solid #000;">K <?= number_format($receipt_data['amount_paid'], 2) ?></span></p>
                                                            <p><strong>Being in Payment of:</strong> <span style="border-bottom: 1px dotted #666;"><?= $receipt_data['product_name'] ?></span></p>
                                                            <?php if ($receipt_data['payment_state']==1){ ?>
                                                                <p><strong>New Balance:</strong> <span style="border-bottom: 1px dotted #666;">K <?= number_format($receipt_data['balance'], 2) ?></span></p>
                                                            <?php
                                                                }
                                                            ?>
                                                        </div>

                                                        <!-- Footer -->
                                                        <div class="row align-items-end">
                                                            <div class="col-6">
                                                                <p style="font-style: italic;">With thanks</p>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                <?php if (!empty($company['directors_signature'])): ?>
                                                                    <img src="signatures/<?= $company['directors_signature'] ?>" alt="Director's Signature" height="50"><br>
                                                                <?php endif; ?>
                                                                <span style="font-size: 13px; color: #555;">Signature</span>
                                                            </div>
                                                        </div>
                                                    </div> <!-- end of stylish wrapper -->
                                                </div>
                                            </div>
                                        </div>






                                        


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->
                    <?php 
                        include_once 'footer.php'; 
                    ?>
                </div>
            </div>
            <?php 
                include_once 'libraries.php'; 
            ?>

        </body>
    </html>