<?php
    include_once 'model/orders_model.php';  // Assuming you have an invoice model
    include_once 'model/customers_model.php';  // If necessary for fetching customer details
    include_once 'model/finance_model.php';

    $orders_model = new orders_model();
    $customers_model = new customers_model();
    $finance_model = new finance_model();
    
    $invoice_payments = $finance_model->getInvoicePayments();

?>

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD - Invoice Payments</title>
            <?php include_once 'css_links.php'; ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">

                    <?php include 'menu_finance.php'; ?>

                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Invoices </small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                            <!-- Left side: Title -->
                                            <div>
                                                <h2 class="mb-0">Invoice Payments</h2>
                                            </div>

                                            <!-- Center: Title -->
                                            <div class="text-center flex-grow-1">
                                                <h5 class="mb-0">Invoice Payments</h5>
                                            </div>

                                            <!-- Right side: Back Button -->
                                            <ul class="nav navbar-right panel_toolbox mb-0">
                                                <li>
                                                    <a class="dropdown-item" href="dashboard.php">
                                                        <button class="btn btn-secondary btn-sm">
                                                            <i class="fa fa-arrow-left"></i> Back
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box table-responsive">                                                          
                                                        <?php if (!empty($invoice_payments)) { ?>
                                                            <table class="table table-bordered" id="invoice-payments">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Payment Date</th>
                                                                        <th>Receipt Number</th>
                                                                        <th>Invoice Number</th>
                                                                        <th>Customer Name</th>
                                                                        <th>Payment Method</th>                                                                
                                                                        <th>Transaction ID</th>
                                                                        <th>Operator</th>
                                                                        <th>Payment Status</th>
                                                                        <th>Amount Paid</th>    
                                                                        <th style="width:10%;text-align: center;">Action</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php foreach ($invoice_payments as $pay) { ?>
                                                                        <tr>
                                                                            <td><?php echo date('d F Y', strtotime($pay['payment_date'])); ?></td>
                                                                            <td><?php echo $pay['receipt_number'] ?></td>
                                                                            <td><?php echo htmlspecialchars($pay['invoice_number']); ?></td>
                                                                            <td><?php echo htmlspecialchars($pay['customer_name']); ?></td>
                                                                            <td><?php echo $pay['payment_method'] ?></td>
                                                                            <td><?php echo $pay['transction_id'] ?></td>
                                                                            <td><?php echo $pay['operator_name'] ?></td>
                                                                            <td style="text-align: right;"><?php echo number_format($pay['amount_paid'],2) ?></td>
                                                                            <td class="<?php
                                                                                // Adding color-coding based on invoice status
                                                                                $status = $pay['payment_state'];
                                                                                switch ($status) {
                                                                                    case 0:
                                                                                        echo 'bg-warning text-dark'; // Pending or unpaid invoices
                                                                                        break;
                                                                                    case 1:
                                                                                        echo 'bg-success text-white'; // Pending or unpaid invoices
                                                                                        break;
                                                                                    case 2:
                                                                                        echo 'bg-success text-white'; // Paid invoices
                                                                                        break;
                                                                                    case 3:
                                                                                        echo 'bg-danger text-white'; // Cancelled invoices
                                                                                        break;
                                                                                    default:
                                                                                        echo '';
                                                                                }
                                                                            ?>">
                                                                                <?php echo htmlspecialchars(ucfirst($pay['payment_status'])); ?>
                                                                            </td>
                                                                            
                                                                            <td style="text-align: center;">
                                                                                <?php
                                                                                    $url = "invoice_payment_receipt.php?receipt_number=" . $pay['receipt_number'];
                                                                                ?>

                                                                                <a href="<?php echo $url; ?>" class="btn btn-info btn-sm" title="View Invoice Details">
                                                                                    <i class="fa fa-receipt"></i>
                                                                                </a>

                                                                                <?php if ($pay['payment_state'] == 1 && !empty($pay['pay_id'])): ?>
                                                                                    <button class="btn btn-danger btn-sm cancel-invoice" 
                                                                                        data-invoice-id="<?= htmlspecialchars($pay['pay_id']) ?>" 
                                                                                        data-receipt_number="<?= htmlspecialchars($pay['receipt_number']) ?>" 
                                                                                        data-action="cancel"
                                                                                        data-customer="<?= htmlspecialchars($pay['customer_name']) ?>"
                                                                                        data-amount="<?= number_format($pay['amount_paid'], 2) ?>"
                                                                                        data-date="<?= date('d M Y H:i', strtotime($pay['payment_date'])) ?>"
                                                                                        data-transaction="<?= htmlspecialchars($pay['transction_id']) ?>"
                                                                                        title="Cancel Invoice Payment">
                                                                                        <i class="fa fa-times-circle"></i>
                                                                                    </button>
                                                                                <?php endif; ?>

                                                                                <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                                    <button class="btn btn-info btn-sm">
                                                                                        <i class="fa fa-cog"></i>
                                                                                    </button>
                                                                                </a>
                                                                            </td>
                                                                            
                                                                        </tr>
                                                                    <?php } ?>
                                                                </tbody>
                                                            </table>
                                                        <?php } else { ?>
                                                            <div class="alert alert-info">
                                                                No Invoice Payments Submitted at the moment
                                                            </div>
                                                        <?php } ?>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php 
                        include_once 'footer.php'; 
                    ?>
                </div>
            </div>

            <?php 
                include_once 'libraries.php'; 
            ?>
            <script>
                $(document).ready(function () {
                if (!$.fn.DataTable.isDataTable('#invoice-payments')) {
                    $('#invoice-payments').DataTable({
                    order: [[0, 'desc']],
                    responsive: true,
                    searching: true,
                    paging: true,
                    pageLength: 50
                    });
                }
                });
            </script>
            <script>
                function showDisabledNotification() {
                    const type = 'warning';
                    const title = 'Feature Disabled';
                    const message = 'This feature is currently disabled.';

                    toastr[type](message, title);
                }
            </script>
            <script>
                $(document).on('click', '.cancel-invoice', function () {
                    const invoice_id = $(this).data('invoice-id');
                    const action = $(this).data('action'); // 'cancel' or 'resume'
                    const newStatus = action === 'cancel' ? 0 : 1;

                    // Common details pulled from data attributes
                    const customer = $(this).data('customer');
                    const amount = $(this).data('amount');
                    const date = $(this).data('date');
                    const transaction = $(this).data('transaction');
                    const receiptNumber = $(this).data('receipt_number');

                    // Compose HTML with details for confirmation dialog
                    const detailsHtml = `
                        <div style="text-align: left;">
                            <p><strong>Customer:</strong> ${customer}</p>
                            <p><strong>Amount:</strong> ${amount}</p>
                            <p><strong>Date:</strong> ${date}</p>
                            <p><strong>Transaction ID:</strong> ${transaction}</p>
                        </div>
                        `;


                    if (action === 'cancel') {
                        Swal.fire({
                            title: 'Cancel Invoice payment?',
                            html: detailsHtml + '<input id="cancelReason" class="form-control mt-2" placeholder="Reason for cancellation">',
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonText: 'Cancel Payment',
                            cancelButtonText: 'No, go back',
                            preConfirm: () => {
                                const reason = document.getElementById('cancelReason').value.trim();
                                if (!reason) {
                                    Swal.showValidationMessage('You must provide a reason!');
                                }
                                return reason;
                            }
                        }).then((result) => {
                            if (result.isConfirmed) {
                                const reason = encodeURIComponent(result.value);
                                const targetUrl = `controllers/sales_controller.php?receipt_number=${receiptNumber}&action=cancelinvoicepayment&invoice_id=${invoice_id}&status=${newStatus}&reason=${reason}`;
                                window.location.href = targetUrl;
                            }
                        });
                    } else {
                        // Resume confirmation
                        Swal.fire({
                            title: 'Approve payment?',
                            html: detailsHtml,
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonText: 'Yes, approve',
                            cancelButtonText: 'No, go back'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                const targetUrl = `controllers/sales_controller.php?action=cancelinvoicepayment&invoice_id=${invoice_id}&status=${newStatus}`;
                                window.location.href = targetUrl;
                            }
                        });
                    }
                });

            </script>


        </body>
    </html>
