<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.png" type="image/ico" />
    <title>Powertex LTD - Employee Leave Data</title>
    <?php include_once 'css_links.php'; ?>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <?php 
                include 'menu_finance.php'; 
                include_once 'model/employees_model.php';  

                $employee_code = $_GET['employee_code'] ?? null;

                $employees_model = new employees_model();
                $leave_requests = $employees_model->getleaveRequests();
            ?>

            <!-- page content -->
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title">
                        <div class="title_left">
                            <h3><small>Employee Leave Requests</small></h3>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <div class="x_panel">
                                <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                    <!-- Left side: Title -->
                                    <div>
                                        <h2 class="mb-0">Employee Leave Requests</h2>
                                    </div>

                                    <!-- Center: Title -->
                                    <div class="text-center flex-grow-1">
                                        <h5 class="mb-0">Leave Requests</h5>
                                    </div>

                                    <!-- Right side: Back Button -->
                                    <ul class="nav navbar-right panel_toolbox mb-0">
                                        <li>
                                            <button class="btn btn-secondary btn-sm" style="float: right;" onclick="history.back();">
                                                <i class="fa fa-arrow-left"></i> Back
                                            </button>

                                            <button class="btn btn-info btn-sm" style="float: right;">
                                                 <a rel="facebox" style="color: #fff;" href="new_leave.php"> Apply For Leave <i class="fa fa-receipt"></i></a>
                                            </button> 
                                            
                                        </li>
                                    </ul>
                                </div>
                                <div class="clearfix"></div>

                                <div class="x_content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card-box table-responsive">                                                
                                                <?php if (!empty($leave_requests)): ?>
                                                        <table class="table table-striped table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>Requested For</th>
                                                                    <th>Leave Requested</th>
                                                                    <th>Requested Start Date</th>
                                                                    <th>Requsted End Date</th>
                                                                    <th>Requested Number of Days</th>
                                                                    <th>Available Leave Days</th>
                                                                    <th>Requested By</th>
                                                                    <th style="width: 10%;">Action</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach ($leave_requests as $leave): ?>
                                                                    <tr>
                                                                        <td><?= htmlspecialchars($leave['fullname']) ?></td>
                                                                        <td><?= htmlspecialchars($leave['leave_type']) ?></td>
                                                                        <td><?= date('d M Y', strtotime($leave['requested_start_date'])) ?></td>
                                                                        <td><?= date('d M Y', strtotime($leave['requested_end_date'])) ?></td>
                                                                        <td><?= htmlspecialchars($leave['requested_numdays']) ?></td>
                                                                        <td><?= htmlspecialchars($leave['available_days']) ?></td>
                                                                        <td><?= htmlspecialchars($leave['operator']) ?></td>
                                                                        <td style="text-align: center;">
                                                                            <a title="Leave Slip" href="leave_slip.php?id=<?php echo $leave['id']?>">
                                                                                <button class="btn btn-info btn-sm">
                                                                                    <i class="fa fa-receipt"></i>
                                                                                </button>
                                                                            </a>
                                                                            <!-- Approve Button -->
                                                                            <button type="button" class="btn btn-info btn-sm action-approve" data-start-date="<?= $leave['requested_start_date']?>" data-end-date="<?= $leave['requested_end_date']?>" data-employee-name="<?= $leave['fullname']?>" data-request-id="<?= $leave['id'] ?>"  data-num-days="<?= $leave['requested_numdays'] ?>">
                                                                                <i class="fa fa-check-circle"></i>
                                                                            </button>



                                                                            <!-- Disapprove Button -->
                                                                            <button type="button" title="Disapprove Leave" class="btn btn-danger btn-sm action-disapprove" data-start-date="<?= $leave['requested_start_date']?>" data-end-date="<?= $leave['requested_end_date']?>" data-employee-name="<?= $leave['fullname']?>" data-request-id="<?= $leave['id'] ?>"  data-num-days="<?= $leave['requested_numdays'] ?>">
                                                                                <i class="fa fa-times-circle"></i>
                                                                            </button>

                                                                        </td>
                                                                        
                                                                    </tr>
                                                                <?php endforeach; ?>
                                                            </tbody>
                                                        </table>
                                                    <?php else: ?>
                                                        <div class="alert alert-warning">
                                                            No Pending Requests at the moment
                                                        </div>
                                                    <?php endif; ?>


                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /page content -->

            <?php include_once 'footer.php'; ?>
        </div>
    </div>

    <?php include_once 'libraries.php'; ?>
    <script>
    function formatDate(dateStr) {
        const options = { year: 'numeric', month: 'long', day: 'numeric' };
        return new Date(dateStr).toLocaleDateString('en-GB', options);
    }

    document.querySelectorAll('.action-disapprove').forEach(button => {
        button.addEventListener('click', function () {
            const requestId = button.getAttribute('data-request-id');
            const employeeName = button.getAttribute('data-employee-name');
            const requestedStartDate = button.getAttribute('data-start-date');
            const requestedEndDate = button.getAttribute('data-end-date');
            const requestedNumDays = button.getAttribute('data-num-days');

            Swal.fire({
                title: 'Disapprove Leave',
                icon: 'warning',
                html: `
                    <div style="padding: 10px; font-size: 18px;">
                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Employee Name:</label>
                            <input type="text" class="form-control" value="${employeeName}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Requested Start Date:</label>
                            <input type="text" class="form-control" value="${formatDate(requestedStartDate)}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Requested End Date:</label>
                            <input type="text" class="form-control" value="${formatDate(requestedEndDate)}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Number of Days:</label>
                            <input type="text"  class="form-control" value="${requestedNumDays}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="margin-top: 20px;">
                            <label for="disapproval_reason" style="display: block; margin-bottom: 5px;">Reason for Disapproval:</label>
                            <textarea class="form-control" id="disapproval_reason" class="swal2-textarea" placeholder="Enter reason..." style="width: 100%; height: 100px;"></textarea>
                        </div>
                    </div>
                `,
                focusConfirm: false,
                showCancelButton: true,
                confirmButtonText: 'Submit Disapproval',
                cancelButtonText: 'Cancel',
                customClass: {
                    confirmButton: 'swal2-disapprove-btn'
                },
                preConfirm: () => {
                    const reason = document.getElementById('disapproval_reason').value.trim();

                    if (!reason) {
                        Swal.showValidationMessage('Please enter a reason for disapproval.');
                        return false;
                    }

                    return {
                        requestId,
                        reason
                    };
                }
            }).then(result => {
                if (result.isConfirmed) {
                    const data = result.value;

                    // Confirm message
                    Swal.fire({
                        icon: 'success',
                        title: 'Leave Disapproved',
                        html: `<strong>Reason:</strong> ${data.reason}`
                    });

                    // Send disapproval to backend
                    fetch('disapprove_leave.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(data)
                    })
                    .then(response => response.json())
                    .then(result => {
                        if (result.success) {
                            Swal.fire('Success', 'Leave disapproved successfully.', 'success');
                            setTimeout(() => { window.location.reload(); }, 3000);
                        } else {
                            Swal.fire('Error', result.message || 'Disapproval failed.', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire('Error', 'An error occurred while submitting.', 'error');
                    });
                }
            });
        });
    });
</script>

<script>
    function formatDate(dateStr) {
        const options = { year: 'numeric', month: 'long', day: 'numeric' };
        return new Date(dateStr).toLocaleDateString('en-GB', options);
    }

    document.querySelectorAll('.action-approve').forEach(button => {
        button.addEventListener('click', function () {
            const requestId = button.getAttribute('data-request-id');
            const employeeName = button.getAttribute('data-employee-name');
            const requestedStartDate = button.getAttribute('data-start-date');
            const requestedEndDate = button.getAttribute('data-end-date');
            const requestedNumDays = button.getAttribute('data-num-days');

            Swal.fire({
                title: 'Approve Leave',
                icon: 'info',
                html: `
                    <div style="padding: 10px; font-size: 18px;">

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="employee_name" style="width: 200px; text-align: right; margin-right: 40px;">Employee Name:</label>
                            <input type="text" id="employee_name" class="form-control" value="${employeeName}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="start_date" style="width: 200px; text-align: right; margin-right: 40px;">Requested Start Date:</label>
                            <input type="text" id="start_date" class="form-control" value="${formatDate(requestedStartDate)}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="end_date" style="width: 200px; text-align: right; margin-right: 40px;">Requested End Date:</label>
                            <input type="text" id="end_date" class="form-control" value="${formatDate(requestedEndDate)}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="num_days" style="width: 200px; text-align: right; margin-right: 40px;">Requested Number of Days:</label>
                            <input type="text" id="num_days" class="form-control" value="${requestedNumDays}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="approved_start_date" style="width: 200px; text-align: right; margin-right: 40px;">Approved Start Date:</label>
                            <input type="date" id="approved_start_date" class="form-control" min="<?= date('Y-m-d') ?>" 
                                style="width: 250px; height: 40px;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="approved_end_date" style="width: 200px; text-align: right; margin-right: 40px;">Approved End Date:</label>
                            <input type="date" id="approved_end_date" class="form-control" min="<?= date('Y-m-d') ?>" 
                                style="width: 250px; height: 40px;">
                        </div>

                        <div style="display: flex; align-items: center;">
                            <label for="approved_num_days" style="width: 200px; text-align: right; margin-right: 40px;">Number of Approved Days:</label>
                            <input type="text" id="approved_num_days" class="form-control" readonly 
                                style="width: 230px; height: 40px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                    </div>`,
                focusConfirm: false,
                showCancelButton: true,
                confirmButtonText: 'Confirm Approval',
                cancelButtonText: 'Cancel',
                didOpen: () => {
                    const startInput = document.getElementById('approved_start_date');
                    const endInput = document.getElementById('approved_end_date');
                    const daysInput = document.getElementById('approved_num_days');

                    function countWeekdays(startDate, endDate) {
                        let count = 0;
                        const current = new Date(startDate);

                        while (current <= endDate) {
                            const day = current.getDay();
                            if (day !== 0 && day !== 6) { // Exclude Sunday(0) & Saturday(6)
                                count++;
                            }
                            current.setDate(current.getDate() + 1);
                        }
                        return count;
                    }

                    function updateApprovedDays() {
                        const start = new Date(startInput.value);
                        const end = new Date(endInput.value);

                        if (!isNaN(start) && !isNaN(end) && end >= start) {
                            const diff = countWeekdays(start, end);
                            daysInput.value = diff;
                        } else {
                            daysInput.value = '';
                        }
                    }

                    startInput.addEventListener('change', updateApprovedDays);
                    endInput.addEventListener('change', updateApprovedDays);
                },
                preConfirm: () => {
                    const startDate = document.getElementById('approved_start_date').value;
                    const endDate = document.getElementById('approved_end_date').value;
                    const numDays = document.getElementById('approved_num_days').value;

                    if (!startDate || !endDate || !numDays) {
                        Swal.showValidationMessage('All fields must be completed and valid.');
                        return false;
                    }

                    return {
                        startDate,
                        endDate,
                        numDays,
                        requestId
                    };
                }
            }).then(result => {
                if (result.isConfirmed) {
                    const data = result.value;

                    Swal.fire({
                        icon: 'success',
                        title: 'Leave Approved',
                        html: `
                            <strong>Approved Start Date:</strong> ${data.startDate}<br>
                            <strong>Approved End Date:</strong> ${data.endDate}<br>
                            <strong>Total Days Approved:</strong> ${data.numDays}
                        `
                    });

                    fetch('approve_leave.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(data)
                    })
                        .then(response => response.json())
                        .then(result => {
                            if (result.success) {
                                Swal.fire('Success', 'Leave request approved successfully.', 'success');
                                setTimeout(() => { window.location.reload(); }, 4000);
                            } else {
                                Swal.fire('Error', result.message || 'Failed to approve leave.', 'error');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            Swal.fire('Error', 'An error occurred while saving.', 'error');
                        });
                }
            });
        });
    });
</script>




</body>
</html>
