<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
      </head>

      <body class="nav-md">
        <div class="container body">
          <div class="main_container">
            
            <?php
              include 'menu_finance.php';
              include_once 'model/common_model.php';

              $common_model = new common_model();
              $locations = $common_model->listLocations();

            ?>
            <!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3><small>Locations </small></h3>
              </div>

              <div class="title_right">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search for Location...">
                    <span class="input-group-btn">
                      <button class="btn btn-secondary" type="button">Go!</button>
                    </span>
                  </div>
                </div>
              </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">
              

              

              <div class="col-md-12 col-sm-12 ">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Manage Locations</h2>
                    <ul class="nav navbar-right panel_toolbox">
                        <li>
                            <a class="dropdown-item" rel="facebox" href="new_location.php">
                                <button class="btn btn-info">New Location</button>
                            </a>
                        </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                      <div class="row">
                          <div class="col-sm-12">
                            <div class="card-box table-responsive">
                    
                    <table id="locations-table" class="table table-striped table-bordered" style="width:100%">
                      <thead>
                        <tr>
                          <th>Location</th>
                          <th>District</th>
                          <th>Bounding Region</th>
                          <th style="text-align:center;">Affiliations</th>
                          <th>Location Status</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                            foreach($locations as $data):
                        ?>
                          <tr>
                            <td><?php echo $data['location_name']?></td>
                            <td><?php echo $data['district_name']?></td>
                            <td><?php echo $data['region']?></td>
                            <td style="text-align: center;"><?php echo $data['total_usage']?></td>
                            <td class="<?= $data['location_state'] == 1 ? 'bg-success text-white' : 'bg-danger text-white' ?>" style="text-align: left;">
                                <?= htmlspecialchars($data['location_status']) ?>
                            </td>
                            <td>
                              <a href="edit_location.php?loc_id=<?php echo $data['loc_id']?>" rel="facebox">
                                <button class="btn btn-warning btn-sm"><i class="fa fa-edit"></i></button>
                              </a>

                              <a>
                                <button class="btn btn-info btn-sm"><i class="fa fa-cog"></i></button>
                              </a>
                            </td>

                          </tr>
                        <?php
                            endforeach;
                        ?>
                        
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
                </div>
              </div>

              

              
            </div>
          </div>
        </div>
        <!-- /page content -->
          </div>
          <!-- /page content -->

        <?php
          include_once 'footer.php';
        ?>
      </div>
    </div>

    <?php
      include_once 'libraries.php';
    ?>
    <script>
    $(document).ready(function () {
        let table = $('#locations-table').DataTable({
            responsive: true,
            ordering: true,
            pageLength: 25,
            order: [
                [4, 'asc'],  // 1 = Enabled comes before 0 = Disabled
                [3, 'desc'], // Affiliations, descending
                [0, 'asc']   // Location name, ascending
            ],
            columnDefs: [
                {
                    targets: -1, // If you have an Action column at the end
                    width: "120px",
                    className: "text-center",
                    orderable: false
                }
            ]
        });
  
        $('#search_query').on('keyup', function () {
            table.search(this.value).draw();
        });
    });
  </script>
  



    
	
  </body>
</html>
