<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
          <?php
            include 'menu_finance.php';
            include_once 'model/stock_model.php';

            $stock_model = new stock_model();
            $list_products = $stock_model->getAllProducts();

          ?>
          <!-- page content -->
          <div class="right_col" role="main">
            <div class="">
              <div class="row">
                <div class="col-md-12 col-sm-12 ">
                  <div class="x_panel">
                    <div class="x_title d-flex justify-content-between align-items-center">
                      <!-- Left Title -->
                      <h2 class="mb-0">Manage Products</h2>
                      <!-- Center Title -->
                      <h2 class="mb-0 text-center flex-grow-1">Overall Products Overview</h2>
                      <!-- Buttons (Right Aligned) -->
                      <div class="d-flex gap-2 align-items-center flex-wrap">

                      <!-- Generate PDF -->
                      <form action="generate_pdf.php" method="post" class="mb-0">
                        <input type="hidden" name="overall_stock" value="overall_stock" readonly>
                        <button type="submit" class="btn btn-info d-flex align-items-center">
                          Generate&nbsp;PDF&nbsp;<i class="fa fa-file-pdf ms-1"></i>
                        </button>
                      </form>

                      <!-- New Product Button -->
                      <a rel="facebox" href="new_product.php">
                        <button class="btn btn-info d-flex align-items-center">
                          New Product&nbsp;<i class="fa fa-plus-circle ms-1"></i>
                        </button>
                      </a>

                      <!-- Import Products Button -->
                      <a rel="facebox" href="import_products.php">
                        <button class="btn btn-info d-flex align-items-center">
                          Import Products&nbsp;<i class="fa fa-download ms-1"></i>
                        </button>
                      </a>

                    </div>

                    </div>
                  </div>
                  <div class="x_content">
                    <div class="row">
                      <div class="col-sm-12">
                        <div class="card-box table-responsive">
                          <table id="products-table" class="table table-striped table-bordered table-sm" style="width:100%">
                            <thead>
                              <tr>
                                <th class="text-left">Product Name</th>
                                <th class="text-center">Product Code</th>
                                <th class="text-center">Branches</th>
                                <th class="text-center">Warehouses</th>
                                <th class="text-center">Total Locations</th>
                                <th class="text-center">Minimum Level</th>
                                <th class="text-center">Third Party Stock</th>
                                <th class="text-center">Overall Stock Projection</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Selling Price</th>
                                <th class="text-center" style="width:150px; white-space: nowrap;">Action</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php
                                  foreach($list_products as $data):
                                    // Compute total/overall stock from components
                                    $branchStock = (int)$data['total_branch_stock'];
                                    $warehouseStock = (int)$data['total_warehouse_stock'];
                                    $overall_locations = $branchStock + $warehouseStock;
                                    $thirdPartyStock = (int)$data['total_third_party_stock'];

                                    $overallStock = $branchStock + $warehouseStock + $thirdPartyStock;

                                    // Determine row background class
                                    $rowClass = '';
                                    if ($overallStock == 0) {
                                        $rowClass = 'bg-danger text-white';
                                    } elseif ($overallStock < (int)$data['min_order_level']) {
                                        $rowClass = 'bg-warning';
                                    }
                                                          ?>

                              <tr class="<?= $rowClass ?>" style="font-size: 13px; padding: 4px 8px; height: 25px;">
                                <td style="text-align: left;"><?php echo $data['product_name']?></td>
                                <td style="text-align: center;"><?php echo $data['product_code']?></td>
                                <td style="text-align: center;"><?php echo $branchStock ?></td>
                                <td style="text-align: center;"><?php echo $warehouseStock ?></td>
                                <td style="text-align: center;"><?php echo $overall_locations ?></td> <!-- Total Locations -->
                                <td style="text-align: center;"><?php echo $data['min_order_level']?></td>
                                <td style="text-align: center;"><?php echo $thirdPartyStock ?></td>
                                <td style="text-align: center;"><?php echo $overallStock ?></td> <!-- ✅ Corrected Overall Stock Projection -->
                                <?php
                                    $overallStock = (int)$data['overall_stock'];
                                    $minLevel = (int)$data['min_order_level'];
                                    $productState = (int)$data['product_state'];

                                    if ($productState == 0) {
                                        $productStatus = "Deactivated Product";
                                        $statusClass = 'bg-danger text-white';
                                    } elseif ($overallStock === 0) {
                                        $productStatus = "Out of Stock";
                                        $statusClass = 'bg-danger text-white';
                                    } elseif ($overallStock < $minLevel) {
                                        $productStatus = "Stock running Low";
                                        $statusClass = 'bg-warning text-dark';
                                    } elseif ($overallStock <= ($minLevel + 30)) {
                                        $productStatus = "Average Stock levels";
                                        $statusClass = 'bg-info text-white';
                                    } else {
                                        $productStatus = "Adequate Stock";
                                        $statusClass = 'bg-success text-white';
                                    }
                                ?>
                                
                                <td class="<?= $statusClass ?>">
                                    <?= htmlspecialchars($productStatus) ?>
                                </td>
                                  <td style="text-align: right;"> <?php echo $data['selling_price']?></td>
                                <td>
                                    <a title="Storage Summary" href="product_storage_summary.php?product_id=<?php echo $data['product_id']?>">
                                      <button class="btn btn-info btn-sm">
                                        <i class="fa fa-tasks"></i>
                                      </button>
                                    </a>

                                    <a rel="facebox" title="Edit Product" href="edit_product.php?product_id=<?php echo $data['product_id']?>">
                                        <button class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>
                                    </a>
                                    
                                    <a title="Product Details" href="product_details.php?product_id=<?php echo $data['product_id']?>">
                                      <button class="btn btn-info btn-sm"><i class="fa fa-eye"></i> </button>
                                    </a>

                                    <a title="Product Configuration" href="javascript:void(0);" onclick="showDisabledNotification()">
                                        <button class="btn btn-info btn-sm">
                                            <i class="fa fa-cog"></i>
                                        </button>
                                    </a>

                                    
                                </td>
                              </tr>

                              <?php
                                endforeach;
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /page content -->

          <?php
            include_once 'footer.php';
          ?>
        </div>
      </div>

      <?php
        include_once 'libraries.php';
      ?>
      <script>
        function showDisabledNotification() {
          const type = 'warning';
          const title = 'Feature Disabled';
          const message = 'This feature is currently disabled.';

          toastr[type](message, title);
        }
      </script>
      <script>
  $(document).ready(function () {
    let table = $('#products-table').DataTable({
      responsive: true,
      ordering: true,
      pageLength: 100,
      columnDefs: [
        {
          targets: -1, // Assuming "Action" is the last column; use correct index if different
          width: "250px",
          className: "text-center",
          orderable: false // Disable sorting for action column
        },
        {
          targets: [0], // Sorting the Product Name column
          orderData: [7, 0] // First sort by Overall Stock (column 7), then by Product Name (column 0)
        }
      ],
      order: [[7, 'desc'], [0, 'asc']], // Primary sort: Overall Stock (non-zero first), Secondary sort: Product Name
    });

    // Custom search
    $('#search_query').on('keyup', function () {
      table.search(this.value).draw();
    });
  });
</script>

    </body>
  </html>
