<?php  
session_start();
date_default_timezone_set('Africa/Blantyre');

// Check if session variables are set before accessing them
if (!isset($_SESSION['sess_username']) || !isset($_SESSION['sess_userrole']) || !isset($_SESSION['sess_employeecode']) || $_SESSION['sess_userrole'] != 'Administrator') {
    
    $_SESSION['notification']=[
      'title' => 'LOGOUT',
      'type' => 'error',
      'message' => 'User Session Expired, Please Login Again'
    ];
    header("Location: ../index.php");
    exit(); // Stop script execution after redirection
}

// Assign session values safely
  $username = $_SESSION['sess_username'];
  $emp_code = $_SESSION['sess_employeecode']; 
  $session_id = $_SESSION['sess_session'];

  include_once 'model/users_model.php';
  include_once 'model/companies_model.php';
  include_once 'model/stock_model.php';
  include_once 'model/common_model.php';
  include_once 'model/employees_model.php';

  $users_model = new users_model();
  $companies_model = new companies_model();
  $stock_model =  new stock_model();
  $common_model = new common_model();
  $employees_model = new employees_model();


  $user_details = $users_model->getuserDetails($username);
  $fullname = $user_details['fullname'];

  $third_party_companies = $companies_model->getThirdpartyCompanies();
  //User permissions
  $set_values = $common_model->getPermissions($username);

  $salesDisplay = $set_values['sales_display'];
  $paymentsDisplay = $set_values['payments_display'];

  $procurement_mode = $common_model->getProcurementModeSetting();

  if ($salesDisplay == 1) {
    $salesDisplaySetting = 'inline';
} else {
    $salesDisplaySetting = 'none';
}

if ($paymentsDisplay == 1) {
    $paymentsDisplaySetting = 'inline';
} else {
    $paymentsDisplaySetting = 'none';
}
function generateNextOrderNumber($stock_model) {
    $prefix = "ORD";

    do {
        $randomNumber = mt_rand(100000, 999999); // generates a 6-digit random number
        $orderNumber = $prefix . $randomNumber;
    } while ($stock_model->orderNumberExists($orderNumber)); // ensure uniqueness

    return $orderNumber;
  }

  $order_number = generateNextOrderNumber($stock_model);



?>
<style>
.dropdown-menu.notifications {
  min-width: 320px;
  max-height: 400px;
  overflow-y: auto;
  padding: 0;
  border-radius: 10px;
  background-color: #ffffff;
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

.dropdown-menu.notifications h6.dropdown-header {
  font-size: 15px;
  background-color: #f1f3f5;
  padding: 12px 16px;
  margin: 0;
  border-bottom: 1px solid #dee2e6;
  font-weight: 600;
  color: #212529;
  text-transform: none; /* no caps */
}

.dropdown-item.notification-item {
  display: flex;
  align-items: center;
  padding: 12px 16px;
  font-size: 14px;
  border-bottom: 1px solid #f0f0f0;
  white-space: normal;
  line-height: 1.5;
  color: #343a40;
  text-transform: none;
  text-decoration: none;
  transition: background-color 0.2s ease-in-out;
}
/* Remove arrows from number inputs */
input[type=number]::-webkit-outer-spin-button,
input[type=number]::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
}

input[type=number] {
    -moz-appearance: textfield; /* Firefox */
}


.dropdown-item.notification-item:hover {
  background-color: #f8f9fa;
}

.notification-item .icon {
  font-size: 18px;
  color: #0d6efd;
  margin-right: 12px;
  flex-shrink: 0;
  width: 20px;
  text-align: center;
}

.dropdown-empty {
  padding: 20px;
  color: #adb5bd;
  text-align: center;
  font-style: italic;
  font-size: 14px;
}
/* Keep nav layout stable */
.nav_menu {
    display: flex;
    align-items: center;
    height: 58px; /* Match your existing height */
}

/* Scroll container */
.top-scroll-notifications {
    flex: 1;
    overflow: hidden;
    white-space: nowrap;
    height: 58px;
    display: flex;
    align-items: center;
    margin: 0 20px;
}

/* Moving track */
.scroll-track {
    display: inline-block;
    white-space: nowrap;
    animation: scroll-left 20s linear infinite;
}

/* Individual notification */
.notif-item {
    display: inline-block;
    margin-right: 60px;
    font-size: 16px;
    color: #333;
}

/* Animation */
@keyframes scroll-left {
    0% {
        transform: translateX(100%);
    }
    100% {
        transform: translateX(-100%);
    }
}

</style>              
  <div class="col-md-3 left_col">       
    <div class="left_col scroll-view">
      <div class="navbar nav_title" style="border: 0;">
        <a href="dashboard.php" class="site_title"><i class="fa fa-power-off"></i> <span>Powertex LTD</span></a>
      </div>

      <div class="clearfix"></div>
      <!-- menu profile quick info -->
      <div class="profile clearfix">
        <div class="profile_pic">
          <img src="images/default_avatar.png" alt="..." class="img-circle profile_img">
        </div>
        <div class="profile_info">
          <span>Welcome,</span>
          <h2><?php echo $fullname ?></h2>
        </div>
      </div>
      <!-- /menu profile quick info -->
      <br />
      <?php
        $current_page = basename($_SERVER['PHP_SELF']);
      ?>         
      <!-- sidebar menu -->
      <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
        <div class="menu_section">
          <ul class="nav side-menu">
            <li><a href="dashboard.php"><i class="fa fa-dashboard fa-2x"></i> Dashboard</a></li>

            <?php
              $is_inventory_page = preg_match('/^(stock_transfers|pending_transfers|delivery_note|warehouse_item_breakdown|branch_stock|warehouse_stock|branch_item_breakdown|manage_products|product_details|manage_warehouses|warehouse_details|manage_branches|branch_details|product_attributes|stock_transfer|scrap_collection|product_storage_summary)\.php$/', $current_page);
              ?>
              <li class="<?= $is_inventory_page ? 'active' : '' ?>">
                <a><i class="fa fa-cubes"></i> Inventory <span class="fa fa-chevron-down"></span></a>
                <ul class="nav child_menu" style="<?= $is_inventory_page ? 'display: block;' : '' ?>">
                  <li class="<?= preg_match('/^(manage_products|product_details|product_storage_summary)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="manage_products.php">View Products</a>
                  </li>
                  <li class="<?= preg_match('/^(stock_transfers|delivery_note|pending_transfers)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="stock_transfers.php">Stock Transfers</a>
                  </li>
                  <li class="<?= preg_match('/^(manage_warehouses|warehouse_details|warehouse_item_breakdown|warehouse_stock)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="manage_warehouses.php">Manage Warehouses</a>
                  </li>
                  <li class="<?= preg_match('/^(manage_branches|branch_details|branch_stock|branch_item_breakdown)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="manage_branches.php">Manage Branches</a>
                  </li>
                  <li class="<?= $current_page == 'product_attributes.php' ? 'current-page' : '' ?>">
                    <a href="product_attributes.php">Product Attributes</a>
                  </li>
                  <li class="<?= $current_page == 'scrap_collection.php' ? 'current-page' : '' ?>">
                    <a href="#">Scrap Collection</a>
                  </li>
                </ul>
              </li>

            <?php
              $is_customer_page = preg_match('/^(manage_customers|customer_database|customer_account|customer_details|customer_transactions|review_customer_approvals)\.php$/', $current_page);
            ?>
            <li class="<?= $is_customer_page ? 'active' : '' ?>">
              <a><i class="fa fa-users"></i>Customer Management<span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu" style="<?= $is_customer_page ? 'display: block;' : '' ?>">
                <li class="<?= preg_match('/^(manage_customers|customer_details|customer_transactions|review_customer_approvals)\.php$/', $current_page) ? 'current-page' : '' ?>">
                  <a href="manage_customers.php">Manage Customers</a>
                </li>

                <li class="<?= preg_match('/^(customer_database)\.php$/', $current_page) ? 'current-page' : '' ?>">
                  <a href="customer_database.php">Customer Database</a>
                </li>
              </ul>
            </li>

            <?php
              $is_banking_page = preg_match('/^(manage_expenses|accounts|new_account)/', $current_page);
            ?>
            <li class="<?= $is_banking_page ? 'active': '' ?>">
              <a>
                <i class="fa fa-university"></i>Banking Module <span class="fa fa-chevron-down"></span></a>
                <ul class="nav child_menu" style="<?= $is_banking_page ? 'display: block;' : '' ?>">
                  
                 
                 <li class="<?= preg_match('/^(bank_deposits)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="bank_deposits.php">Bank Deposits</a>
                 </li>

                 <li class="<?= preg_match('/^(manage_expenses)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="manage_expenses.php">Manage Expenses</a>
                 </li>

                 <li class="<?= preg_match('/^(accounts)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="accounts.php">Bank Accounts</a>
                 </li>
                </ul>
            </li>

            <?php
              $is_manage_sales_page = preg_match('/^(invoice|cash_sale_receipt|sales)/', $current_page);
            ?>
            <li class="<?= $is_manage_sales_page ? 'active' : '' ?>">
              <a><i class="fa fa-money-bill"></i> Manage Sales <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu" style="<?= $is_manage_sales_page ? 'display: block;' : '' ?>">

                <li class="<?= preg_match('/^(cash_sale_receipt)/', $current_page) ? 'current-page' : '' ?>">
                  <a href="cash_sales.php">Cash Sales</a>
                </li>

                <li>
                  <a href="open_invoices.php">Open Invoices</a>
                </li>

                <li>
                  <a href="closed_invoices.php">Closed Invoices</a>
                </li>

                <!-- Invoice Payments -->
                <li class="<?= preg_match('/^invoice_payments(\.php)?$|^invoice_payment_receipt(\.php)?$/', $current_page) ? 'current-page' : '' ?>">
                  <a href="invoice_payments.php">Invoice Payments</a>
                </li>

                <!-- Customer Invoices -->
                <li class="<?= preg_match('/^all_invoices(\.php)?$/', $current_page) ? 'current-page' : '' ?>">
                  <a href="all_invoices.php">Customer Invoices</a>
                </li>
                
                <li class="<?= preg_match('/^cancelled_payments(\.php)?$/', $current_page) ? 'current-page' : '' ?>">
                  <a href="cancelled_payments.php">Cancelled Payments</a>
                </li>

                <li>
                  <a href="cancelled_invoices.php">Cancelled Invoices</a>
                </li>

                <li>
                  <a href="incomplete_transactions.php">Incomplete Transactions</a>
                </li>


              </ul>
            </li>

            <li><a><i class="fa fa-truck"></i> Delivery Notes <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu">
                <li><a href="delivery_notes.php">Delivery Notes</a></li>
              </ul>
            </li>

            <li><a><i class="fa fa-list"></i> Services <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu">
                <li><a href="#">Manage Services</a></li>
              </ul>
            </li>

            
            <?php
              $is_manage_employee_page = preg_match('/^(manage_employees|leave_mamagement|leave_requests|manage_posts|register_employee|employee_details|leave_breakdown|leave_slip|list_birthdays)/', $current_page);
            ?>
            <li class="<?= $is_manage_employee_page ? 'active' : '' ?>">
              <a><i class="fa fa-users"></i>Manage Employees <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu" style="<?= $is_manage_employee_page ? 'display: block;' : '' ?>">

                  <li class="<?= preg_match('/^(manage_employees|employee_details|register_employee|list_birthdays)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="manage_employees.php">Manage Employees</a>
                  </li>

                  <li class="<?= preg_match('/^(leave_breakdown|leave_mamagement|leave_slip)/', $current_page) ? 'current-page' : '' ?>">
                    <a href="leave_mamagement.php">Leave Management</a>
                  </li>

                  <li>
                    <a href="leave_requests.php">Leave Requests</a>
                  </li>

                  <li>
                    <a href="manage_posts.php">Manage Posts</a>
                  </li>
              </ul>
            </li>

            <?php
              $is_third_party_page = preg_match('/^(incomplete_third_party_company_stock_transfers|shipment_document|third_party_companies|breakdown_third_party_transfers|third_party_products|third_party_company_details|initiate_transfer)\.php$/', $current_page);
            ?>
            <li class="<?= $is_third_party_page ? 'active' : '' ?>">
              <a><i class="fa fa-briefcase"></i> Third Party Companies <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu" style="<?= $is_third_party_page ? 'display: block;' : '' ?>">
                <li class="<?= preg_match('/^(third_party_companies|third_party_products|third_party_company_details|breakdown_third_party_transfers)/', $current_page) ? 'current-page' : '' ?>">
                  <a href="third_party_companies.php">View Companies</a>
                </li>

                  <li class="<?= preg_match('/^initiate_transfer|incomplete_third_party_company_stock_transfers\.php$/', $current_page) ? 'current-page' : '' ?>">
                    <a href="initiate_transfer.php?order_number=<?php echo $order_number; ?>">Initiate Transfer</a>
                  </li>
                
                <li class="<?= preg_match('/^(new_ship_procurement)/', $current_page) ? 'current-page' : '' ?>">
                  <a href="ship_procurement.php">Ship Procurement</a>
                </li>
                
                <li class="<?= preg_match('/^(attach_third_party_products)/', $current_page) ? 'current-page' : '' ?>">
                  <a href="attach_third_party_products.php">Attach Products</a>
                </li>
                
                <li class="<?= preg_match('/^(suppliers)/', $current_page) ? 'current-page' : '' ?>">
                  <a href="suppliers.php">Suppliers</a>
                </li>
                
                <li class="<?= preg_match('/^(shipment_document)/', $current_page) ? 'current-page' : '' ?>">
                  <a href="shipments.php">Manage Shipments</a>
                </li>

              </ul>
            </li>



            <li><a><i class="fa fa-bar-chart"></i> View Reports <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu">
              <li><a href="#">Sales Report</a></li>
              <li><a href="#">Products Report</a></li>
              <li><a href="#">Stock Movement</a></li>
              <li><a href="#">Stock Sheets</a></li>
              <li><a href="low_stock_products.php">Below Stock Levels</a></li>
              <li><a href="out_of_stock.php">Products Out of stock</a></li>
              <li><a href="#">Leave Reports</a></li>
              </ul>
            </li>

            

            <li><a><i class="fa fa-map-marker"></i> Locations <span class="fa fa-chevron-down"></span></a>
                  <ul class="nav child_menu">
                  <li><a href="manage_locations.php">Manage Locations</a></li>
                  </ul>
            </li>
            
            <li><a><i class="fa fa-user"></i> User Profile <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu">
                <li><a href="personal_account.php">User Profile</a></li>
                <li><a href="change_pass.php">Change Password</a></li>
              </ul>
            </li>
            
            <li><a><i class="fa fa-cog"></i> System Settings <span class="fa fa-chevron-down"></span></a>
              <ul class="nav child_menu">
                <li><a href="company_details.php">Company Details</a></li>
                <li><a href="bulk_assign.php">Assign Items</a></li>
                <li><a href="system_users.php">System Users</a> </li>
                <li><a href="setup_tools.php">Setup Tools</a> </li>
              </ul>
            </li>
            <li><a href="logout.php?username=<?php echo $username?>&session_id=<?php echo $session_id ?>"><i class="fa fa-power-off fa-2x text-danger"></i> Logout</a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <!-- Notifications -->
           <?php

           $birthday_names = [];
            if (!isset($_SESSION['birthday_alert_checked'])) {
                $birthdays = $employees_model->getTodaysBirthdays(); // Returns array with fullname, etc.

                if (!empty($birthdays)) {
                    foreach ($birthdays as $person) {
                        $birthday_names[] = $person['fullname'];
                    }

                    // Store list for SweetAlert and Notification badge
                    $_SESSION['birthday_employees'] = $birthday_names;
                }

                // Always set this flag to skip next reload
                $_SESSION['birthday_alert_checked'] = true;
            }
            $total_notifications = 0;
            $date_today = date('m-d');
            
            $check_birthday_if_present_today = $common_model->checkEMployeeBirthday($date_today);
            $check_customer_approvals_pending = $common_model->checkPendingCustomerApprovals();
            $check_for_uncompleted_third_company_transfers = $common_model->checkforUncompletedThirdCompanyStockTransfers();
            $check_pending_transfer_request = $common_model->checkPendingTransferRequest();
            $check_leave_requests = $common_model->checkleaveRequests();
            $check_below_min_stock_level = $common_model->checkLowStockProducts();
            $check_products_out_of_stock = $common_model->checkProductsoutofStock();
            $check_uncompleted_cash_sales = $common_model->checkUncompletedcashSales();
            $check_uncompleted_invoices = $common_model->checkUncompletedInvoices();

            $check_delivery_note_cancel_requests = $common_model->checkDeliveryNoteCancelRequests();
            $count_delivery_note_cancel_requests = $common_model->countDeliveryNoteCancelRequests();

            $check_nots = $common_model->countNotifications($emp_code);

            if($check_nots > 0){
              $fetchNotifications = $common_model->fetchNotificationsData($emp_code);
            }
    

            $total_notifications = $check_customer_approvals_pending + $check_leave_requests + $check_below_min_stock_level + $check_products_out_of_stock + $check_uncompleted_cash_sales + $check_uncompleted_invoices +  $check_birthday_if_present_today + $check_for_uncompleted_third_company_transfers + $check_pending_transfer_request + $check_nots + $check_delivery_note_cancel_requests;
            
            

            $count_leave_requests = $common_model->countleaveRequets();

            

           ?>
  <!-- top navigation -->
  <div class="top_nav">
    <div class="nav_menu">
      <div class="nav toggle">
        <a id="menu_toggle"><i class="fa fa-bars"></i></a>
      </div>

      <?php
        $scroll_notifications = [];

        /* 1️⃣ Delivery Note Cancel Requests */
        if ($check_delivery_note_cancel_requests > 0) {
            $scroll_notifications[] = "⚠ {$count_delivery_note_cancel_requests} Delivery Note Cancel request(s)";
        }
        
        /* 2️⃣ Birthdays */
        if ($check_birthday_if_present_today > 0) {
            $scroll_notifications[] = "🎂 We have employee birthday(s) today";
        }

        
        ?>


      <?php if (!empty($scroll_notifications)): ?>
        <div class="top-scroll-notifications">
            <div class="scroll-track">
                <?php foreach ($scroll_notifications as $note): ?>
                    <span class="notif-item">
                        <?php echo htmlspecialchars($note); ?>
                    </span>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>




      

      <nav class="nav navbar-nav">
        <ul class=" navbar-right">
          <li class="nav-item dropdown open" style="padding-left: 15px;">
            <a href="javascript:;" class="user-profile dropdown-toggle" aria-haspopup="true" id="navbarDropdown" data-toggle="dropdown" aria-expanded="false">
              <img src="images/default_avatar.png" alt=""><?php echo $fullname ?>
            </a>
            <div class="dropdown-menu dropdown-usermenu pull-right" aria-labelledby="navbarDropdown">
              <a class="dropdown-item"  href="personal_account.php"> Profile</a>
              <a class="dropdown-item"  href="change_pass.php">Change Password</a>
              <a class="dropdown-item"  href="logout.php?username=<?php echo $username?>&session_id=<?php echo $session_id ?>">Log Out</a>
            </div>
          </li>

          
          <li class="nav-item dropdown">
            <a id="navbarDropdown" class="nav-link" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              <div style="position: relative; display: inline-block;">
                <i class="fa fa-bell" style="font-size: 28px; line-height: 15px;"></i>
                <span style="position: absolute; top: -8px; right: -8px; background-color: red; color: white; font-size: 12px; padding: 2px 5px; border-radius: 50%; font-weight: bold; line-height: 1;">
                  <?php echo $total_notifications ?>
                </span>
              </div>
            </a>

            <div class="dropdown-menu dropdown-menu-right notifications shadow animated--grow-in" aria-labelledby="navbarDropdown">
              <?php if ($total_notifications > 0): ?>
                <h6 class="dropdown-header">Notifications</h6>

                <?php if ($check_delivery_note_cancel_requests > 0): ?>
                  <a class="dropdown-item notification-item" href="delivery_notes.php?state=3">
                    <i class="fa fa-ban icon text-danger"></i><?php echo $count_delivery_note_cancel_requests ?> delivery note cancel request(s).
                  </a>
                <?php endif; ?>

                <?php if ($check_leave_requests > 0): ?>
                  <a class="dropdown-item notification-item" href="leave_requests.php">
                    <i class="fa fa-calendar-check icon"></i> You have <?php echo $count_leave_requests ?> leave request(s).
                  </a>
                <?php endif; ?>

                <?php if($check_nots > 0): ?>
                  <?php foreach ($fetchNotifications as $not): ?>
                      <?php
                          $url = '#';
                          if ($not['purpose'] === 'transfer_note') {
                              $url = 'transfer_note.php?order_number=' . $not['identifier'];
                          }
                      ?>

                      <a class="dropdown-item notification-item"
                        href="<?= $url; ?>"
                        data-notification-id="<?= (int)$not['id']; ?>">
                          <i class="fa fa-tasks icon"></i> <?= htmlspecialchars($not['message']); ?>
                      </a>

                  <?php endforeach; ?>
              <?php endif; ?>

                
                <?php if ($check_products_out_of_stock > 0): ?>
                  <a class="dropdown-item notification-item" href="out_of_stock.php">
                    <i class="fa fa-box icon"></i>Some Products are out of stock.
                  </a>
                <?php endif; ?>

                <?php if ($check_below_min_stock_level > 0): ?>
                  <a class="dropdown-item notification-item" href="low_stock_products.php">
                    <i class="fa fa-box icon"></i>Products below minimum stock level.
                  </a>
                <?php endif; ?>

                <?php if ($check_uncompleted_cash_sales > 0): ?>
                  <a class="dropdown-item notification-item" href="incomplete_transactions.php">
                    <i class="fa fa-random icon"></i>Click to review incomplete Transactions
                  </a>
                <?php endif; ?>

                <?php if ($check_uncompleted_invoices > 0): ?>
                  <a class="dropdown-item notification-item" href="incomplete_transactions.php">
                    <i class="fa fa-random icon"></i>Click to review incomplete Transactions
                  </a>
                <?php endif; ?>

                <?php if ($check_for_uncompleted_third_company_transfers > 0): ?>
                  <a class="dropdown-item notification-item" href="incomplete_third_party_company_stock_transfers.php">
                    <i class="fa fa-random icon"></i>Review Incomplete Stock Transfers
                  </a>
                <?php endif; ?>

                <?php if ($check_pending_transfer_request > 0): ?>
                  <a class="dropdown-item notification-item" href="pending_transfers.php">
                    <i class="fa fa-truck icon"></i>View Pending Transfers
                  </a>
                <?php endif; ?>

                <?php if($check_birthday_if_present_today > 0): ?>
                    <a class="dropdown-item notification-item" href="list_birthdays.php">
                     <i class="fa fa-birthday-cake icon text-danger"></i>
                     🎉 We have birthday's today
                    </a>
                <?php endif; ?>

                <?php if ($check_customer_approvals_pending > 0): ?>
                  <a class="dropdown-item notification-item" href="review_customer_approvals.php">
                    <i class="fa fa-users icon"></i>You have Pending Customer Approvals.
                  </a>
                <?php endif; ?>

              <?php else: ?>
                <div class="dropdown-empty">No new notifications</div>
              <?php endif; ?>
            </div>

          </li>


        </ul>
      </nav>
    </div>
  </div>
    <!-- /top navigation -->
    <script type="text/javascript">
        $(document).ready(function() {
            <?php if (isset($_SESSION['notification'])) { ?>
                var type = "<?php echo $_SESSION['notification']['type']; ?>";
                var title = "<?php echo $_SESSION['notification']['title']; ?>";
                var message = "<?php echo $_SESSION['notification']['message']; ?>";
                
                toastr.options = {
                    "closeButton": true,
                    "progressBar": false,
                    "positionClass": "toast-top-right",
                    "timeOut": "5000",
                    "extendedTimeOut": "3000"
                };

                if (type === 'success') {
					        toastr.success(message, title || "Success");
				        } else if (type === 'error') {
					        toastr.error(message, title || "Error");
				        } else if(type === 'warning'){
					        toastr.warning(message, title || "Warning");
				        } else if(type === 'info') {
                  toastr.info(message, title || "Info");
                }


                // Clear the notification session
                <?php unset($_SESSION['notification']); ?>
            <?php } ?>
        });
    </script>

    <script>
$(document).on('click', '.notification-item', function () {
    const notificationId = $(this).data('notification-id');

    // Only DB-backed notifications are marked as read
    if (!notificationId) return;

    $.post('controllers/settings_controller.php', {
        action: 'mark_as_read',
        notification_id: notificationId
    });
});
</script>

    

    