<?php
	session_start();
	//include 'model/customers_model.php';
	include 'model/common_model.php';
	
?>
<html>
	<head>
		<title>Warehouse</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
	</head>
	<body>
		<?php
			$common_model = new common_model();
            $locations = $common_model->getAllLocations();
            $nationalities = $common_model->getNationalities();
		?>
		
		<form action="controllers/customer_controller.php" method="post">
            <center>
                <h2 class="page_titles">ADD NEW CUSTOMER <i class="fa fa-user-plus"></i></h2>
                <hr>

                <input type="text" style="width: 320px; height:40px;" autocomplete="off" name="customer_name" class="form-control" required placeholder="Enter Full Name"><br>
				<input type="hidden" name="action" value="addnewCustomer" readonly>

                <div class="input-group" style="width: 320px;">
					<div class="input-group-prepend">
						<span class="input-group-text" style="height: 40px;">+265</span>
					</div>
					<input type="text" maxlength="9" minlength="5" autocomplete="off" name="phone_number" id="phone_number" class="form-control" required placeholder="Enter Phone Number" style="height: 40px;" oninput="formatMalawiNumber(this)">
				</div>
				<small id="phone_error" style="font-size:15px" class="text-danger d-none">Phone number already exists.</small>
				<br>

                <input type="email" style="width: 320px; height:40px;" autocomplete="off" name="email_address" id="email_address" class="form-control" placeholder="Enter Email Address" required>
				<small id="email_error" style="font-size:15px" class="text-danger d-none">Email address already exists.</small>
				<br>

                <select name="gender" class="form-control" style="width: 320px; height:40px;" required>
                    <option value="" disabled selected>Select Gender</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                </select><br>

                <select name="location" class="form-control" style="width: 320px; height:40px;" required>
                    <option value="" disabled selected>Select Location</option>
                    <?php
                        foreach($locations as $location):
                    ?>
                        <option value="<?php echo $location['loc_id']?>"><?php echo $location['location_name']?></option>
                    <?php
                        endforeach;
                    ?>
                </select><br>

                <select name="nationality" class="form-control" style="width: 320px; height:40px;" required>
                    <option value="" disabled selected>Select Nationality</option>
                    <?php
                        foreach($nationalities as $nationality):
                    ?>
                        <option value="<?php echo $nationality['id']?>"><?php echo $nationality['country_name']?></option>
                    <?php
                        endforeach;
                    ?>
                </select><br>

				<select name="type_customer" class="form-control" style="width: 320px; height:40px;" required>
					<option value="" selected disabled>Select Type of Customer</option>
					<option value="Walk In Cusromers">Walk In Customer</option>
					<option value="Individual">Individual Credit Customers</option>
					<option value="Dealer">Dealers</option>
					<option value="Corporate Customer">Corporate Customer</option>
				</select>
				<br>

                <textarea name="customer_address" class="form-control" style="width: 320px; height:auto" placeholder="Enter customer address(Postal/Physical address - optional)"></textarea>
                <br>

                <button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:320px;font-size: 18px;">SAVE CUSTOMER <i class="fa fa-save"></i></button>
            </center>
        </form>
		<script>
			function formatMalawiNumber(input) {
				let original = input.value;
				let number = original.replace(/\D/g, '');

				const errorElement = document.getElementById('phone_error');

				// Show warning if it starts with 0
				if (original.startsWith('0')) {
					errorElement.textContent = 'Phone number should not start with 0';
					errorElement.classList.remove('d-none');
				} else {
					const validPrefixes = ['99', '88', '89', '98'];
					const prefix = number.substring(0, 2);

					if (number.length > 0 && !validPrefixes.includes(prefix)) {
						errorElement.textContent = 'Invalid phone number prefix';
						errorElement.classList.remove('d-none');
					} else {
						errorElement.textContent = '';
						errorElement.classList.add('d-none');
					}
				}

				// Always strip non-digit characters and leading 0 before saving
				if (number.startsWith('0')) {
					number = number.substring(1);
				}
				
				input.value = number;
			}
		</script>



			<script>
				$(document).ready(function () {
					let emailExists = false;
					let phoneExists = false;

					function toggleSubmitButton() {
						$('#SaveButton').prop('disabled', emailExists || phoneExists);
					}

					function checkEmail() {
						const email = $('#email_address').val().trim();

						if (email !== '') {
							$.post('check_email.php', { emailaddress: email }, function (data) {
								if (data.exists) {
									$('#email_error').removeClass('d-none');
									emailExists = true;
								} else {
									$('#email_error').addClass('d-none');
									emailExists = false;
								}
								toggleSubmitButton();
							}, 'json');
						} else {
							$('#email_error').addClass('d-none');
							emailExists = false;
							toggleSubmitButton();
						}
					}

					function checkPhone() {
						const phone = $('#phone_number').val().trim();

						if (phone.length === 9) {
							$.post('check_phone.php', { phone_number: phone }, function (response) {
								if (response.exists) {
									$('#phone_error').removeClass('d-none');
									phoneExists = true;
								} else {
									$('#phone_error').addClass('d-none');
									phoneExists = false;
								}
								toggleSubmitButton();
							}, 'json');
						} else {
							$('#phone_error').addClass('d-none');
							phoneExists = false;
							toggleSubmitButton();
						}
					}

					$('#email_address').on('input', checkEmail);
					$('#phone_number').on('input', checkPhone);
				});

			</script>


	</body>
</html>