<?php
	session_start();
	include 'model/stock_model.php';
	
?>
<html>
	<head>
		<title>Products</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
	</head>
	<body>
		<?php
			$stock_model = new stock_model();

            $categories = $stock_model->getCategories();
            $units = $stock_model->getUnits();
		?>
		
		<form action="controllers/products_controller.php" method="post">
			
				<center>
					<h2 class="page_titles">SINGLE ADD - PRODUCT <i class="fa fa-mug-hot"></i></h2>
					<hr>
					
					<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="product_code" name="product_code" class="form-control" required placeholder="Enter Product Code">
					<span id="Error" style="color: red;"></span><br>

                    <input type="text" style="width: 320px; height:40px;" autocomplete="off" id="product_name" name="product_name" class="form-control" required placeholder="Enter Product Name">
                    <br>
					<span id="Error" style="color: red;"></span>

					<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="overall_min_level" name="overall_min_level" class="form-control" required placeholder="Stock Overall Minimum Level">
                    <br>
					
					<input type="number" step="0.01" style="width: 320px; height:40px;" autocomplete="off" min="100" name="selling_price" class="form-control" required placeholder="Item Selling Price">
                    <br>

                    <select name="category" class="form-control" style="width: 320px; height:40px;" required>
                        <option value="" selected disabled>Select Product Category</option>
                        <?php
                            foreach($categories as $category):
                        ?>
                            <option value="<?php echo $category['category_id']?>"><?php echo $category['categoryname']?></option>
                        <?php
                            endforeach;
                        ?>
                    </select>
                    <br>

                    <select name="unit" class="form-control" style="width: 320px; height:40px;" required>
                        <option value="" selected disabled>Select Product Unit</option>
                        <?php
                            foreach($units as $unit):
                        ?>
                            <option value="<?php echo $unit['unit_id']?>"><?php echo $unit['unitname']?></option>
                        <?php
                            endforeach;
                        ?>
                    </select>
                    <br>
					<input type="hidden" name="addProduct" value="addProduct" readonly>
                    <button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:322px;font-size: 18px;">SAVE PRODUCT <i class="fa fa-save"></i></button>
				</center>
			
		</form>
		<span id="Error" style="color: red;"></span><br>

		<script>
			function checkProductDetails() {
				const productCode = $('#product_code').val().trim();
				const productName = $('#product_name').val().trim();

				if (productCode === '' && productName === '') {
					$('#Error').text('');
					$('#SaveButton').prop('disabled', false);
					return;	
				}

				$.post('controllers/products_controller.php', {
					product_code: productCode,
					product_name: productName,
					check_duplicates: true
				}, function(data) {
					if (data.code_exists && data.name_exists) {
						$('#Error').text('Product name and code already exist');
						$('#SaveButton').prop('disabled', true);
					} else if (data.code_exists) {
						$('#Error').text('Product code already exists');
						$('#SaveButton').prop('disabled', true);
					} else if (data.name_exists) {
						$('#Error').text('Product name already exists');
						$('#SaveButton').prop('disabled', true);
					} else {
						$('#Error').text('');
						$('#SaveButton').prop('disabled', false);
					}
				}, 'json');
			}

			$(document).ready(function() {
				$('#product_name, #product_code').on('input', checkProductDetails);
			});

		</script>

	</body>
</html>