<?php
function addPDFHeader($pdf, $title, $logo_path = null, $company_address = '',$company_country = '',  $company_phone = '', $company_email = '', $company_website= '') {
    // Set font for header
    $pdf->SetFont('Courier', 'B', 14); // Increased font size for company name


    // Add logo if available
    if ($logo_path && file_exists($logo_path)) {
        $pdf->Image($logo_path, 10, 15, 75, 30); // Adjust size and position of the logo
    }

    

    // Add company address, phone, and email
    if (!empty($company_address) || !empty($company_phone) || !empty($company_email) || !empty($company_country || !empty($company_website))) {
        $pdf->SetTextColor(0, 0, 0); // Reset to black text
        $pdf->SetFont('Times', '', 12); // Slightly smaller font for address
        $pdf->SetXY(125, 20); // Position to the right of the header
    
        // Combine address, phone, email, and country
        $contact_info = $company_address;
    
        if (!empty($company_country)) {
            $contact_info .= ', ' . $company_country; // Add the country
        }
    
        if (!empty($company_phone)) {
            $contact_info .= "\n" . $company_phone; // Phone number in a new line
        }
    
        if (!empty($company_email)) {
            $contact_info .= "\n" . $company_email; // Email in a new line
        }
    
        if (!empty($company_website)) {
            $contact_info .= "\n" . $company_website; // Email in a new line
        }
    
        // Add some space between each line by using a larger height for MultiCell
        $pdf->MultiCell(0, 7, $contact_info, 0, 'R'); // Adjusted line height to 8 for more spacing
    }
    
    // Add Title with custom font and color
    $pdf->SetFont('Courier', 'B', 14); // Increased text size for title
    $pdf->SetTextColor(0, 102, 204); // Blue color for the title
    $pdf->Cell(0, 10, $title, 0, 1, 'C'); // Title in the center
    $pdf->Ln(5); // Add space after the title
    
    // Draw a horizontal line to separate header from the content
    $pdf->SetLineWidth(0.5); // Set the line width
    $pdf->Line(10, $pdf->GetY(), 200, $pdf->GetY()); // Draw a line from left to right, based on current Y position
    $pdf->Ln(5); // Add space below the line for content to not overlap
    
}
