<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD</title>
        <?php
            include_once 'css_links.php';
        ?>
        <style>
            .product-image {
    width: 100%;
    max-width: 450px;
    height: auto;
    border-radius: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transition: transform 0.3s ease;
}

.product-image:hover {
    transform: scale(1.02);
    cursor: pointer;
}

.details-box {
    padding: 30px;
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 4px 16px rgba(0,0,0,0.05);
}

.btn-edit {
    float: right;
    margin-left: 10px;
}

.image-wrapper {
    position: relative;
    height: auto;
    padding: 0;
    overflow: hidden;
    display: flex;
    justify-content: center;
    align-items: center;
}

.image-container {
    text-align: center;
}

        </style>
    </head>
    <body class="nav-md">
    <div class="container body">
    <div class="main_container">
        <?php
            include_once 'model/stock_model.php';

            $stock_model = new stock_model();
            $product_id = $_GET['product_id'] ?? '';
            
            $productDetails = [];
            if (!empty($product_id)) {
                $productDetails = $stock_model->getProductDetailsbyID2($product_id);
            } else {
                header("Location: manage_products.php");
                exit();
            }

            
            include 'menu_finance.php';        

            $imagePath = !empty($productDetails['image']) && file_exists("images/products/".$productDetails['image'])
                ? "images/products/".$productDetails['image']
                : "images/default_product.png";
        ?>

        <!-- Page Content -->
        <div class="right_col" role="main">
            <div class="page-title">
                <div class="title_left">
                    <h3>Product Details</h3>
                </div>
            </div>
            <div class="clearfix"></div>

            <div class="row" style="display: flex; align-items: stretch;">
                <div class="col-md-4 col-sm-12 image-wrapper">
                    <div class="image-container text-center">
                        <img src="<?= $imagePath ?>" alt="Product Image" class="img-thumbnail center-img product-image" onclick="triggerImageUpload()">
                            <form id="imageUploadForm" method="POST" enctype="multipart/form-data" action="upload_product_image.php">
                                <input type="hidden" name="product_id" value="<?= htmlspecialchars($product_id) ?>">
                                <input type="file" id="imageInput" name="product_image" accept="image/*" style="display: none;" onchange="submitImageForm()">
                            </form>
                        <p class="text-muted mt-2">Click image to upload a new one</p>
                    </div>
                </div>

                <div class="col-md-8 col-sm-12">
                    <div class="details-box">
                        <?php if (!empty($productDetails)): ?>
                            <div class="d-flex justify-content-end mb-3">
                                <a href="javascript:history.back()" class="btn btn-outline-info me-2"><i class="fa fa-arrow-left"></i> Back</a>
                                <a rel="facebox" href="edit_product.php?product_id=<?= htmlspecialchars($productDetails['product_id']) ?>" class="btn btn-primary"><i class="fa fa-edit"></i> Edit Product</a>
                            </div>

                            <table class="table table-bordered table-striped">
                                <tbody>
                                    
                                    <tr><th>Product Code</th><td><?= htmlspecialchars($productDetails['product_code']) ?></td></tr>
                                    <tr><th>Product Name</th><td><?= htmlspecialchars($productDetails['product_name']) ?></td></tr>
                                    <tr><th>Selling Price</th><td><?= number_format(htmlspecialchars($productDetails['selling_price']),2) ?></td></tr>
                                    <tr><th>Category</th><td><?= htmlspecialchars($productDetails['categoryname']) ?></td></tr>
                                    <tr><th>Unit</th><td><?= htmlspecialchars($productDetails['unitname']) ?></td></tr>
                                    <tr><th>Minimum Order Level</th><td><?= htmlspecialchars($productDetails['min_order_level']) ?></td></tr>
                                    <tr><th>Date Created</th><td><?= htmlspecialchars($productDetails['datecreated']) ?></td></tr>
                                    <tr><th>Operator</th><td><?= htmlspecialchars($productDetails['operator']) ?></td></tr>
                                    <tr>
                                        <th>Product State</th>
                                        <td class="<?= $productDetails['product_state'] == 0 ? 'bg-danger text-white' : 'bg-success text-white' ?>">
                                            <?= htmlspecialchars($productDetails['product_status']) ?>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        <?php else: ?>
                            <div class="alert alert-warning">No product found with the given product code.</div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- /page content -->

                <?php
                    include_once 'footer.php';
                ?>
            </div>
        </div>
        <?php
            include_once 'libraries.php';
        ?>
        <script>
            function triggerImageUpload() {
                document.getElementById('imageInput').click();
            }

            function submitImageForm() {
                document.getElementById('imageUploadForm').submit();
            }
        </script>

    </body>
</html>
