<?php
session_start();
date_default_timezone_set('Africa/Blantyre');
include_once 'model/branch_model.php';

// Collect posted values
$name_branch = isset($_POST['name_branch']) ? trim($_POST['name_branch']) : '';
$location_id    = isset($_POST['location']) ? $_POST['location'] : '';
$branch_code = isset($_POST['branch_code']) ? $_POST['branch_code'] : '';

$errors = [];

if (empty($name_branch)) {
    $errors[] = "Branch name is required.";
}

if (empty($location_id)) {
    $errors[] = "Location must be selected.";
}



if (empty($errors)) {
    $branch_model = new branch_model();

    $branch_id = $branch_model->generateNextID();


    // Check if location already has a warehouse
    if ($branch_model->doesLocationAlreadyHaveWarehouse($location_id)) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Failed',
            'message' => 'This location already has a warehouse assigned.'
        ];
        header("Location: manage_branches.php");
        exit;
    }


    // All checks passed, save the warehouse
    $branch_data = [
        'branch_id' => $branch_id,
        'branch_name' => $name_branch,
        'location' => $location_id,
        'branch_code' => $branch_code,
        'datecaptured' => date('Y-m-d H:i:s'),
        'operator' => $_SESSION['sess_employeecode']
    ];

    $saved = $branch_model->saveBranch($branch_data);

    $_SESSION['notification'] = $saved
        ? ['type' => 'success', 'title' => 'Saved', 'message' => 'Branch added successfully.']
        : ['type' => 'error', 'title' => 'Failed', 'message' => 'Failed to save branch.'];
    header("Location: manage_branches.php");
    exit;
} else {
    $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'Validation Error',
        'message' => implode('<br>', $errors)
    ];
    header("Location: manage_branches.php");
    exit;
}
?>