<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Initiate Stock Transfer | Powertex LTD</title>
    <link rel="icon" href="images/favicon.png" type="image/ico"/>

    <?php include_once 'css_links.php'; ?>

    <style>
        /* Bootstrap 3 form spacing fix */
        .form-horizontal .form-group {
            margin-bottom: 18px;
        }
        .form-horizontal .control-label {
            padding-top: 7px;
        }
    </style>
    <style>
.select2-container {
    width: 100% !important;
}
.select2-selection--single {
    height: 34px !important;
    padding: 4px 8px;
}
.select2-selection__arrow {
    height: 32px !important;
}
/* =============================
   SELECT2 BOOTSTRAP 3 FIX
============================= */

.select2-container {
    width: 100% !important;
}

.select2-container--default .select2-selection--single {
    height: 34px !important;
    line-height: 34px !important;
    padding: 0 8px;
    border: 1px solid #ccc;
    border-radius: 0;
}

.select2-container--default .select2-selection--single
.select2-selection__rendered {
    line-height: 34px !important;
    padding-left: 0;
    padding-right: 0;
}

.select2-container--default .select2-selection--single
.select2-selection__arrow {
    height: 34px !important;
    top: 0;
    right: 6px;
}

/* Disabled state match */
.select2-container--default.select2-container--disabled
.select2-selection--single {
    background-color: #eee;
    cursor: not-allowed;
}

</style>

</head>

<body class="nav-md">

<div class="container body">
<div class="main_container">

<?php
include 'menu_finance.php';
include_once 'model/stock_model.php';
include_once 'model/transfers_model.php';
include_once 'model/companies_model.php';
include_once 'model/common_model.php';

$common_model   = new common_model();
$stock_model     = new stock_model();
$transfers_model = new transfers_model();
$companies_model = new companies_model();
 $procurement_mode = $common_model->getProcurementModeSetting();
?>

<div class="right_col" role="main">

<div class="page-title">
    <div class="title_left">
        <h3><small>Initiate Stock Transfer</small></h3>
    </div>
</div>

<div class="clearfix"></div>

<div class="row">
<div class="col-md-12">

<div class="x_panel">
<div class="x_title">
    <h2>Supplier Shipment <small>To Third Party Handler</small></h2>
    <div class="clearfix"></div>
</div>

<div class="x_content">

<form class="form-horizontal" method="post" action="controllers/transfer_controller.php">
    <input type="hidden" name="action" value="initiate_supplier_shipment" readonly>

<!-- ================= HEADER ================= -->
<div class="row">

    <!-- LEFT -->
    <div class="col-md-6">

        <div class="form-group clearfix">
            <label class="control-label col-md-4">Reference No</label>
            <div class="col-md-8">
                <input type="text" name="reference_no" placeholder="Enter document number" class="form-control" required> 
            </div>
        </div>

        <!-- Vehicle / Waybill (NOW ON TOP) -->
        <div class="form-group clearfix">
            <label class="control-label col-md-4">Waybill</label>
            <div class="col-md-8">
                <input type="text" name="waybill_no" class="form-control" placeholder="Enter waybill number(optional)">
            </div>
        </div>
        
        <div class="form-group clearfix">
            <label class="control-label col-md-4">Shipment Date</label>
            <div class="col-md-8">
                <input type="date" max="<?= date('Y-m-d') ?>" name="shipment_date" class="form-control" required>
            </div>
        </div>

        <div class="form-group clearfix">
            <label class="control-label col-md-4">Supplier</label>
            <div class="col-md-8">
                <select name="supplier_id" class="form-control" required>
                    <option value="">-- Select Supplier --</option>
                    <?php foreach ($companies_model->get_suppliers() as $row) { ?>
                        <option value="<?= $row['id']; ?>">
                            <?= $row['supplier_name']; ?>
                        </option>
                    <?php } ?>
                </select>
            </div>
        </div>
    </div>

    <!-- RIGHT -->
    <!-- RIGHT -->
<div class="col-md-6">

    <!-- Receiving Company -->
    <div class="form-group clearfix">
        <label class="control-label col-md-4">Receiving Company</label>
        <div class="col-md-8">
            <select name="receiver_id" class="form-control" required>
                <option value="">-- Third Party Handler --</option>
                <?php foreach ($companies_model->get_third_parties() as $row) { ?>
                    <option value="<?= $row['id']; ?>">
                        <?= $row['company_name']; ?>
                    </option>
                <?php } ?>
            </select>
        </div>
    </div>

    <div class="form-group clearfix">
            <label class="control-label col-md-4">Currency</label>
            <div class="col-md-3">
                <select name="currency" class="form-control" required>
                    <option value="">-- Currency --</option>
                    <option value="MWK">MWK</option>
                    <option value="USD">USD</option>
                    <option value="ZAR">ZAR</option>
                    <option value="EUR">EUR</option>
                </select>
            </div>
        </div>

    <!-- Transport Mode (INLINE, ORDERED, 3 + 2) -->
    <div class="form-group clearfix">
        <label class="control-label col-md-4">Transport Mode</label>
        <div class="col-md-8">

            <!-- Row 1 -->
            <div class="row">
                <div class="col-md-4">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="transport_mode[]" value="air">
                        Aeroplane
                    </label>
                </div>

                <div class="col-md-4">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="transport_mode[]" value="courier" >
                        Courier
                    </label>
                </div>

                <div class="col-md-4">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="transport_mode[]" value="rail" >
                        Rail
                    </label>
                </div>
            </div>

            <!-- Row 2 -->
            <div class="row" style="margin-top:5px;">
                <div class="col-md-4">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="transport_mode[]" value="sea" >
                        Ship
                    </label>
                </div>

                <div class="col-md-4">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="transport_mode[]" value="road_truck">
                        Truck
                    </label>
                </div>
            </div>

        </div>
    </div>

</div>


</div>

<hr>

<!-- ================= ITEMS ================= -->
<h4>Shipment Items</h4>


<table class="table table-bordered" id="items_table">
<thead>
<tr>
    <th width="22%">Item</th>
    <th width="15%">Category</th>
    <th width="10%">Qty</th>
    <th width="15%">Cost Price</th>
    <th width="18%">Total Cost</th>
    <th width="5%"></th>
</tr>
</thead>

<tbody>
<tr class="item-row">

    <td>
        <select name="item_id[]" class="form-control item-select" required>
            <option value="">-- Select Item --</option>
        </select>
    </td>

    <!-- DISPLAY ONLY -->
    <td>
        <input type="text" class="form-control category-display" readonly>
    </td>

    <td>
        <input type="number" name="qty[]" class="form-control qty" min="1" required>
    </td>

    <td>
        <input
            type="number"
            name="cost_price[]"
            class="form-control cost-price"
            step="0.01"
            min="0"
            <?= $procurement_mode ? 'required' : 'readonly value="0.00"' ?>
        >
    </td>

    <td>
        <input type="number" name="total_cost[]" class="form-control total-cost" readonly value="0.00">
    </td>


    <td class="text-center">
        <button type="button" class="btn btn-danger btn-xs remove-row">
            <i class="fa fa-trash"></i>
        </button>
    </td>

</tr>
</tbody>

<tfoot>
<tr>
    <th colspan="4" class="text-right">Grand Total</th>
    <th>
        <input type="text" id="grand_total" class="form-control" readonly value="0.00">
    </th>
    <th colspan="2"></th>
</tr>
</tfoot>
</table>


<button type="button" class="btn btn-default" id="add_row">
    <i class="fa fa-plus"></i> Add Item
</button>


<hr>

<div class="text-right">
    <a href="dashboard.php" class="btn btn-info">Cancel</a>
    <button type="submit" name="confirm" class="btn btn-success">Confirm Shipment</button>
</div>

</form>
</div>
</div>
</div>
</div>

</div>

<?php include_once 'footer.php'; ?>
<?php include_once 'libraries.php'; ?>

<script>
/* =============================
   PRODUCT LOADING
============================= */
function loadCompanyProducts(companyId, reset = false) {
    $.post(
        'controllers/products_controller.php',
        {
            action: 'fetch_company_products',
            company_id: companyId
        },
        function (response) {

            let options = '<option value="">-- Select Item --</option>';

            if (response.products) {
                response.products.forEach(p => {
                    options += `
                        <option 
                            value="${p.product_id}" 
                            data-category="${p.categoryname || ''}">
                            ${p.product_name}
                        </option>`;
                });
            }

            $('.item-select').each(function () {
                const prev = reset ? '' : $(this).val();
                $(this).html(options).val(prev).trigger('change');
            });

        },
        'json'
    );
}

/* =============================
   CATEGORY + DUPLICATE PREVENTION
============================= */
$(document).on('change', '.item-select', function () {

    const selectedVal = $(this).val();
    const row = $(this).closest('tr');

    if (!selectedVal) {
        row.find('.category-display').val('');
        return;
    }

    let duplicate = false;

    $('.item-select').not(this).each(function () {
        if ($(this).val() === selectedVal) {
            duplicate = true;
        }
    });

    if (duplicate) {
        toastr.error('This item has already been selected.', 'Duplicate Item');
        $(this).val('').trigger('change');
        row.find('.category-display').val('');
        return;
    }

    const category = $(this).find(':selected').data('category') || '';
    row.find('.category-display').val(category);
});

/* =============================
   TOTAL CALCULATIONS (UNCHANGED)
============================= */
function calculateRowTotal(row) {
    const qty  = parseFloat(row.find('.qty').val()) || 0;
    const cost = parseFloat(row.find('.cost-price').val()) || 0;

    const total = qty * cost;
    row.find('.total-cost').val(total.toFixed(2));

    calculateGrandTotal();
}

function calculateGrandTotal() {
    let grandTotal = 0;

    $('.total-cost').each(function () {
        grandTotal += parseFloat($(this).val()) || 0;
    });

    $('#grand_total').val(grandTotal.toFixed(2));
}

$(document).on('input', '.qty, .cost-price', function () {
    calculateRowTotal($(this).closest('tr'));
});

/* =============================
   RECEIVER CHANGE
============================= */
$(document).on('change', 'select[name="receiver_id"]', function () {

    const companyId = $(this).val();
    const firstRow  = $('#items_table tbody tr:first');

    firstRow.find('.item-select').select2('destroy');
    $('#items_table tbody').html(firstRow.clone());

    if (companyId) {
        loadCompanyProducts(companyId, true);
    }

    initItemSelect2($('#items_table'));
    calculateGrandTotal();
});

/* =============================
   ADD ROW
============================= */
$('#add_row').on('click', function () {

    const firstRow = $('#items_table tbody tr:first');
    firstRow.find('.item-select').select2('destroy');

    const row = firstRow.clone();

    row.find('input').val('');
    row.find('.total-cost').val('0.00');
    row.find('.category-display').val('');

    <?php if (!$procurement_mode) { ?>
        row.find('.cost-price').val('0.00').prop('readonly', true);
    <?php } ?>

    $('#items_table tbody').append(row);

    const companyId = $('select[name="receiver_id"]').val();
    if (companyId) {
        loadCompanyProducts(companyId);
    }

    initItemSelect2($('#items_table'));
});

/* =============================
   REMOVE ROW
============================= */
$(document).on('click', '.remove-row', function () {
    if ($('#items_table tbody tr').length > 1) {
        $(this).closest('tr').remove();
        calculateGrandTotal();
    }
});

/* =============================
   FORM VALIDATION + CONFIRMATION
============================= */
$('form').on('submit', function (e) {
    e.preventDefault();

    const form = this;
    const procurementEnabled = <?= $procurement_mode ? 'true' : 'false' ?>;

    /* =============================
       1. PROCUREMENT VALIDATION
    ============================= */
    if (procurementEnabled) {
        let invalid = false;

        $('.total-cost').each(function () {
            if (parseFloat($(this).val()) <= 0) {
                invalid = true;
            }
        });

        if (invalid) {
            Swal.fire({
                icon: 'warning',
                title: 'Invalid Cost',
                text: 'Cost price is required and total cost must be greater than zero.'
            });
            return; // STOP everything
        }
    }

    /* =============================
       2. TRANSPORT MODE CHECK
    ============================= */
    const transportSelected = $('input[name="transport_mode[]"]:checked').length > 0;

    if (!transportSelected) {
        Swal.fire({
            icon: 'warning',
            title: 'Transport Mode Required',
            text: 'Please select at least one transport mode before proceeding.'
        });
        return; // STOP — no SweetAlert confirmation
    }

    /* =============================
       3. FINAL CONFIRMATION
    ============================= */
    Swal.fire({
        title: 'Are you sure?',
        text: 'Saving this shipment will affect stock levels. This action cannot be undone.',
        icon: 'warning',
        reverseButtons:true,
        showCancelButton: true,
        confirmButtonColor: '#26B99A',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, proceed',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit(); // actual submit
        }
    });
});

/* =============================
   SELECT2 INIT
============================= */
function initItemSelect2(context) {
    $(context).find('.item-select').each(function () {

        if ($(this).hasClass('select2-hidden-accessible')) {
            $(this).select2('destroy');
        }

        $(this).select2({
            placeholder: '-- Select Item --',
            allowClear: true,
            width: '100%'
        });
    });
}

$(document).ready(function () {
    initItemSelect2(document);
});
</script>






</body>
</html>
