<?php
    session_start();
    include_once 'model/stock_model.php';

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $product_id = $_POST['product_id'] ?? '';
        $uploadDir = 'images/products/';
        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];

        if (!empty($product_id) && isset($_FILES['product_image']) && $_FILES['product_image']['error'] === UPLOAD_ERR_OK) {
            $fileTmpPath = $_FILES['product_image']['tmp_name'];
            $fileName = basename($_FILES['product_image']['name']);
            $fileSize = $_FILES['product_image']['size'];
            $fileType = mime_content_type($fileTmpPath);
            $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            $newFileName = $product_id . '_' . time() . '.' . $fileExt;
            $destination = $uploadDir . $newFileName;

            if (in_array($fileType, $allowedTypes)) {
                // Move file to uploads directory
                if (move_uploaded_file($fileTmpPath, $destination)) {
                    // Update image in database
                    $stock_model = new stock_model();
                    $stock_model->updateProductImage($product_id, $newFileName);

                    $_SESSION['notification']=[
                        'title' => 'SUCCESS',
                        'type' => 'success',
                        'message' => 'Successfully Updated Product Image.'
                    ];
                    header("Location: product_details.php?product_id=" . urlencode($product_id));
                    exit();
                } else {
                    $_SESSION['notification']=[
                        'title' => 'FAILED',
                        'type' => 'error',
                        'message' => 'Error moving uploaded file.'
                    ];
                    header("Location: product_details.php?product_id=" . urlencode($product_code));
                    exit();
                }
            } else {
                $_SESSION['notification']=[
                    'title' => 'FAILED',
                    'type' => 'error',
                    'message' => 'Unsupported file type. Only JPG, PNG, and GIF allowed.'
                ];
                header("Location: product_details.php?product_id=" . urlencode($product_code));
                exit();
            }
        } else {
            $_SESSION['notification']=[
                'title' => 'FAILED',
                'type' => 'error',
                'message' => 'invalid Product code or Missing Product Image'
            ];
            header("Location: product_details.php?product_code=" . urlencode($product_code));
            exit();
        }
    } else {
        $_SESSION['notification']=[
            'title' => 'FAILED',
            'type' => 'error',
            'message' => 'invalid Server Request Method'
        ];
        header("Location: product_details.php?product_code=" . urlencode($product_code));
        exit();   
    }
?>
