<?php
session_start();
date_default_timezone_set('Africa/Blantyre');

include_once('../model/customers_model.php');
include_once('../model/common_model.php'); 


$customers_model = new customers_model();
$common_model  = new common_model();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $action = $_POST['action'] ?? '';

    switch ($action) {

        case 'add_customer':
            addCustomer($customers_model, $common_model);
            break;

        default:
            $_SESSION['notification'] = [
                "type" => "error",
                "message" => "Invalid action selected.",
                "title" => "Error"
            ];
            header("Location: ../manage_customers.php");
            exit();
    }

} 

function addCustomer($customers_model, $common_model)
{
    // Capture form inputs
    $customer_name       = trim($_POST['customer_name']);
    $phone = trim($_POST['phone']);

    // Remove any leading zeros or non-digit characters
    $phone = preg_replace('/[^0-9]/', '', $phone);

    // Ensure it starts with +265
    if (substr($phone, 0, 3) !== '265') {
        // Remove leading 0 if present
        if (substr($phone, 0, 1) === '0') {
            $phone = substr($phone, 1);
        }
        $phone = '+265' . $phone;
    }

    $whatsapp                = isset($_POST['whatsapp']) && $_POST['whatsapp'] != '' ? trim($_POST['whatsapp']) : null;
    $email                   = isset($_POST['email']) && $_POST['email'] != '' ? trim($_POST['email']) : null;
    $gender                  = trim($_POST['gender']) ?? null;
    $customer_type           = trim($_POST['customer_type']);
    $location                = isset($_POST['location']) && $_POST['location'] != '' ? trim($_POST['location']) : null;
    $nationality             = isset($_POST['nationality']) && $_POST['nationality'] != '' ? trim($_POST['nationality']) : null;
    $customer_address        = isset($_POST['customer_address']) && $_POST['customer_address'] != '' ? trim($_POST['customer_address']) : null;
    $registration_location   = $_POST['registration_location'];

    // Handle adding a NEW location
    if ($location === "ADD_NEW") {

        $new_location_name     = trim($_POST['new_location_name']);
        $new_location_district = trim($_POST['new_location_district']);
        $loc_id                = $common_model->getNextLocationId();
        $loc_state             = 1; // Active state

        // Validation for new location
        if ($new_location_name === "" || $new_location_district === "") {
            $_SESSION['notification'] = [
                "type" => "error",
                "title" => "Missing Fields",
                "message" => "New location name and district are required."
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        // Insert new location
        $insert_location_success = $common_model->addNewLocation($loc_id, $new_location_name, $new_location_district, $loc_state);

        // Ensure insertion succeeded
        if (!$insert_location_success) {
            $_SESSION['notification'] = [
                "type" => "error",
                "title" => "Database Error",
                "message" => "Failed to create new location."
            ];
            header("Location: ../manage_customers.php");
            exit();
        }

        // Use the generated loc_id as the customer location
        $location = $loc_id;
    }

    // Final server-side validation
    if ($customer_name === "" || $phone === "" || $gender === "" || 
        $customer_type === "" || $registration_location === "") {

        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Validation Error",
            "message" => "Required fields are missing."
        ];
        header("Location: ../manage_customers.php");
        exit();
    }

    // Check if email already exists
    if ($customers_model->phoneNumberExists($phone)) {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Duplicate Email",
            "message" => "This Phone Number is already registered."
        ];
        header("Location: ../manage_customers.php");
        exit();
    }
    
    if ($customers_model->emailExists($email)) {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Duplicate Email",
            "message" => "This email address is already registered."
        ];
        header("Location: ../manage_customers.php");
        exit();
    }


    $customer_state = ($customer_type === "Walk-in") ? 1 : 2;

    // Prepare data for insertion
    $customerData = [
        'customer_id'      => $customers_model->getNextCustomerId(),
        'customer_name'    => $customer_name,
        'contact_number'   => $phone,
        'whatsapp_number'  => $whatsapp,
        'email'            => $email,
        'gender'           => $gender,
        'customer_address' => $customer_address,
        'location'         => $location,
        'type_customer'    => $customer_type,
        'nationality'      => $nationality,
        'operator'         => $_SESSION['sess_employeecode'], 
        'datecreated'      => date('Y-m-d H:i:s'),
        'customer_state'   => $customer_state,
        'registration_loc' => $registration_location
    ];

    // Insert customer record
    $result = $customers_model->addCustomer($customerData);

    if ($result) {
        $_SESSION['notification'] = [
            "type" => "success",
            "title" => "Success",
            "message" => "Customer added successfully."
        ];
    } else {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Database Error",
            "message" => "Failed to add customer."
        ];
    }

    header("Location: ../manage_customers.php");
    exit();
}


?>
