<?php
session_start();
date_default_timezone_set('Africa/Blantyre');

include_once('../model/employees_model.php');
include_once('../model/common_model.php'); 


$employees_model = new employees_model();
$common_model  = new common_model();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $action = $_POST['action'] ?? '';

    switch ($action) {

        case 'update_employee':
            updateEmployeeDetails($employees_model, $common_model);
            break;
        case 'update_profile_picture':
            updateProfilePicture($employees_model);
            break;

        default:
            $_SESSION['notification'] = [
                "type" => "error",
                "message" => "Invalid action selected.",
                "title" => "Error"
            ];
            header("Location: ../personal_account.php");
            exit();
    }

} 
function updateProfilePicture($employees_model)
{
    $employee_code = $_POST['employee_code'] ?? null;

    if (!$employee_code || empty($_FILES['profile_picture']['name'])) {
        redirectWithError("Invalid request.");
    }

    $file = $_FILES['profile_picture'];
    $allowedTypes = ['image/jpeg', 'image/png', 'image/webp'];
    $maxSize = 2 * 1024 * 1024; // 2MB

    if (!in_array($file['type'], $allowedTypes)) {
        redirectWithError("Invalid image format.");
    }

    if ($file['size'] > $maxSize) {
        redirectWithError("Image size exceeds 2MB.");
    }

    $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $filename  = 'EMP_' . $employee_code . '_' . time() . '.' . $extension;
    $uploadDir = '../../finance/images/employees/';
    $target    = $uploadDir . $filename;

    if (!move_uploaded_file($file['tmp_name'], $target)) {
        redirectWithError("Failed to upload image.");
    }

    // Update DB
    $employees_model->updateProfilePicture($employee_code, $filename);

    $_SESSION['notification'] = [
        'type' => 'success',
        'title' => 'Success',
        'message' => 'Profile picture updated successfully'
    ];

    header("Location: ../personal_account.php");
    exit;
}

function redirectWithError($message)
{
    $_SESSION['notification'] = [
        'type' => 'error',
        'title' => 'Error',
        'message' => $message
    ];
    header("Location: ../personal_account.php");
    exit;
}


function updateEmployeeDetails($employees_model, $common_model){
    // 1. COLLECT & SANITIZE INPUTS
    $employee_code   = trim($_POST['employee_code'] ?? '');
    $fullname        = trim($_POST['fullname'] ?? '');
    $gender          = trim($_POST['gender'] ?? '');
    $national_id     = trim($_POST['national_id_number'] ?? '');
    $phone           = trim($_POST['phone_number'] ?? '');
    $email           = trim($_POST['email'] ?? '');
    $dob             = $_POST['date_of_birth'] ?? null;
    $nationality     = trim($_POST['nationality'] ?? '');
    $home_village    = trim($_POST['home_village'] ?? '');
    $district_id     = $_POST['district_id'] ?? null;
    $location_id     = $_POST['location_id'] ?? null;

    // 2. REQUIRED FIELD CHECKS
    if (
        empty($fullname) ||
        empty($national_id) ||
        empty($phone) ||
        empty($email)
    ) {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Validation Error",
            "message" => "Full Name, National ID, Phone Number and Email are required."
        ];
        header("Location: ../personal_account.php");
        exit();
    }

    // 3. UNIQUE CHECKS (EXCEPT CURRENT EMPLOYEE)
    if ($employees_model->valueExists('phone_number', $_POST['phone_number'], $employee_code)) {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Duplicate Phone",
            "message" => "Phone number already exists for another employee."
        ];
        header("Location: ../personal_account.php");
        exit();
    }

    if ($employees_model->valueExists('email_address', $_POST['email'], $employee_code)) {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Duplicate Email",
            "message" => "Email address already exists for another employee."
        ];
        header("Location: ../personal_account.php");
        exit();
    }

    if ($employees_model->valueExists('national_id_number', $_POST['national_id_number'], $employee_code)) {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Duplicate National ID",
            "message" => "National ID already exists for another employee."
        ];
        header("Location: ../personal_account.php");
        exit();
    }

    // 4. UPDATE DATA
    $updateData = [
        'employee_code'        => $employee_code,
        'fullname'             => $fullname,
        'gender'               => $gender,
        'national_id_number'   => $national_id,
        'phone_number'         => $phone,
        'email'                => $email,
        'date_of_birth'        => $dob,
        'nationality'          => $nationality,
        'home_village'         => $home_village,
        'district_id'          => $district_id,
        'location_id'          => $location_id
    ];

    $updated = $employees_model->updateEmployee($updateData);

    if ($updated) {
        $_SESSION['notification'] = [
            "type" => "success",
            "title" => "Success",
            "message" => "Employee details updated successfully."
        ];
    } else {
        $_SESSION['notification'] = [
            "type" => "error",
            "title" => "Update Failed",
            "message" => "No changes were made or an error occurred."
        ];
    }

    header("Location: ../personal_account.php");
    exit();
}



?>
