<?php
    session_start();
    date_default_timezone_set('Africa/Blantyre');

    include_once '../model/users_model.php';

    $users_model = new users_model();

    if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])){
        $action = $_POST['action'];

        switch($action){
            case 'change_password':
                changePassword($users_model);
            break;

            default:
            $_SESSION['notification']=[
                'type'=> 'error',
                'title' => 'Failed',
                'message' => 'Unrecognised Action Specified'
            ];
            header('location:../dashboard.php');
            exit();
        }
    }else{
        $_SESSION['notification']=[
            'type'=> 'error',
            'title' => 'Failed',
            'message' => 'Unrecognised Server Request Method'
        ];
        header('location:../dashboard.php');
        exit();
    }

    function changePassword($users_model){
        $newPassword = $_POST['new_password'];
        $confirmPassword = $_POST['confirm_password'];
        $username = $_SESSION['sess_username']; 

        $storedHashedPassword = $users_model->getPasswordByUsername($username);

        if (password_verify($newPassword, $storedHashedPassword)) {
            $_SESSION['notification'] = [
                'type' => 'error', 
                'title' => 'FAILED!',
                'message' => 'New password cannot be the same as the current password.'
            ];
            header('Location: ../change_pass.php?username='.urlencode($username));
            exit();
        }

        if ($newPassword !== $confirmPassword) {
            $_SESSION['notification'] = [
                'type' => 'error', 
                'title' => 'FAILED!',
                'message' => 'Passwords Do Not Match.'
            ];
            header('Location: ../change_pass.php?username='.urlencode($username));
            exit();
        }

        
        $hashedPassword = password_hash($newPassword, PASSWORD_BCRYPT);

        $updateSuccess = $users_model->changePassword($username, $hashedPassword);

        if ($updateSuccess) {
        // Password updated successfully, set toastr notification for success
            $_SESSION['notification'] = [
                'type' => 'success', 
                'title' => 'SUCCESS',
                'message' => 'Successfully Changed Account Password.'
            ];
            // Redirect to the dashboard after successful update
            header('Location: ../dashboard.php');
            exit();
        } else {
            // Password update failed, handle the error
            $_SESSION['notification'] = [
                'type' => 'error', 
                'title' => 'FAILED!',
                'message' => 'Failed to Change Account password.<br>Please try again.'
            ];
            header('Location: ../change_pass.php?username='.urlencode($username));
            exit();
        }
    }



?>