<?php
session_start();
include_once 'model/customers_model.php';
include_once 'model/users_model.php';
include_once 'helpers.php';

$customers_model = new customers_model();
$users_model = new users_model();

$username = $_SESSION['sess_username'];
$employee_code = $_SESSION['sess_employeecode'];
$location = $users_model->fetchLocation($username, $employee_code);

$cash_sale_number = getNextCashSaleNumber($location);
$invoice_number = getNextInvoiceNumber($location);
$quote_number = getNextQuotationNumber($location);

$customer_id = $_POST['customer_id'] ?? 0;
$customer = $customers_model->getCustomerById($customer_id);
$transactions = $customers_model->getTransactions($customer_id);
$last = $customers_model->getCustomerLastActivity($customer_id);

// --- Calculate summary ---
// --- Calculate summary ---
$billable_total = 0;
$total_paid = 0;
$invoice_count = 0;
$last_invoice_date = null;

foreach($transactions as $t){
    $desc = strtolower($t['description']);

    // Skip quotations for totals
    if($desc === 'quotation') continue;

    // Include invoices and cash sales in billable total
    $billable_total += $t['amount'];

    // Count invoices only
    if($desc === 'invoice'){
        $invoice_count++;

        // Track last invoice date
        $invoice_date = strtotime($t['date']);
        if(!$last_invoice_date || $invoice_date > $last_invoice_date){
            $last_invoice_date = $invoice_date;
        }
    }

    // Track total paid from invoices and cash sales
    $total_paid += $t['paid'];
}


// --- Calculate running balance ---
$running_balance = 0;
foreach($transactions as $t){
    $desc = strtolower($t['description']);
    if($desc !== 'quotation'){ // only invoices and cash sales
        $running_balance += ($t['amount'] - $t['paid']);
    }
}

$last_invoice_date_formatted = $last_invoice_date ? date('d M Y', $last_invoice_date) : 'No Invoices';
?>

<style>
.account-header { background:#fff; border-radius:12px; padding:15px; margin-bottom:15px; display:flex; justify-content:space-between; align-items:center; box-shadow:0 4px 12px rgba(0,0,0,.06); }
.balance-amount { font-size:28px; font-weight:600; }
.summary-card { background:#fff; border-radius:12px; padding:15px; text-align:center; box-shadow:0 2px 10px rgba(0,0,0,.05); }
.ledger-table thead { background:#f4f6f9; }
.ledger-table td { vertical-align:middle; }
.table-quotation { background:#fff3cd; } /* Highlight quotations */
</style>

<!-- ACTIONS -->
<div class="mb-3 text-right">
    <a href="new_cash_sale.php?cash_sale_number=<?= $cash_sale_number ?>&customer_id=<?= (int)$customer['customer_id'] ?>" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> New Cash Sale</a>
    <a href="new_customer_invoice.php?invoice_number=<?= $invoice_number ?>&customer_id=<?= (int)$customer['customer_id'] ?>" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> New Invoice</a>
    <a href="new_quote.php?quote_number=<?= $quote_number ?>&customer_id=<?= (int)$customer['customer_id'] ?>" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> New Quotation</a>
    <?php if ($running_balance > 0): ?>
    <a href="capture_invoice_payment.php?customer_id=<?= (int)$customer['customer_id'] ?>" class="btn btn-sm btn-success"><i class="fa fa-money-bill"></i> Receive Payment</a>
    <?php endif; ?>
    <a href="customer_statement.php?customer_id=<?= (int)$customer['customer_id'] ?>" class="btn btn-sm btn-danger"><i class="fa fa-file-pdf"></i> Statement</a>
</div>

<!-- ACCOUNT HEADER -->
<div class="account-header">
    <div>
        <h4 class="mb-0"><?= htmlspecialchars($customer['customer_name']) ?></h4>
        <small class="text-muted"><?= ucfirst($customer['type']) ?> Account</small>
    </div>
    <div class="text-right">
        <small class="text-muted">Outstanding Balance</small>
        <div class="balance-amount <?= $running_balance > 0 ? 'text-danger':'text-success' ?>">
            <?= number_format($running_balance,2) ?>
        </div>
    </div>
</div>

<!-- SUMMARY CARDS -->
<div class="row mb-3">
    <div class="col-md-3 d-flex">
        <div class="card text-center border shadow-sm h-100 w-100">
            <div class="card-body d-flex flex-column justify-content-center">
                <i class="fa fa-file-invoice-dollar fa-2x mb-2"></i>
                <h6 class="card-subtitle mb-2 text-muted">Billable Total</h6>
                <h4 class="card-title text-danger mb-0"><?= number_format($billable_total, 2) ?></h4>
            </div>
        </div>
    </div>
    <div class="col-md-3 d-flex">
        <div class="card text-center border shadow-sm h-100 w-100">
            <div class="card-body d-flex flex-column justify-content-center">
                <i class="fa fa-coins fa-2x mb-2"></i>
                <h6 class="card-subtitle mb-2 text-muted">Total Paid</h6>
                <h4 class="card-title text-success mb-0"><?= number_format($total_paid, 2) ?></h4>
            </div>
        </div>
    </div>
    <div class="col-md-3 d-flex">
        <div class="card text-center border shadow-sm h-100 w-100">
            <div class="card-body d-flex flex-column justify-content-center">
                <i class="fa fa-file-invoice fa-2x mb-2"></i>
                <h6 class="card-subtitle mb-2 text-muted">Invoices</h6>
                <h4 class="card-title mb-0"><?= $invoice_count ?></h4>
            </div>
        </div>
    </div>
    <div class="col-md-3 d-flex">
        <div class="card text-center border shadow-sm h-100 w-100">
            <div class="card-body d-flex flex-column justify-content-center">
                <i class="fa fa-calendar fa-2x mb-2"></i>
                <h6 class="card-subtitle mb-2 text-muted">Last Invoice Date</h6>
                <div class="font-weight-bold"><?= $last_invoice_date_formatted ?></div>
            </div>
        </div>
    </div>
</div>


<?php
// 1. Sort transactions oldest → newest for correct running balance
usort($transactions, function ($a, $b) {
    return strtotime($a['date']) <=> strtotime($b['date']);
});

// 2. Calculate running balance and document balance
$running = 0;
foreach ($transactions as &$t) {
    $desc = strtolower($t['description']);
    $is_quote = ($desc === 'quotation');

    // Document balance (per document)
    $t['document_balance'] = $t['amount'] - $t['paid'];

    // Running balance (ignore quotations)
    if (!$is_quote) {
        $running += $t['document_balance'];
    }

    $t['running_balance'] = $running;
}
unset($t); // break reference

// 3. Reverse for display (newest first)
$transactions = array_reverse($transactions);
?>

<table class="table ledger-table table-hover">
<thead>
<tr>
    <th>Date</th>
    <th>Description</th>
    <th>Ref</th>
    <th class="text-right text-danger">Debit</th>
    <th class="text-right text-success">Credit</th>
    <th class="text-right">Balance</th>
    <th class="text-right">Overall Balance</th>
</tr>
</thead>
<tbody>

<?php foreach ($transactions as $t): 
    $desc = strtolower($t['description']);
    $is_quote = ($desc === 'quotation');

    // Icons
    switch ($desc) {
        case 'invoice':   $icon = 'fa-file-invoice text-primary'; break;
        case 'cash sale': $icon = 'fa-wallet text-success'; break;
        case 'quotation': $icon = 'fa-file-alt text-warning'; break;
        default:          $icon = 'fa-file text-muted';
    }
?>
<tr class="<?= $is_quote ? 'table-quotation' : '' ?>">
    <td><?= date('d M Y', strtotime($t['date'])) ?></td>

    <td>
        <i class="fa <?= $icon ?>"></i>
        <?= htmlspecialchars($t['description']) ?>
    </td>

    <td><?= htmlspecialchars($t['document_no']) ?></td>

    <td class="text-right text-danger">
        <?= $t['amount'] > 0 ? number_format($t['amount'], 2) : '-' ?>
    </td>

    <td class="text-right text-success">
        <?= $t['paid'] > 0 ? number_format($t['paid'], 2) : '-' ?>
    </td>

    <td class="text-right">
        <?= !$is_quote ? number_format($t['document_balance'], 2) : '-' ?>
    </td>

    <td class="text-right font-weight-bold <?= $t['running_balance'] > 0 ? 'text-danger' : 'text-success' ?>">
        <?= number_format($t['running_balance'], 2) ?>
    </td>
</tr>
<?php endforeach; ?>

</tbody>
</table>

