<?php
session_start();

/* Always send headers ONCE, before output */
header('Content-Type: application/json');

if (!isset($_GET['start'], $_GET['end'], $_GET['location'])) {
    echo json_encode([
        'error' => 'Missing parameters',
        'received' => $_GET
    ]);
    exit;
}

$employee_code = $_SESSION['sess_employeecode'];
$location      = (int) $_GET['location'];
$start_date    = $_GET['start'];
$end_date      = $_GET['end'];

include_once 'model/sales_model.php';
include_once 'model/payments_model.php';

$sales_model    = new sales_model();
$payments_model = new payments_model();

$sales    = $sales_model->getSales($location, $start_date, $end_date);
$payments = $payments_model->getPayments($location, $start_date, $end_date, []);

$chart = $sales_model->buildSalesPaymentsChart($sales, $payments, $start_date, $end_date);



$response = [
    'sales'    => $sales,
    'payments' => $payments,
    'chart'    => $chart
];

/* Optional debug logging – safe here */
file_put_contents(
    'debug_response.json',
    json_encode($chart, JSON_PRETTY_PRINT)
);

/* Output JSON ONCE */
echo json_encode($response);
exit;
