<?php  
  session_start();

  if(!isset($_SESSION['sess_username']) || $_SESSION['sess_userrole'] !== 'Supervisor') {
        // Destroy session completely
        session_unset();        // Unset all session variables
        session_destroy();      // Destroy the session itself

        // Redirect to login page with error
        $_SESSION['notification'] = [
					'title' => 'LOGIN FAILED',
					'type' => 'error',
					'message' => 'Your Role Has Not Been Assigned'
				];
				header('Location: ../index.php');
				exit();
  }

  // If session is valid, assign session values

  include_once 'model/common_model.php';
  include_once 'model/users_model.php';

  $common_model = new common_model();
  $users_model = new users_model();
  
  $username = $_SESSION['sess_username'];
  $employee_code = $_SESSION['sess_employeecode'];
  $location = $users_model->fetchLocation($username, $employee_code);
?>
  <link rel="stylesheet" href="../includes/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../includes/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <link rel="stylesheet" href="../includes/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <link rel="stylesheet" href="../includes/plugins/jqvmap/jqvmap.min.css">  
  <link rel="stylesheet" href="../includes/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../includes/css/tables.css">
  <link rel="stylesheet" href="../includes/css/tabs.css" type="text/css"/>
  <link rel="stylesheet" href="../includes/css/media_print.css" type="text/css" />
  <link rel="stylesheet" href="../includes/src/facebox.css" media="screen"  type="text/css" />
  <link rel="stylesheet" href="../includes/assets/toastr/toastr.min.css">
  <link rel="stylesheet" href="../includes/plugins/sweetalert2/sweetalert2.min.css">
  <link rel="stylesheet" href="../includes/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
	<link rel="stylesheet" href="../includes/plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../includes/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../includes/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../includes/plugins/daterangepicker/daterangepicker.css">


  <script src="../includes/plugins/sweetalert2/sweetalert2.all.min.js"></script>
  <script src="../includes/js/core/jquery.min.js"></script>
  <script src="../includes/js/core/popper.min.js"></script>
  <script src="../includes/js/core/bootstrap.min.js"></script>
  <script src="../includes/js/plugins/perfect-scrollbar.jquery.min.js"></script>
  <script src="../includes/js/plugins/bootstrap-notify.js"></script>
  <script src="../includes/assets/toastr/toastr.min.js"></script>

      <style type='text/css'>
        .bg-custom-blue{
          background: #0073b7 !important;
          color:#fff;
        }
        .hide{
          border-color: transparent;
          background-color: transparent;
          display: block;
          width: 100%;
          height: calc(2.25rem + 2px);
          padding: .375rem .75rem;
          font-size: 1rem;
          font-weight: 400;
          line-height: 1.5;
          color: #495057;
          background-color: #fff;
          background-clip: padding-box;
          border: 1px solid #ced4da;
          border-radius: .25rem;
          box-shadow: inset 0 0 0 transparent;
          transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
        }
        .hide:disabled, .hide[readonly] {
          background-color: transparent;
          opacity: 1;
          border: transparent;
        }
        .table-container {
          margin: 0 auto;
          max-width: 800px;
          width:85%;
        }
        /* Remove arrows from number input */
        input[type="number"] {
          -moz-appearance: textfield;
          appearance: textfield;
        }
      
        .nav-item img {
          width: 40px; /* Adjust as needed */
          height: 40px; /* Adjust as needed */
          border-radius: 50%; /* Make it round */
          object-fit: cover; /* Maintain aspect ratio and cover */
          margin-top:-10px;
        }
        #profileDropdown::after {
          display: none;
        }
        @media print {
          table {
            background-color: #fff; /* Change the color to match your desired background */
          }
        }
      </style>
 
    <?php
    $pageName = basename($_SERVER['PHP_SELF']);
    $employee = $_SESSION['sess_employeecode'];
    $username = $_SESSION['sess_username'];
    include_once 'helpers.php';

    
?>

  <div class="wrapper">
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
      </ul>
      
      
      
      <?php
        

        
        
        
        
        $tn_number        = getNextTransferNoteNumber($location);
        $cash_sale_number = getNextCashSaleNumber($location);
        $invoice_number   = getNextInvoiceNumber($location);
        $quote_number     = getNextQuotationNumber($location);
        $dn_number        = getNextDeliveryNoteNumber($location);

        
        $company_name = $common_model->getCompanyName();
        
        $check_incomplete_transfers = $common_model->checkIncompleteTransfers($employee_code);
        $total_incomplete_transfers = $common_model->countIncompleteTransfers($employee_code);

        $check_incomplete_cash_sales = $common_model->checkIncompleteCashSales($employee, $location);
        $total_incomplete_cash_sales = $common_model->countIncompleteCashSales($employee, $location);

        $check_incomplete_invoices = $common_model->checkIncompleteInvoices($employee, $location);
        $total_incomplete_invoices = $common_model->countIncompleteInvoices($employee, $location); 

        $total_incomplete = $total_incomplete_cash_sales + $total_incomplete_invoices + $total_incomplete_transfers;

        $checkTransfers = $common_model->hasPendingTransfers($location);
        $count_transfers = $common_model->countTransfers($location);

        $check_min_stock_levels = $common_model->checkProductsBelowMinOrderLevel($location);
        $check_stock_out = $common_model->checkProductsoutofStock($location);

        $check_delivery_notes = $common_model->checkPendingDeliveryNotes($location);
        $count_delivery_notes = $common_model->countPendingDeliveryNotes($location);

        $check_nots = $common_model->countNotifications($employee_code);
        if($check_nots > 0){
              $fetchNotifications = $common_model->fetchNotificationsData($employee_code);
            }
        $total_notifications = $check_delivery_notes + $check_incomplete_transfers + $checkTransfers + $check_incomplete_cash_sales + $check_incomplete_invoices + $check_min_stock_levels + $check_stock_out + $check_nots; 

        $count_incomplete = $total_incomplete_cash_sales + $total_incomplete_invoices;

        $employeeDetails = $common_model->getuserDetails($username);
        $profile_picture = $employeeDetails['avatar'];

        $set_values = $common_model->getPermissions($username);

        $salesDisplay = $set_values['sales_display'];
        $paymentsDisplay = $set_values['payments_display'];

         if ($salesDisplay == 1) {
            $salesDisplaySetting = 'inline';
        } else {
            $salesDisplaySetting = 'none';
        }

        if ($paymentsDisplay == 1) {
            $paymentsDisplaySetting = 'inline';
        } else {
            $paymentsDisplaySetting = 'none';
        }

        $fullname= $employeeDetails['fullname'];
        $report_permission = $employeeDetails['reports'];
        $custom_permission = $employeeDetails['customers'];
        $userff_permission = $employeeDetails['users'];
        $cashtr_permission = $employeeDetails['cash_trans'];
        $employ_permission = $employeeDetails['employees'];
        $stocki_permission = $employeeDetails['stock'];  
        
        ?>
          <ul class="navbar-nav ml-auto">
            <li class="nav-item dropdown">
              <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-bell fa-2x"></i>
                <span class="badge badge-warning navbar-badge"><?php echo $total_notifications?></span>
              </a>
              
              <?php
                if($total_notifications>0){?>
                  <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">

                  <?php if($check_delivery_notes > 0){ ?>
                    <a href="customer_delivery_notes.php" class="dropdown-item">
                      <i class="fas fa-truck mr-2"></i><?php echo $count_delivery_notes ?> Pending Delivery Notes
                      <span class="float-right text-danger text-sm"><i class="fa fa-star"></i></span>
                    </a>
                    <div class="dropdown-divider"></div>
                  <?php } ?>

                  <?php
                    if($check_stock_out>0){ ?> 
                      <a href="product_stock_report.php?filter=out_of_stock" class="dropdown-item">
                        <i class="fas fa-random mr-2"></i>Products out of Stock
                        <span class="float-right text-danger text-sm"><i class="fa fa-star"></i></span>
                      </a>
                      <div class="dropdown-divider"></div>
                    <?php 
                    }
                  ?>
                  
                  <?php if($check_nots > 0): ?>
                    <?php foreach ($fetchNotifications as $not): ?>
                      <?php
                          $url = '#';
                          if ($not['purpose'] === 'transfer_note') {
                              $url = 'transfer_note.php?transfer_to=' . $not['transfer_to'] . '&id=' . $not['identifier'];
                          }
                      ?>

                      <a class="dropdown-item notification-item"
                        href="<?= $url; ?>"
                        data-notification-id="<?= (int)$not['id']; ?>">
                          <i class="fa fa-tasks icon"></i> <?= htmlspecialchars($not['message']); ?>
                      </a>

                    <?php endforeach; ?>
                  <?php endif; ?>

                  <?php
                    if($check_min_stock_levels>0){ ?> 
                      <a href="product_stock_report.php?filter=low_level" class="dropdown-item">
                        <i class="fas fa-random mr-2"></i>Items running Out of Stock
                        <span class="float-right text-warning text-sm"><i class="fa fa-star"></i></span>
                      </a>
                      <div class="dropdown-divider"></div>
                    <?php 
                    }
                  ?>

                  

                  
                    <?php if($check_incomplete_transfers>0){ ?>
                      <a href="review_transactions.php" class="dropdown-item">
                        <i class="fas fa-random mr-2"></i> View Transfers (<?php echo $total_incomplete_transfers ?>)
                        <span class="float-right text-danger text-sm"><i class="fa fa-star"></i></span>
                      </a>
                      <div class="dropdown-divider"></div>
                    <?php } ?>

                    <?php if($checkTransfers>0){ ?>
                      <a href="stock_transfers.php" class="dropdown-item">
                        <i class="fas fa-tasks mr-2"></i> You Have <?php echo $count_transfers?> Stock Transfers
                        <span class="float-right text-warning text-sm"><i class="fa fa-star"></i></span>
                      </a>
                      <div class="dropdown-divider"></div>
                    <?php }if($count_incomplete > 0){ ?>
                      <a href="review_transactions.php" class="dropdown-item">
                        <i class="fas fa-tasks mr-2"></i><?php echo $count_incomplete ?> Incomplete Transactions
                        <span class="float-right text-warning text-sm"><i class="fa fa-star"></i></span>
                      </a>
                      <div class="dropdown-divider"></div>
                    <?php } ?>

                  </div>
                <?php 
              } ?>
            </li>
        
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" id="profileDropdown" role="button" data-toggle="dropdown" aria-haspopup="true"  aria-expanded="false">
                <img src="avatars/<?php echo $profile_picture ?>">
              </a>
            
              <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                <a class="dropdown-item" href="personal_account.php"><i class="fa fa-cog"></i> Account Settings</a>
              
                <a class="dropdown-item" href="change_pass.php?username=<?php echo $_SESSION['sess_username']?>"><i class="fa fa-lock"> </i> Change Password</a>
              
                <a class="dropdown-item" href="logout.php?session_id=<?php echo $_SESSION['sess_session'] ?>&username=<?php echo $_SESSION['sess_username']?>"><i class="fa fa-sign-in-alt"></i> Account Logout</a>
              </div>
            </li>
          </ul>
        </nav>

      <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <a href="dashboard.php" class="brand-link">
          <img src="../includes/dist/img/AdminLTELogo.png" alt="Company Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
          <span class="brand-text font-weight-light"><?php echo $company_name?></span>
        </a>
    <div class="sidebar">
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
     <div class="info">
     
	

    <a href="#" class="d-block" style="color:white;">
      <?php 
        if($employee =='2002'){
          echo 'Default Account';
        }else{
          echo $fullname; 
        }?>
      </a>
	  <?php ?>
        </div>
      </div>
      
	
      <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
              <?php $pageName = basename($_SERVER['PHP_SELF']);
                if($pageName =='dashboard.php'){ ?>
                  <li class="nav-item menu-open">
                    <a href="dashboard.php" class="nav-link active">
                    <i class="nav-icon fas fa-tachometer-alt"></i>
                      <p>Dashboard</p>
                    </a>
                  </li>
                <?php }else{ ?>
                  <li class="nav-item">
                    <a href="dashboard.php" class="nav-link">
                    <i class="nav-icon fas fa-tachometer-alt"></i>
                      <p>Dashboard</p>
                    </a>
                  </li>
                <?php } ?> 


          <?php if($stocki_permission == 1){ ?>
          <li class="nav-item">
            <?php if($pageName=='manage_products.php' or $pageName == 'product_stock_sheet.php' or $pageName == 'initiate_transfer.php' or $pageName == 'transfer_note.php' or $pageName == 'product_details.php' or $pageName == 'product_breakdown.php' or $pageName == 'stock_transfers.php' ) { ?>
            <a href="#" class="nav-link active">
              <i class="nav-icon fas fa-cubes"></i>
                <p>
                  Manage Products
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php }else{ ?>
              <a href="#" class="nav-link">
              <i class="nav-icon fas fa-cubes"></i>
                <p>
                  Manage Products
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php } ?>
            <ul class="nav nav-treeview">
              	
              <li class="nav-item">
                <a href="manage_products.php" class="nav-link">
                  <i class="fas fa-list nav-icon"></i>
                  <p>Manage Products</p>
                </a>
              </li>

              <li class="nav-item">
                <a href="stock_transfers.php" class="nav-link">
                  <i class="fa fa-list nav-icon"></i>
                  <p>Stock Transfers</p>
                </a>
              </li>

              <li class="nav-item">
                <a href="initiate_transfer.php?tn_number=<?= urlencode($tn_number) ?>" class="nav-link">
                  <i class="fa fa-exchange-alt nav-icon"></i>
                  <p>Initiate Transfer</p>
                </a>
              </li>

            </ul>
          </li>
          <?php } ?>  
       

          
          
          <?php if($custom_permission == 1){ ?>

            <li class="nav-item">
              <?php if($pageName=='manage_customers.php' or $pageName == 'customer_accounts.php' or $pageName == 'customer_database.php' or $pageName == 'customer_transactions.php' or $pageName== 'customer_details.php' ) {  ?>
                <a href="#" class="nav-link active">
                  <i class="nav-icon fas fa-business-time"></i>
                  <p>
                    Customer Center
                    <i class="fas fa-angle-left right"></i>
                  </p>
                </a>
              <?php }else{ ?>
                <a href="#" class="nav-link">
                  <i class="nav-icon fas fa-business-time"></i>
                  <p>
                    Customer Center
                    <i class="fas fa-angle-left right"></i>
                  </p>
                </a>
              <?php } ?>
              <ul class="nav nav-treeview">
                <li class="nav-item">
                  <a href="manage_customers.php" class="nav-link">
                    <i class="fas fa-list nav-icon"></i>
                    <p>View Customers</p>
                  </a>
                </li>
                
                <li class="nav-item">
                  <a href="customer_accounts.php" class="nav-link">
                    <i class="fas fa-user-check nav-icon"></i>
                    <p>Customer Accounts</p>
                  </a>
                </li>
                
                <li class="nav-item">
                  <a href="customer_database.php" class="nav-link">
                    <i class="fas fa-database nav-icon"></i>
                    <p>Customer Database</p>
                  </a>
                </li>
              </ul>
            </li>
          <?php } ?>
          
          

          
         
        

          

          <?php if($cashtr_permission == 1){ ?>
          <li class="nav-item">
            <?php if($pageName=='sales.php' or $pageName =='new_customer_invoice_with_dn.php' or $pageName=='payments.php' or $pageName == 'individual_invoice_payment_receipt.php' or $pageName == 'active_quotations.php' or $pageName == 'invoice_payments.php' or $pageName == 'capture_invoice_payment.php' or $pageName == 'invoice_payment_receipt.php' or $pageName == 'invoices.php' or $pageName == 'new_quote.php' or $pageName == 'customer_quote.php' or $pageName == 'new_cash_sale.php' or $pageName == 'new_customer_invoice.php' or $pageName == 'cash_sale_receipt.php' or $pageName == 'open_invoices.php' or $pageName == 'customer_invoice.php') { ?>
            <a href="#" class="nav-link active">
              <i class="nav-icon fas fa-project-diagram"></i>
              <p>
                Manage sales
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php }else{ ?>
              <a href="#" class="nav-link">
              <i class="nav-icon fas fa-project-diagram"></i>
              <p>
              Manage Sales
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php } ?>
            <ul class="nav nav-treeview">
                
                <li class="nav-item">
                  <a href="new_cash_sale.php?cash_sale_number=<?php echo $cash_sale_number ?>" class="nav-link">
                    <i class="fas fa-cash-register nav-icon"></i>
                    <p>New Cash Sale</p>
                  </a>
                </li>


                <li class="nav-item">
                  <a href="new_customer_invoice.php?invoice_number=<?php echo $invoice_number ?>" class="nav-link">
                    <i class="fas fa-file-invoice-dollar nav-icon"></i>
                    <p>New Invoice</p>
                  </a>
                </li>

               
                
                <li class="nav-item">
                  <a href="capture_invoice_payment.php" class="nav-link">
                    <i class="fab fa-cc-apple-pay nav-icon"></i>
                    <p>Invoice Payment</p>
                  </a>
                </li>


                <li class="nav-item">
                  <a href="new_quote.php?quote_number=<?php echo $quote_number ?>" class="nav-link">
                    <i class="fas fa-file-signature nav-icon"></i>
                    <p>New Quotation</p>
                  </a>
                </li>


                <li class="nav-item">
                  <a href="open_invoices.php" class="nav-link">
                    <i class="fas fa-list nav-icon"></i>
                    <p>Open Invoices</p>
                  </a>
                </li>

                <li class="nav-item">
                  <a href="invoices.php" class="nav-link">
                    <i class="fas fa-list nav-icon"></i>
                    <p>View Invoices</p>
                  </a>
                </li> 

                <li class="nav-item">
                  <a href="invoice_payments.php" class="nav-link">
                    <i class="fas fa-list nav-icon"></i>
                    <p>Invoice Payments</p>
                  </a>
                </li> 

                <li class="nav-item">
                  <a href="active_quotations.php" class="nav-link">
                    <i class="fas fa-list nav-icon"></i>
                    <p>Active Quotations</p>
                  </a>
                </li>  
                
                
                
            </ul>
          </li>
          <?php } ?>

                            
          <?php if($cashtr_permission == 1){ ?>
          <li class="nav-item">
            <?php if($pageName=='new_delivery_note.php' or $pageName == 'customer_delivery_note.php' or $pageName == 'customer_delivery_notes.php') { ?>
            <a href="#" class="nav-link active">
              <i class="nav-icon fas fa-clipboard"></i>
                <p>
                  Delivery Notes
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php }else{ ?>
              <a href="#" class="nav-link">
              <i class="nav-icon fas fa-clipboard"></i>
                <p>
                  Delivery Notes
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php } ?>
            <ul class="nav nav-treeview">
              	
              <li class="nav-item">
                <a href="customer_delivery_notes.php" class="nav-link">
                  <i class="fas fa-truck nav-icon"></i>
                  <p>Delivery Notes</p>
                </a>
              </li>

               <li class="nav-item">
                  <a href="new_delivery_note.php?dn_number=<?php echo $dn_number ?>" class="nav-link">
                    <i class="fa fa-clipboard nav-icon"></i>
                      New Delivery Note
                    </i>
                  </a>
                </li>
            </ul>
          </li>
          <?php } ?>
                  
          
          
          <?php if($report_permission == 1){ ?>
          <li class="nav-item">
            <?php if($pageName=='sales_report.php' or $pageName == 'product_stock_report.php' or $pageName == 'stock_sheets.php') { ?>
            <a href="#" class="nav-link active">
              <i class="nav-icon fas fa-chart-line"></i>
                <p>
                  Reports
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php }else{ ?>
              <a href="#" class="nav-link">
              <i class="nav-icon fas fa-chart-line"></i>
                <p>
                  Reports
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php } ?>
            <ul class="nav nav-treeview">
              	
              <li class="nav-item">
                <a href="sales_report.php" class="nav-link">
                  <i class="fas fa-hand-holding-usd nav-icon"></i>
                  <p>Sales Report</p>
                </a>
              </li>

              <li class="nav-item">
                <a href="stock_sheets.php" class="nav-link">
                  <i class="fa fa-list nav-icon"></i>
                  <p>Stock Sheets</p>
                </a>
              </li>

              <li class="nav-item">
                <a href="product_stock_report.php?filter=low_level" class="nav-link">
                  <i class="fa fa-exclamation-triangle text-warning nav-icon"></i>
                  <p>Low Stock Products</p>
                </a>
              </li>

              <li class="nav-item">
                <a href="product_stock_report.php?filter=out_of_stock" class="nav-link">
                  <i class="fa fa-ban text-danger nav-icon"></i>
                  <p>Products out of Stock</p>
                </a>
              </li>
            

             

            </ul>
          </li>
          <?php } ?>

          <?php if($cashtr_permission == 1){ ?>
            <?php if($pageName=='review_transactions.php' or $pageName == 'incomplete_view.php'){ ?> 
              <li class="nav-item">
                <a href="incomplete_transactions.php" class="nav-link active">
                  <i class="nav-icon fas fa-list"></i>
                  <p>
                    Review Transactions <?php if($total_incomplete>0){?>
                    <sup class="text-blinkings" style="color:red;font-size:14px;"><?php echo $total_incomplete?></sup>
                  <?php } ?>
                
              
              </p>
            </a>
          </li>
          <?php }else{ ?>
            <li class="nav-item">
            <a href="review_transactions.php" class="nav-link">
              <i class="nav-icon fas fa-list"></i>
              <p>
              Review Transactions <?php if($total_incomplete>0){?>
                <sup class="text-blinkings" style="color:red;font-size:14px;"><?php echo $total_incomplete?></sup>
              <?php } ?>
                
              
              </p>
            </a>
          </li>
         <?php  } } ?> 

         <li class="nav-item">
            <?php if($pageName=='personal_account.php' or $pageName == 'change_pass.php' ) { ?>
            <a href="#" class="nav-link active">
              <i class="nav-icon fas fa-user-alt"></i>
              <p>
                  Employee Profile
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php }else{ ?>
              <a href="#" class="nav-link">
              <i class="nav-icon fas fa-user-alt"></i>
              <p>
                  Employee Profile
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php } ?>
            <ul class="nav nav-treeview">
              	<li class="nav-item">
                <a href="personal_account.php" class="nav-link">
                  <i class="fas fa-user nav-icon"></i>
                  <p>Personal Account</p>
                </a>
              </li>

              <li class="nav-item">
                <a href="change_pass.php?username=<?php echo $_SESSION['sess_username']?>" class="nav-link">
                  <i class="fas fa-lock nav-icon"></i>
                  <p>Change Password</p>
                </a>
              </li>

              

              
            </ul>
          </li>

         <?php
          if($pageName =='dashboard.php'){ ?>
                  <li class="nav-item menu-open">
                    <a href="logout.php?session_id=<?php echo $_SESSION['sess_session']?>&username=<?php echo $_SESSION['sess_username']?>" class="nav-link">
                    <i class="nav-icon fas fa-power-off text-red"></i>
                      <p>Logout</p>
                    </a>
                  </li>
                <?php }else{ ?>
                  <li class="nav-item">
                  <a href="logout.php?session_id=<?php echo $_SESSION['sess_session']?>&username=<?php echo $_SESSION['sess_username']?>" class="nav-link">
                    <i class="nav-icon fas fa-power-off text-red"></i>
                      <p>Logout</p>
                    </a>
                  </li>
                <?php } ?> 
         
          

          
         
         
         
			
		  <script src="../includes/src/facebox.js" type="text/javascript"></script>
		  <script type="text/javascript">
		  jQuery(document).ready(function($) {
			$('a[rel*=facebox]').facebox({
			  loadingImage : '../includes/src/loading.gif',
			  closeImage   : '../includes/src/closelabel.png'
			})
		  })
		</script> 
    <script type="text/javascript">
        $(document).ready(function() {
            <?php if (isset($_SESSION['notification'])) { ?>
                var type = "<?php echo $_SESSION['notification']['type']; ?>";
                var title = "<?php echo $_SESSION['notification']['title']; ?>";
                var message = "<?php echo $_SESSION['notification']['message']; ?>";
                
                toastr.options = {
                    "closeButton": true,
                    "progressBar": false,
                    "positionClass": "toast-top-right",
                    "timeOut": "8000",
                    "extendedTimeOut": "1000"
                };

                if (type === 'success') {
					        toastr.success(message, title || "Success");
				        } else if (type === 'error') {
					        toastr.error(message, title || "Error");
				        } else if(type === 'warning'){
					        toastr.warning(message, title || "Warning");
				        } else if(type === 'info') {
                  toastr.info(message, title || "Info");
                }


                // Clear the notification session
                <?php unset($_SESSION['notification']); ?>
            <?php } ?>
        });
    </script> 
          
         
          
          
        </ul>
      </nav>
    </div>
  </aside>
  
<script src="../includes/plugins/select2/js/select2.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
<script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../includes/plugins/moment/moment.min.js"></script>
<script src="../includes/plugins/daterangepicker/daterangepicker.js"></script>



      <script src="../includes/plugins/chart.js/Chart.min.js"></script>
      <script>
$(document).on('click', '.notification-item', function () {
    const notificationId = $(this).data('notification-id');

    // Only DB-backed notifications are marked as read
    if (!notificationId) return;

    $.post('controllers/settings_controller.php', {
        action: 'mark_as_read',
        notification_id: notificationId
    });
});
</script>
  