<?php

include_once 'config.php';

class warehouse_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }
    
    
    
    public function getWarehouses() {
        try {
            $stmt = $this->link->prepare("SELECT 
                    w.*, 
                    l.location_name,
                    COUNT(wp.product_id) AS product_count,
                    w.warehouse_state,
                    CASE 
                        WHEN w.warehouse_state = 1 THEN 'Active warehouse'
                        WHEN w.warehouse_state = 0 THEN 'Deactivated warehouse'
                    END as warehouse_status
                FROM 
                    warehouses w
                LEFT JOIN 
                    locations l ON w.location = l.loc_id
                LEFT JOIN 
                    warehouse_products wp ON w.warehouse_id = wp.warehouse_id
                WHERE 
                    w.warehouse_state IN (0,1)
                GROUP BY 
                    w.warehouse_id
                ORDER BY 
                    w.warehouse_name ASC
            ");
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Get warehouses error: " . $e->getMessage());
            return [];
        }
    }

    public function warehouse_stock($warehouse_id) {
        try {
            $sql = "SELECT 
                        wp.*, 
                        p.product_name, 
                        p.product_code, 
                        wp.opening_stock,
                        wp.quantity,
                        pc.categoryname,
                        pu.unitname,
                        w.warehouse_name,
                        wp.min_level as min_order_level,
                        p.selling_price
                    FROM 
                        warehouse_products wp
                    LEFT JOIN
                        warehouses w ON wp.warehouse_id = w.warehouse_id
                    LEFT JOIN 
                        products p ON wp.product_id = p.product_id
                    LEFT JOIN
                        product_categories pc ON p.category = pc.category_id
                    LEFT JOIN
                        product_units pu ON p.unit = pu.unit_id
                    WHERE 
                        wp.warehouse_id = :warehouse_id";
    
            $stmt = $this->link->prepare($sql);
            $stmt->bindParam(':warehouse_id', $warehouse_id, PDO::PARAM_INT);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        } catch (PDOException $e) {
            error_log("Warehouse stock fetch error: " . $e->getMessage());
            return [];
        }
    }

    public function getWarehouseDetails($warehouse_id) {
        try {
            $sql = "SELECT 
                        w.*, 
                        w.location,
                        l.location_name,
                        (
                            SELECT COUNT(*) 
                            FROM warehouse_products wp 
                            WHERE wp.warehouse_id = w.warehouse_id
                        ) AS total_products
                    FROM 
                        warehouses w
                    LEFT JOIN 
                        locations l ON w.location = l.loc_id
                    WHERE 
                        w.warehouse_id = :warehouse_id";
    
            $stmt = $this->link->prepare($sql);
            $stmt->bindParam(':warehouse_id', $warehouse_id, PDO::PARAM_INT);
            $stmt->execute();
    
            return $stmt->fetch(PDO::FETCH_ASSOC);
    
        } catch (PDOException $e) {
            error_log("Get warehouse details error: " . $e->getMessage());
            return false;
        }
    }
}