<?php
function addPDFHeader($pdf, $title, $logo_path = null, $company_address = '', $company_country = '', $company_phone = '', $company_email = '', $company_website= '') {
    // Set font for header
    $pdf->SetFont('Courier', 'B', 14);

    // Add logo if available
    if ($logo_path && file_exists($logo_path)) {
        $pdf->Image($logo_path, 10, 15, 75, 30);
    }

    // Add company contact info
    if (!empty($company_address) || !empty($company_phone) || !empty($company_email) || !empty($company_country || !empty($company_website))) {
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetXY(125, 20);

        $contact_info = $company_address;
        if (!empty($company_country)) $contact_info .= ', ' . $company_country;
        if (!empty($company_phone)) $contact_info .= "\n" . $company_phone;
        if (!empty($company_email)) $contact_info .= "\n" . $company_email;
        if (!empty($company_website)) $contact_info .= "\n" . $company_website;

        $pdf->MultiCell(0, 7, $contact_info, 0, 'R');
    }

    // Add Title
    $pdf->SetFont('Courier', 'B', 14);
    $pdf->SetTextColor(0, 102, 204);
    $pdf->Cell(0, 10, $title, 0, 1, 'C');

    // Small space
    $pdf->Ln(2);

    // Draw dynamic horizontal line
    $page_width = $pdf->GetPageWidth();
    $margin = 10; // Use the same margin you normally use in your document
    $pdf->SetLineWidth(0.5);
    $pdf->Line($margin, $pdf->GetY(), $page_width - $margin, $pdf->GetY());

    // Space after line
    $pdf->Ln(5);
}

