<?php
/**
 * VARIABLES TO PASS:
 * $docTitle  → e.g., "DELIVERY NOTE", "INVOICE", "RECEIPT"
 * $docNumber → e.g., "DN20240101", "INV20240101", "SO20240101"
 */

include_once 'model/common_model.php';
$common_model = new common_model();

$company_data = $common_model->getCompanyDetails();
?>

<!-- HEADER ROW -->
<div class="row mb-1 align-items-center">

    <div class="col-4 text-left">
        <p class="mb-0 tpin-text">TPIN No. <?=  $company_data['tpin'] ?></p>
    </div>

    <div class="col-2"></div>

    <div class="col-6 text-center">
        <h4 class="dn-title mb-0">
            <?= htmlspecialchars($docTitle) ?> &nbsp; No. <?= htmlspecialchars($docNumber) ?>
        </h4>
    </div>

</div>

<!-- LOGO -->
<div class="row mb-2">
    <div class="col-md-4"></div>

    <div class="col-md-4 text-center">
        <img src="../finance/images/<?=  $company_data['logo'] ?>" class="delivery-logo">
    </div>
    <?php if (!empty($lpo_number)): ?>
    <div 
        class="lpo-number" 
        style="
            position: absolute;
            top: 260px; /* adjust relative to logo */
            left: 73%; /* adjust horizontal position */
            transform: translatex(-50%) rotate(-20deg);
            font-size: 32px;
            font-weight: bold;
            color: rgba(0,0,0,0.2);
            z-index: 1000;
            pointer-events: none;
            white-space: nowrap;
        ">
        LPO #: <?= htmlspecialchars($lpo_number) ?>
    </div>
<?php endif; ?>


    <div class="col-md-4"></div>
</div>

<!-- CONTACT BLOCKS -->
<div class="row mt-2">

    <!-- Corporate Office -->
    <div class="col-md-4 text-left office-block">
        <h6 class="office-title">Corporate Office</h6>
        <p class="mb-0 office-text">AREA 47/3/1210 HSE68</p>
        <p class="mb-0 office-text">LILONGWE</p>
        <p class="mb-0 office-text">Tel: 0 880 006 822, Hotline: 0883 742 305</p>
        <p class="mb-0 office-text">Email: powertexmw@gmail.com</p>
        <p class="mb-0 office-text">Website: www.powertexmw.com</p>
    </div>

    <!-- Blantyre Office -->
    <div class="col-md-4 text-center office-block">
        <h6 class="office-title">Blantyre Office</h6>
        <p class="mb-0 office-text">Claim Building</p>
        <p class="mb-0 office-text">Gly Jones Road</p>
        <p class="mb-0 office-text">Tel: 0 887 626 530</p>
        <p class="mb-0 office-text">Email: powertexmw@gmail.com</p>
        <p class="mb-0 office-text">Website: www.powertexmw.com</p>
    </div>

    <!-- Branches -->
    <div class="col-md-4 text-right office-block">
        <h6 class="office-title">BRANCHES</h6>
        <p class="mb-0 office-text">Zomba - 0 883 742 305</p>
        <p class="mb-0 office-text">Murray Road (LLZ) - 0 887 626 529</p>
        <p class="mb-0 office-text">Area 13 (LLZ) - 0 887 626 528</p>
        <p class="mb-0 office-text">Limbe - 0 887 361 420</p>
    </div>

</div>
