<?php 
include('menu_supervisor.php');
include_once 'model/stock_model.php';

$stock_model = new stock_model();

$tn_number = $_GET['id'];
$destination = $_GET['transfer_to'];

$dn = $stock_model->getDeliveryNote($tn_number);
$items = $stock_model->getDeliveryNoteItems($tn_number);

$state = $dn['transfer_state'];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Powertex || Transfer Note</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">

    <style>
        .delivery-note { font-size: 14px; font-family: "Times New Roman", serif; }
        .delivery-note p { font-size: 16px; }
        .delivery-note h6 { font-size: 14px; }

        .office-title {
            font-size: 20px;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 2px;
        }

        .office-text { font-size: 14px; line-height: 1.15; }
        .office-block { padding: 0 5px; }

        .dn-title { font-size: 22px; font-weight: bold; }

        .delivery-note th,
        .delivery-note td { font-size: 16px; padding: 5px !important; }

        .table td, .table th { border-bottom: 1px solid #000; }

        .delivery-logo { max-height: 70px; margin: 5px auto; display: block; }

        .watermark {
            position: absolute;
            top: 50%;
            left: 55%;
            transform: translate(-50%, -50%) rotate(-30deg);
            font-size: 100px;
            font-weight: bold;
            color: inherit;
            opacity: 0.55;
            white-space: nowrap;
            pointer-events: none;
            z-index: 0;
        }

        @media print {

    body {
        background: #fff !important;
        margin: 0 !important;
        padding: 0 !important;
        font-size: 12pt;
    }

    body * {
        visibility: hidden;
    }

    #printableArea, #printableArea * {
        visibility: visible;
    }

    #printableArea {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        padding: 0;
        margin: 0;
    }

    /* Remove AdminLTE / Bootstrap visual noise */
    .card,
    .card-body,
    .content-wrapper,
    .container-fluid {
        box-shadow: none !important;
        border: none !important;
        padding: 0 !important;
        margin: 0 !important;
        background: #fff !important;
    }

    /* Table print clarity */
    table {
        width: 100% !important;
        border-collapse: collapse !important;
    }

    th, td {
        border: 1px solid #000 !important;
        padding: 6px !important;
        font-size: 11pt !important;
    }

    /* Force rows not to split across pages */
    tr {
        page-break-inside: avoid !important;
    }

    /* Hide all buttons & modals */
    button,
    .modal,
    .btn,
    .card-header {
        display: none !important;
    }

    /* Watermark positioning fix */
    .watermark {
        position: fixed !important;
        top: 45% !important;
        left: 50% !important;
        transform: translate(-50%, -50%) rotate(-30deg) !important;
        font-size: 90px !important;
        opacity: 0.18 !important;
        z-index: 999 !important;
    }
}

    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">
<section class="content">
<div class="container-fluid">

<div class="mb-4">
    <div class="card shadow-sm">
        <div class="card-body d-flex align-items-center">

            <!-- LEFT: TITLE ONLY -->
            <h4 class="mb-0" style="font-weight:bold;">
                Transfer Note #<?= htmlspecialchars($tn_number) ?>
            </h4>

            <!-- RIGHT: ALL ACTION BUTTONS INCLUDING BACK -->
            <div class="d-flex align-items-center ml-auto">  <!-- ✨ THIS IS THE FIX -->

                <?php
                    if($location == $destination):
                        if ($state == 1): ?>
                        
                        <button class="btn btn-success mr-2" onclick="openApproveTransferNoteModal('<?= htmlspecialchars($tn_number, ENT_QUOTES) ?>')">
                            <i class="fa fa-check"></i> Approve Transfer Note
                        </button>

                        <button class="btn btn-danger mr-2" onclick="declineTransferNote('<?= $tn_number ?>')">
                            <i class="fa fa-times-circle"></i> Decline Transfer Note
                        </button>

                        <button class="btn btn-warning mr-2" onclick="handleAdjust('<?= $tn_number ?>')">
                            <i class="fa fa-tasks"></i> Adjust Stock
                        </button>

                <?php 
                        endif;
                    endif;
                ?>

                <!-- PRINT BUTTON -->
                <button class="btn btn-primary mr-2" onclick="window.print()">
                    <i class="fa fa-print"></i> Print
                </button>

                <!-- BACK BUTTON (NOW ON FAR RIGHT) -->
                <button class="btn btn-info" onclick="history.back()">
                    Back <i class="fa fa-arrow-left ml-1"></i>
                </button>

            </div>

        </div>
    </div>
</div>




<div id="printableArea">

<?php
// -------------------------------------------------------
// STATUS AND WATERMARK LOGIC
// -------------------------------------------------------
  // FIXED — now defined early

$statusMap = [
    0 => ['label' => 'Declined',  'badge' => 'badge-danger'],
    1 => ['label' => 'Pending',   'badge' => 'badge-warning'],
    2 => ['label' => 'Received',  'badge' => 'badge-success'],
    3 => ['label' => 'Cancelled', 'badge' => 'badge-secondary']
];

$watermarkText = [
    0 => "DECLINED TN",
    1 => "PENDING APPROVAL",
    3 => "CANCELLED TN"
];

$watermarkColors = [
    0 => 'rgba(255, 0, 0, 0.35)',      // Strong Red
    1 => 'rgba(255, 205, 0, 0.40)',    // Strong Yellow
    2 => 'rgba(0, 230, 118, 0.35)',    // Strong Green
    3 => 'rgba(90, 100, 110, 0.40)'    // Strong Grey
];


$wmText  = $watermarkText[$state] ?? '';
$wmColor = $watermarkColors[$state];
?>

<?php if ($wmText != ''): ?>
    <div class="watermark" style="color: <?= $wmColor ?>;">
        <?= $wmText ?>
    </div>
<?php endif; ?>


<div class="container delivery-note" 
     style="max-width: 960px; background:#fff; padding:25px; border:1px solid #000;">

    <?php 
        $docTitle  = "TRANSFER NOTE";
        $docNumber = $tn_number;
        include('print_header.php'); 
    ?>

    <hr>

    <div style="font-family: Arial; font-size: 12pt; margin-bottom: 15px;">

        <div style="display:flex; justify-content:space-between; align-items:center;">
            <strong><?= htmlspecialchars($dn['delivery_location']) ?></strong>
        </div>

        <hr style="border:1px solid #000; margin:5px 0;">

        <div style="text-align:right;">
            <span style="text-decoration:underline;">
                <strong>Date:</strong> <?= date('d F Y', strtotime($dn['date'])) ?>
            </span>
        </div>

    </div>

    <p style="font-family:Arial; font-size:12pt;">Please receive these goods in good order and condition: -</p>

    <!-- ITEMS TABLE -->
    <!-- ITEMS TABLE -->
     <?php
$showReasonColumn = false;

foreach ($items as $item) {
    if ($item['qty_accepted'] > 0 && $item['qty_accepted'] != $item['qty_initiated']) {
        $showReasonColumn = true;
        break;
    }
}
?>

<table class="table table-bordered">
    <thead>
    <tr>
        <th style="width:20%">Description</th>
        <th>Category</th>
        <th style="width:5%">Original&nbsp;Qty</th>
        <th style="width:5%">Received</th>

        <?php if ($showReasonColumn): ?>
            <th style="width:30%">Reason</th>
        <?php endif; ?>
    </tr>
</thead>

    <tbody>
    <?php foreach ($items as $item): ?>
        <?php 
            $receivedQty = $item['qty_accepted'] > 0 ? $item['qty_accepted'] : $item['qty_initiated'];
            $reasonNeeded = ($item['qty_accepted'] > 0 && $item['qty_accepted'] != $item['qty_initiated']);
        ?>
        <tr>
            <td><?= htmlspecialchars($item['description']) ?></td>
            <td><?= htmlspecialchars($item['categoryname']) ?></td>
            <td style="text-align:center;"><?= htmlspecialchars($item['qty_initiated']) ?></td>
            <td style="text-align:center;"><?= htmlspecialchars($receivedQty) ?></td>

            <?php if ($showReasonColumn): ?>
                <td><?= $reasonNeeded ? htmlspecialchars($item['reason']) : '' ?></td>
            <?php endif; ?>
        </tr>
    <?php endforeach; ?>


            <?php for ($i = count($items); $i < 6; $i++): ?>
        <tr>
            <td>&nbsp;</td>
            <td></td>
            <td></td>
            <td></td>
            <?php if ($showReasonColumn): ?>
                <td></td>
            <?php endif; ?>
        </tr>
    <?php endfor; ?>
</tbody>

</table>


    <br>

    <!-- SIGNATURES -->
    <div class="row mt-3" style="font-size:16pt; font-family:Arial;">

        <!-- Initiated By -->
        <div class="col-4">
            <p class="mb-1"><strong>Initiated By:</strong></p>
            <p class="text-decoration-underline mb-0"><?= htmlspecialchars($dn['initiated_by'])?: 'N/A'?></p>
            <p class="mb-0"><small>Date: <?= date('d F Y', strtotime($dn['initiated_date'])) ?></small></p>
        </div>

        <!-- Delivered / Driver -->
        <div class="col-4 text-center">

            <?php if ($state == 1): ?>
                <p class="mb-1"><strong>Driver Assigned:</strong></p>
                <p class="text-decoration-underline mb-0"><?= htmlspecialchars($dn['delivered_by']) ?></p>
                <p class="mb-0"><small>Date: <?= date('d F Y', strtotime($dn['initiated_date'])) ?></small></p>

            <?php elseif ($state == 2 || $state == 0): ?>
                <p class="mb-1"><strong>Delivered By:</strong></p>
                <p class="text-decoration-underline mb-0"><?= htmlspecialchars($dn['delivered_by']) ?></p>
                <p class="mb-0"><small>Date: <?= date('d F Y H:i', strtotime($dn['driver_delivery_date'])) ?></small></p>

            <?php endif; ?>

        </div>

        <!-- Status Section -->
        <div class="col-4 text-right">

            <?php
            $statusLabel = $statusMap[$state]['label'];
            $badgeClass  = $statusMap[$state]['badge'];
            ?>

            <p class="mb-1"><strong>Status:</strong></p>
            <p class="text-decoration-underline mb-0">
                <span class="badge <?= $badgeClass ?>" style="font-size:14px; padding:4px 10px;">
                    <?= $statusLabel ?>
                </span>
            </p>

            <?php if ($state == 1): ?>
                <p class="mb-0"><small>Date: <?= date('d F Y') ?></small></p>

            <?php elseif ($state == 2): ?>
                <p class="mt-2 mb-1"><strong>Received By:</strong></p>
                <p class="text-decoration-underline mb-0"><?= htmlspecialchars($dn['received_by']) ?></p>
                <p class="mb-0"><small>Date: <?= date('d F Y', strtotime($dn['received_date'])) ?></small></p>

            <?php elseif ($state == 0): ?>
                <p class="mt-2 mb-1"><strong>Declined By:</strong></p>
                <p class="text-decoration-underline mb-0"><?= htmlspecialchars($dn['declined_by']) ?></p>
                <p class="mb-0"><small>Date: <?= date('d F Y', strtotime($dn['date_declined'])) ?></small></p>
                <p class="mt-1 mb-0"><strong>Reason:</strong> <?= htmlspecialchars($dn['reason']) ?></p>

            <?php elseif ($state == 3): ?>
                <p class="mt-2 mb-1"><strong>Cancelled By:</strong></p>
                <p class="text-decoration-underline mb-0"><?= htmlspecialchars($dn['cancelled_by']) ?></p>
                <p class="mb-0"><small>Date: <?= date('d F Y', strtotime($dn['date_cancelled'])) ?></small></p>
                <p class="mt-1 mb-0"><strong>Reason:</strong> <?= htmlspecialchars($dn['reason']) ?></p>

            <?php endif; ?>

        </div>

    </div>

</div>

</div> <!-- /printableArea -->

</div>
</section>
</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>

<!-- Adjust Stock Modal -->
<div class="modal fade" id="adjustStockModal" tabindex="-1" aria-labelledby="adjustStockModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl"> <!-- Changed from modal-lg to modal-xl -->
    <div class="modal-content">
      
      <div class="modal-header">
        <h5 class="modal-title" id="adjustStockModalLabel">Adjust Stock for Transfer Note #<?= htmlspecialchars($tn_number) ?></h5>
        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      
      <div class="modal-body">
        <form id="adjustStockForm">
            <input type="hidden" name="tn_number" value="<?= htmlspecialchars($tn_number) ?>">
          <table class="table table-bordered table-responsive">
            <thead>
              <tr>
                <th style="width:20%">Item</th>
                <th style="width:15%">Category</th>
                <th style="width:19.2%;text-align:center;">Transferred Qty</th>
                <th style="width:18%;text-align:center;">Received Qty</th>
                <th style="width:35%">Reason (required if qty differs)</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($items as $item): ?>
                <tr>
                  <td><?= htmlspecialchars($item['description']) ?></td>
                  <td><?= htmlspecialchars($item['categoryname']) ?></td>
                  <td style="text-align: center;"><?= htmlspecialchars($item['qty'])    ?></td>
                  <td>
                    <input type="number" min="0" max="<?= htmlspecialchars($item['qty']) ?>" 
                           name="received_qty[<?= $item['id'] ?>]" class="form-control received-qty" 
                           value="<?= htmlspecialchars($item['qty']) ?>"
                           data-transferred="<?= htmlspecialchars($item['qty']) ?>">
                  </td>
                  <td>
                    <input type="text" name="reason[<?= $item['id'] ?>]" class="form-control reason-input" placeholder="Enter reason" disabled>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </form>
      </div>
      
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" onclick="submitAdjustStock()">Save Changes</button>
      </div>
      
    </div>
  </div>
</div>

<!-- Stock Overview Modal -->
<div class="modal fade" id="openApproveTransferNoteModal" tabindex="-1" aria-labelledby="openApproveTransferNoteModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="openApproveTransferNoteModalLabel">Approve TN — Transfer Note #<?= htmlspecialchars($tn_number) ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <?php
// get receiver warehouse id (transfer_to) and driver
$receiverWarehouse = $stock_model->getTransferDestination($tn_number);
$warehouseName = $receiverWarehouse['warehouse_name'] ?? 'N/A';
$driverName = $receiverWarehouse['driver'] ?? 'N/A';
$messageReceiver = $receiverWarehouse['operator'];
?>

<div class="d-flex align-items-center mb-3">

    <!-- LEFT: Receiver Warehouse -->
    <div class="flex-fill text-left pr-2">
        <p class="mb-0"><strong>Receiver Warehouse:</strong> <?= htmlspecialchars($warehouseName) ?></p>
    </div>

    <!-- CENTER: Driver Name -->
    <div class="flex-fill text-center px-2">
        <p class="mb-0"><strong>Driver:</strong> <?= htmlspecialchars($driverName) ?></p>
    </div>

    <!-- RIGHT: Delivery Date & Time + DN -->
    <div class="d-flex align-items-center text-right pl-2">
        <label class="mb-0 mr-2"><strong>Delivery Date & Time:</strong></label>

        <input type="datetime-local"
               id="delivery_datetime"
               class="form-control mr-2"
               style="width: 220px;"
               max="<?= date('Y-m-d\TH:i'); ?>"
               required>

        <input type="text" id="deliveryNoteNumber"
               name="dn_number"
               placeholder="Supplier DN Number"
               class="form-control"
               style="width: 260px;"
               required>
        <input type="hidden" name="receiver" id="receiver" value="<?= $messageReceiver ?>" readonly>
    </div>

</div>





        <div class="table-responsive">
          <table class="table table-bordered">
            <thead>
              <tr>
                <th style="width:18%;">Product</th>
                <th style="width:14%;">Category</th>
                <th style="width:12%; text-align:center;">Opening Stock</th>
                <th style="width:12%; text-align:center;">Qty Initiated</th>
                <th style="width:12%; text-align:center;">Qty Accepted</th>
                <th style="width:14%; text-align:center;">Closing Stock</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($items as $item): 
                  // be defensive with field names (some queries used 'qty' vs 'qty_initiated')
                  $productId = $item['product_id'] ?? $item['productid'] ?? null;
                  $description = $item['description'] ?? ($item['product_name'] ?? 'Unknown');
                  $category = $item['categoryname'] ?? ($item['category'] ?? '');

                  // initiated quantity - support both names used in your code
                  $qtyInitiated = isset($item['qty_initiated']) ? floatval($item['qty_initiated']) : (isset($item['qty']) ? floatval($item['qty']) : 0.0);

                  // accepted quantity - may be 0 if not yet set
                  $qtyAccepted = isset($item['qty_accepted']) ? floatval($item['qty_accepted']) : 0.0;

                  // if qty_accepted is 0 (not set) show initiated amount as accepted for display purposes
                  $displayAccepted = ($qtyAccepted > 0) ? $qtyAccepted : $qtyInitiated;

                  // opening stock from warehouse_products
                  $openingStock = 0.0;
                  if ($productId !== null && $receiverWarehouse !== null) {
                      $openingStock = $stock_model->getWarehouseQuantity($productId, $receiverWarehouse['warehouse_id']);
                  }

                  // receiver closing = opening + displayAccepted
                  $receiverClosing = $openingStock + $displayAccepted;
              ?>
              <tr>
                <td><?= htmlspecialchars($description) ?></td>
                <td><?= htmlspecialchars($category) ?></td>
                <td style="text-align:center;"><?= number_format($openingStock, 2) ?></td>
                <td style="text-align:center;"><?= number_format($qtyInitiated, 2) ?></td>
                <td style="text-align:center;"><?= number_format($displayAccepted, 2) ?></td>
                <td style="text-align:center;"><?= number_format($receiverClosing, 2) ?></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

      </div><!-- modal-body -->
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel

        </button>

        <button type="button" class="btn btn-success" onclick="approveTransferNote('<?= $tn_number ?>')">
            <i class="fa fa-check"></i> Approve Transfer
        </button>

      </div>
    </div>
  </div>
</div>

<script>
function approveTransferNote(tn_number) {
    const deliveryDatetime = document.getElementById('delivery_datetime').value;
    const deliverynoteNumber = document.getElementById('deliveryNoteNumber').value;
    const receiver = document.getElementById('receiver').value;
    if (!deliveryDatetime) {
        Swal.fire({
            icon: "warning",
            title: "Missing Delivery Date & Time",
            text: "Please select delivery date and time     ."
        });
        return;
    }
    
    if (!deliverynoteNumber) {
        Swal.fire({
            icon: "warning",
            title: "Missing Delivery Note Number",
            text: "Please Enter delivery note number from Supplier."
        });
        return;
    }

    Swal.fire({
        title: "Approve Transfer Note?",
        text: "Are you sure you want to approve this Transfer Note?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Approve TN",
        cancelButtonText: "Cancel"
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Processing...',
                text: 'Please wait',
                allowEscapeKey: false,
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });

            setTimeout(() => {
                $.ajax({
                    url: "controllers/transfer_controller.php",
                    method: "POST",
                    dataType: "json",
                    data: { 
                        action: "approve_transfer",
                        tn_number: tn_number,
                        delivery_date: deliveryDatetime,
                        deliverynoteNumber:deliverynoteNumber,
                        debug: 0, // <-- enable debug mode
                        receiver:receiver
                    },
                    success: function(response) {
                        Swal.close();
                        if(response.status === "preview") {
                            console.table(response.items); // preview all products
                            Swal.fire({
                                title: "Preview Ready",
                                html: "<pre>" + JSON.stringify(response.items, null, 2) + "</pre>",
                                width: 800,
                                icon: "info"
                            });
                        } else if(response.status === "success") {
                            Swal.fire({
                                icon: "success",
                                title: "Approved!",
                                text: response.message
                            }).then(() => location.reload());
                        } else {
                            Swal.fire({
                                icon: "error",
                                title: "Error",
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr) {
                        let msg = "Something went wrong. Please try again.";
                        if (xhr.responseJSON && xhr.responseJSON.message) msg = xhr.responseJSON.message;
                        Swal.fire({
                            icon: "error",
                            title: "Unexpected Error",
                            text: msg
                        });
                    }
                });
            }, 2000);
        }
    });
}

</script>



<script>
function openApproveTransferNoteModal(tn_number) {
    // the modal content is already rendered server-side; just show it
    $('#openApproveTransferNoteModal').modal('show');
}
</script>


<script>
  // Enable reason input if received qty differs from transferred qty
  $(document).on('input', '.received-qty', function() {
    const transferred = parseInt($(this).data('transferred'));
    const received = parseInt($(this).val());
    const reasonInput = $(this).closest('tr').find('.reason-input');
    
    if(received !== transferred) {
      reasonInput.prop('disabled', false);
      reasonInput.prop('required', true);  // Make reason mandatory
    } else {
      reasonInput.prop('disabled', true);
      reasonInput.prop('required', false);
      reasonInput.val('');
    }
  });

  function submitAdjustStock() {
    // Ensure all required fields are filled
    if (!$('#adjustStockForm')[0].checkValidity()) {
      $('#adjustStockForm')[0].reportValidity();
      return;
    }

    const formData = $('#adjustStockForm').serialize();
    console.log(formData);

    // TODO: AJAX call to save adjusted quantities and reasons
  }
</script>

<script>
    function handleAdjust(tnNumber) {
    $('#adjustStockModal').modal('show');
}

function submitAdjustStock() {
    if (!$('#adjustStockForm')[0].checkValidity()) {
        $('#adjustStockForm')[0].reportValidity();
        return;
    }

    const formData = $('#adjustStockForm').serialize();

    // Show loading spinner for 5 seconds minimum
    Swal.fire({
        title: 'Saving Changes...',
        text: 'Please wait while we update your stock adjustments.',
        allowOutsideClick: false,
        allowEscapeKey: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    const startTime = Date.now();

    $.post('adjust_stock_action.php', formData, function(response){
        console.log(response);

        const elapsed = Date.now() - startTime;
        const remaining = 2500 - elapsed; // enforce 5 seconds minimum

        setTimeout(() => {

            if (response.status === 'success') {

                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: response.message,
                    confirmButtonColor: '#3085d6'
                }).then(() => {
                    $('#adjustStockModal').modal('hide');
                    location.reload();
                });

            } else {

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message,
                    confirmButtonColor: '#d33'
                });

            }

        }, remaining > 0 ? remaining : 0);

    }, 'json');
}

function declineTransferNote(tn_number) {

    Swal.fire({
        title: "Decline Transfer Note",
        input: "textarea",
        inputLabel: "Reason for Declining",
        inputPlaceholder: "Enter detailed reason...",
        inputAttributes: {
            "aria-label": "Reason for declining"
        },
        showCancelButton: true,
        confirmButtonText: "Submit",
        cancelButtonText: "Cancel",
        allowOutsideClick: false,
        preConfirm: (reason) => {
            if (!reason || reason.trim() === "") {
                Swal.showValidationMessage("Reason is required when declining");
                return false;
            }
            return reason;
        }
    }).then((result) => {
        if (!result.isConfirmed) return;

        let reason = result.value.trim();

        // show quick loader before sending request
        Swal.fire({
            title: "Processing...",
            text: "Updating transfer note...",
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // enforce 25ms loader
        setTimeout(() => {

            $.post("decline_transfer.php", {
                tn_number: tn_number,
                reason: reason
            }, function(response){
                console.log(response);

                if (response.status === "success") {
                    Swal.fire({
                        icon: "success",
                        title: "Declined",
                        text: response.message,
                        confirmButtonColor: "#3085d6"
                    }).then(() => {
                        location.reload();
                    });

                } else {
                    Swal.fire({
                        icon: "error",
                        title: "Error",
                        text: response.message
                    });
                }

            }, "json");

        }, 25);
    });
}



</script>

</body>
</html>
