<?php
session_start();
include_once '../model/banking_model.php';
date_default_timezone_set('Africa/Blantyre');

$banking_model = new banking_model();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {

    $action = $_POST['action'];

    switch ($action) {

        case 'create_deposit':
            createBankDeposit($banking_model);
            break;

        case 'record_expense':
            recordExpense($banking_model);
            break;
        default:
            $_SESSION['notification'] = [   
                'type' => 'error',
                'title' => 'INVALID ACTION',
                'message' => 'The requested action is not recognized.'
            ];
            header("Location: ../dashboard.php");
            exit();
    }
}


function recordExpense($banking_model) {
    // Ensure required fields are present
    $required = ['expense_description','expense_date','amount_paid','location'];
    foreach($required as $field) {
        if(empty($_POST[$field])) {
            $_SESSION['error'] = "Field '{$field}' is required.";
            header("Location: ../record_expense.php");
            exit();
        }
    }
    $reference_number = trim($_POST['reference_number'] ?? '');
    if ($reference_number === '') {
        $reference_number = null; // Ensure NULL if nothing selected
    }
    $expense_description = trim($_POST['expense_description']);
    $expense_date = $_POST['expense_date'];
    $amount_paid = floatval($_POST['amount_paid']);
    $location = intval($_POST['location']);
    $operator = $_SESSION['sess_employeecode'] ?? 0;
    $datecaptured = date('Y-m-d H:i:s');

    $recorded = $banking_model->insertExpense(['reference_number' => $reference_number, 'expense_description' => $expense_description, 'expense_date' => $expense_date, 'amount_paid' => $amount_paid, 'location' => $location, 'datecaptured' => $datecaptured, 'operator' => $operator]);

    if($recorded) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'SUCCESS',
            'message' => "Expense recorded successfully!"
        ];
        header("Location: ../expense_details.php?id=".$recorded);
        exit();
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FAILED',
            'message' => "Failed to record expense. Please try again."
        ];
    }
    header("Location: ../record_expense.php");
    exit();
}

function createBankDeposit($banking_model) {
    // Ensure required fields are present
    $required = ['deposit_date','account_id','amount','deposited_by','location'];
    foreach($required as $field) {
        if(empty($_POST[$field])) {
            $_SESSION['error'] = "Field '{$field}' is required.";
            header("Location: ../cashier/deposit_form.php");
            exit;
        }
    }

    $deposit_date   = $_POST['deposit_date'];
    $account_id     = intval($_POST['account_id']);
    $amount         = floatval($_POST['amount']);
    $deposited_by   = trim($_POST['deposited_by']);
    $reference      = trim($_POST['reference_number'] ?? '');
    $description    = trim($_POST['description'] ?? '');
    $location       = intval($_POST['location']);

    // ✅ NEW: check duplicate reference (only if provided)
    if(!empty($reference)) {
        if($banking_model->referenceExists($reference, $location)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'DUPLICATE REFERENCE',
                'message' => 'This deposit reference number has already been used.'
            ];
            header("Location: ../new_bank_deposit.php");
            exit();
        }
    }

    // Get total cash raised for branch
    $total_cash = $banking_model->getTotalCashSales($location);
    $total_deposited = $banking_model->getTotalDeposited($location);
    $outstanding_cash = $total_cash - $total_deposited;

    // Validate deposit amount
    if($amount > $outstanding_cash) {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FAILED!',
            'message' => "Deposit amount cannot exceed outstanding cash: MWK ".number_format($outstanding_cash,2)
        ];
        header("Location: ../new_bank_deposit.php");
        exit;
    }

    // Prepare deposit data
    $deposit_data = [
        'account_id'    => $account_id,
        'deposit_date'  => $deposit_date,
        'amount'        => $amount,
        'deposited_by'  => $deposited_by,
        'reference'     => $reference,
        'description'   => $description,
        'location'      => $location,
        'datecaptured'  => date('Y-m-d H:i:s'),
        'operator'      => $_SESSION['sess_employeecode'] ?? 0
    ];

    // Insert deposit
    $inserted = $banking_model->insertDeposit($deposit_data);

    if($inserted) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'SUCCESS',
            'message' => "Cash deposit of MWK ".number_format($amount,2)." recorded successfully!"
        ];
        header("Location: ../bank_deposit_slip.php?deposit_id=".$inserted);
        exit();
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FAILED',
            'message' => "Failed to record deposit. Please try again."
        ];
        header("Location: ../new_bank_deposit.php"); // ✅ fixed missing Location:
        exit();
    }
}
?>