<?php 
include('menu_cashier.php');
include_once 'model/customers_model.php';
include_once 'model/branch_model.php';

$branch_model    = new branch_model();
$customers_model = new customers_model();

$branchDetails = $branch_model->getBranchDetails($location);
$customers     = $customers_model->customerDatabase($location);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Customer Database | Powertex</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="../includes/plugins/fontawesome-free/css/all.min.css">

    <!-- AdminLTE -->
    <link rel="stylesheet" href="../includes/dist/css/adminlte.min.css">

    <style>
        .content-wrapper { background-color: #ffffff; }
        table td, table th { color: #212529; vertical-align: middle; }
        .badge-walkin     { background-color: #6c757d; color:#fff; }
        .badge-dealer     { background-color: #007bff; color:#fff; }
        .badge-corporate  { background-color: #6f42c1; color:#fff; }
        .badge-individual { background-color: #28a745; color:#fff; }
        .badge-active     { background-color: #28a745; color:#fff; }
        .badge-inactive   { background-color: #dc3545; color:#fff; }
        .expand-row { cursor:pointer; background-color:#f9f9f9; }
        .child-row { display:none; background-color:#f1f1f1; }
        .transaction-badge { font-size:0.85em; padding:0.25em 0.5em; }
        .tooltip-inner { max-width: 300px; white-space: pre-wrap; }
    </style>
</head>

<body class="hold-transition sidebar-mini">
<div class="wrapper">

    <div class="content-wrapper p-4">

        <!-- PAGE HEADER -->
        <div class="mb-4">
            <h3 class="text-dark">
                <i class="fas fa-users text-primary"></i>
                Customer Database
                <small class="text-muted">
                    – <?= htmlspecialchars($branchDetails['branch_name'] ?? 'All Branches') ?>
                </small>
            </h3>
        </div>

        <!-- SEARCH -->
        <div class="card mb-3">
            <div class="card-body">
                <input type="text"
                       id="searchCustomer"
                       class="form-control form-control-sm"
                       placeholder="Search by name, phone, ID, type, email...">
            </div>
        </div>

        <!-- CUSTOMER TABLE -->
        <div class="card">
            <div class="card-body p-0">
                <table class="table table-bordered table-hover table-sm">
                    <thead class="thead-light">
                        <tr>
                            <th><i class="fas fa-id-badge"></i> ID</th>
                            <th><i class="fas fa-user"></i> Name</th>
                            <th><i class="fas fa-envelope"></i> Email</th>
                            <th><i class="fas fa-phone"></i> Phone</th>
                            <th><i class="fas fa-tags"></i> Type</th>
                            <th><i class="fas fa-dollar-sign"></i> Total Sales</th>
                            <th><i class="fas fa-calendar-alt"></i> Last Sale</th>
                            <th><i class="fas fa-toggle-on"></i> Status</th>
                            <th style="width: 12%;text-align: center;"><i class="fas fa-cog"></i> Actions</th>
                        </tr>
                    </thead>
                    <tbody id="customerTable">

                        <?php if (!empty($customers)): ?>
                            <?php foreach ($customers as $c): ?>
                                <?php
                                    $badgeClass = 'badge-secondary';
                                    if ($c['customer_type'] === 'Walk-In')     $badgeClass = 'badge-walkin';
                                    if ($c['customer_type'] === 'Dealer')      $badgeClass = 'badge-dealer';
                                    if ($c['customer_type'] === 'Corporate')   $badgeClass = 'badge-corporate';
                                    if ($c['customer_type'] === 'Individual')  $badgeClass = 'badge-individual';

                                    $statusBadge = $c['customer_state'] == 1
                                        ? '<span class="badge badge-active">Active</span>'
                                        : '<span class="badge badge-inactive">Inactive</span>';

                                    // SALES SUMMARY
                                    $summary = $customers_model->getCustomerSalesSummary($c['customer_id'], 5);
                                    $totalSales = $summary['total_sales'];
                                    $lastSale   = $summary['last_sale_date'];
                                    $transactions = $summary['transactions'];
                                ?>

                                <!-- MAIN ROW -->
                                <tr class="expand-row">
                                    <td><?= htmlspecialchars($c['customer_id']) ?></td>
                                    <td><?= htmlspecialchars($c['customer_name']) ?></td>
                                    <td><?= htmlspecialchars($c['email'] ?? '-') ?></td>
                                    <td><?= htmlspecialchars($c['phone']) ?></td>
                                    <td><span class="badge <?= $badgeClass ?>"><?= htmlspecialchars($c['customer_type']) ?></span></td>
                                    <td style="text-align: right;"><?= number_format($totalSales, 2) ?></td>
                                    <td><?= $lastSale ? date('d M Y', strtotime($lastSale)) : '-' ?></td>
                                    <td><?= $statusBadge ?></td>
                                    <td style="text-align: center;">
                                        <a href="customer_profile.php?id=<?= urlencode($c['customer_id']) ?>" class="btn btn-sm btn-primary" title="View Profile"><i class="fas fa-eye"></i></a>
                                        <a href="edit_customer.php?id=<?= urlencode($c['customer_id']) ?>" class="btn btn-sm btn-secondary" title="Edit Customer"><i class="fas fa-edit"></i></a>
                                        <a href="toggle_customer.php?id=<?= urlencode($c['customer_id']) ?>" class="btn btn-sm btn-warning" title="Activate/Deactivate"><i class="fas fa-power-off"></i></a>
                                        <a href="mailto:<?= htmlspecialchars($c['email'] ?? '') ?>" class="btn btn-sm btn-info" title="Send Email"><i class="fas fa-envelope"></i></a>
                                    </td>
                                </tr>

                                <!-- CHILD ROW: Last Transactions -->
                                <tr class="child-row">
                                    <td colspan="9">
                                        <strong>Last <?= count($transactions) ?> Transactions:</strong>
                                        <ul class="mb-0 mt-2">
                                            <?php if (!empty($transactions)): ?>
                                                <?php foreach ($transactions as $t): ?>
                                                    <li>
                                                        <span class="badge transaction-badge <?= $t['color'] ?>" 
                                                              data-toggle="tooltip" 
                                                              title="<?= htmlspecialchars($t['tooltip']) ?>">
                                                            <?= date('d M', strtotime($t['date'])) ?> - <?= htmlspecialchars($t['ref_number']) ?> - $<?= number_format($t['total'],2) ?>
                                                        </span>
                                                    </li>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <li>No transactions found</li>
                                            <?php endif; ?>
                                        </ul>
                                    </td>
                                </tr>

                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center text-muted">
                                    No customers found
                                </td>
                            </tr>
                        <?php endif; ?>

                    </tbody>
                </table>

            </div>
        </div>

    </div>
</div>

<!-- JS -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.min.js"></script>

<script>
    // SEARCH FUNCTION
    $("#searchCustomer").on("keyup", function () {
        let value = $(this).val().toLowerCase();
        $("#customerTable tr.expand-row").filter(function () {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // EXPAND / COLLAPSE ROW FOR LAST TRANSACTIONS
    $(".expand-row").on("click", function () {
        $(this).next(".child-row").toggle();
    });

    // ENABLE TOOLTIPS
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>

</body>
</html>
