<?php 
    include('menu_cashier.php');
    include_once 'model/sales_model.php';
    include_once 'model/warehouse_model.php';

    $sales_model = new sales_model();
    $warehouse_model = new warehouse_model();

    $dnotes = $sales_model->getCustomerDeliveryNotes($location);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Delivery Notes</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">

    <style>
        table td,
table th {
    vertical-align: middle !important;
}
    </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <!-- Header: Title + Filter + Export -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-end mb-3">
        <!-- Title -->
        <h3 class="mb-0">
            Customer Delivery Notes 
            <span class="badge badge-secondary ml-2"><?= count($dnotes) ?></span>   
        </h3>

        <!-- Filter + Export -->
        <div class="d-flex flex-column flex-sm-row align-items-stretch align-items-sm-end mt-2 mt-md-0" style="min-width: 300px;">
            <!-- Filter input -->
            <input type="text" id="filter_global" class="form-control mb-2 mb-sm-0" placeholder="Search Customers Delivery Note" style="flex: 1;">
        </div>
    </div>

    <!-- TABLE -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-sm table-hover" id="deliveryNotesTable">
            <thead>
                <tr>
                    <th>DN Number</th>
                    <th>DN Date</th>
                    <th>Customer</th>
                    <th>Invoice Number</th>
                    <th>Reference</th>
                    <th class="text-center">Number of Products</th>
                    <th class="text-center">Total Quantity</th>
                    <th class="text-center">DN Status</th>
                    <th class="text-center" style="width:15%">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($dnotes as $dn): 
                    $rowClass = '';
                    if ($dn['dn_state'] == 1) {
                        $rowClass = 'table-warning';
                    } elseif ($dn['dn_state'] == 2) {
                        $rowClass = 'table-success';
                    } elseif ($dn['dn_state'] == 0) {
                        $rowClass = 'table-danger';
                    }
                ?>
                    <tr class="<?= $rowClass ?> align-middle">

                        <td><?= $dn['dn_number'] ?></td>
                        <td><?= $dn['dn_date'] ?></td>
                        <td><?= $dn['customer_name'] ?></td>
                        <td><?= $dn['invoice_ref'] ?></td>
                        <td><?= $dn['reference'] ?></td>
                        <td class="text-center text-success font-weight-bold"><?= $dn['number_of_products'] ?></td>
                        <td class="text-center text-success font-weight-bold"><?= $dn['total_quantity'] ?></td>
                        <td class="text-center"><?= $dn['dn_status'] ?></td>
                       
                        <td class="text-center">
                            <a href="customer_delivery_note.php?dn_number=<?= urlencode($dn['dn_number']) ?>" class="btn btn-info" title="View Delivery Note">
                                <i class="fas fa-file-invoice"></i>
                            </a>

                            <button 
                                class="btn btn-success send-doc"
                                data-channel="whatsapp"
                                data-doc-type="<?= ($dn['sale_type']=='customer_delivery_note') ? 'customer_delivery_note' : 'invoice' ?>"
                                data-reference="<?= $dn['dn_number'] ?>"
                                data-dn-state="<?= $dn['dn_state'] ?>"
                                title="Send via WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </button>

                            <button 
                                class="btn btn-primary send-doc"
                                data-channel="email"
                                data-doc-type="<?= ($dn['sale_type']=='customer_delivery_note') ? 'customer_delivery_note' : 'invoice' ?>"
                                data-reference="<?= $dn['dn_number'] ?>"
                                data-dn-state="<?= $dn['dn_state'] ?>"
                                title="Send via Email">
                                <i class="fas fa-envelope"></i>
                            </button>


                            <button 
                                class="btn btn-danger cancel-dn"
                                data-dn-number="<?= $dn['dn_number'] ?>"
                                data-dn-state="<?= $dn['dn_state'] ?>"
                                title="Cancel Delivery Note">
                                <i class="fas fa-times-circle"></i>
                            </button>


                            <button class="btn btn-info feature-not-ready">
                                <i class="fa fa-cog"></i>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>

                


        </table>
    </div>

</div>

<!-- SCRIPTS -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
        <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="../includes/dist/js/adminlte.js"></script>
        
        <script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
    let table;

                $(document).ready(function () {

                    table = $('#deliveryNotesTable').DataTable({
                        paging: true,
                        pageLength: 500,
                        lengthChange: false,
                        ordering: true,
                        order: [
                            [4, 'desc'],
                            [0, 'desc']
                        ],
                        info: true,
                        searching: true,
                        responsive: true,
                        autoWidth: false,
                        dom: 'rtip',
                        columnDefs: [{
                            targets: 7, // Status column
                            render: function (data, type) {
                                if (type === 'filter' || type === 'search') {
                                    return $('<div>').html(data).text().replace(/\s+/g, ' ').trim();
                                }
                                return data;
                            }
                        }]
                    });


                   

                   
                    // Global search
                    $('#globalSearch').on('keyup', function () {
                        table.search(this.value).draw();
                    });

                    // Payment Method filter (column 4)
                    $('#filterPaymentMethod').on('change', function () {
                        table.column(5).search(this.value).draw();
                    });

                    // Status filter (column 6)
                    $('#filterStatus').on('change', function () {
                        let val = this.value;

                        console.log('Selected:', val);

                        if (val) {
                            table.column(7)
                                .search('^' + val + '$', true, false)
                                .draw();
                        } else {
                            table.column(7).search('').draw();
                        }
                    });

                    table.column(7).data().each(function (d) {
                        console.log(JSON.stringify(d));
                    });


                });
$(document).ready(function(){
    // Global search filter
    $("#filter_global").on("keyup", function(){
        let value = $(this).val().toLowerCase();
        $("#productTable tbody tr").filter(function(){
            $(this).toggle($(this).text().toLowerCase().includes(value));
        });
    });

    // Feature not ready
    $(".feature-not-ready").on("click", function(e) {
        e.preventDefault();
        toastr.info("This feature is currently disabled.", "Message", {
            closeButton: true,
            progressBar: true,
            timeOut: 3500,
            positionClass: "toast-top-right"
        });
    });

    // Edit button
    $(".edit-btn").on("click", function(){
        let product = $(this).data("product");
        $("#modal_product_id").val(product.id);
        $("#modal_warehouse_id").val(product.warehouse_id);
        $("#modal_product_name").val(product.name);
        $("#modal_product_code").val(product.code);
        $("#modal_category").val(product.category);
        $("#modal_unit").val(product.unit);
        $("#modal_selling_price").val(product.selling_price);
        $("#modal_opening_stock").val(product.opening_stock);
        $("#modal_current_qty").val(product.current_qty);
        $("#modal_min_order_level").val(product.min_order_level || 0);

        $("#minOrderModal").modal("show"); // BS4 compatible
    });
});
</script>
<script>
$(document).on('click', '.send-doc', function () {

    const channel   = $(this).data('channel');
    const docType   = $(this).data('doc-type');
    const reference = $(this).data('reference');
    const dnState   = parseInt($(this).data('dn-state'));

    // ❌ Block if Cancelled
    if (dnState === 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Cancelled',
            text: 'This Delivery Note is cancelled. Sending is not allowed.'
        });
        return;
    }

    // ❌ Block if Cancellation Request Pending
    if (dnState === 3) {
        Swal.fire({
            icon: 'info',
            title: 'Pending Cancellation',
            text: 'Cancellation request is pending approval. Sending is not allowed.'
        });
        return;
    }



    Swal.fire({
        title: 'Send Document?',
        text: `Send this ${docType.replace('_',' ')} via ${channel}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Proceed To Send',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            sendDocument(channel, docType, reference);
        }
    });
});

function sendDocument(channel, docType, reference) {

    // 🔹 Show loader while server is generating document
    Swal.fire({
        title: 'Please wait...',
        html: 'Processing Data...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: 'controllers/documents_controller.php',
        type: 'POST',
        dataType: 'json',
        data: {
            channel: channel,
            document_type: docType,
            reference: reference
        },
        success: function (res) {
            console.log('WhatsApp URL:', res.debug ? res.debug.url : 'No URL');

            Swal.close(); // 🔹 Close the loader first

            if (res.success) {

                if (channel === 'whatsapp' && res.debug && res.debug.url) {
                    window.open(res.debug.url, '_blank'); // existing WhatsApp behavior
                }

                // ✅ Show success for both WhatsApp and Email
                Swal.fire({
                    icon: 'success',
                    title: 'Ready',
                    html: res.message
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    html: res.message
                });
            }
        },

        error: function () {
            Swal.close(); // 🔹 Close loader even if request fails
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Could not send document.'
            });
        }
    });
}

</script>
<script>
    $(document).on('click', '.cancel-dn', function () {

    const dnNumber = $(this).data('dn-number');
    const dnState  = parseInt($(this).data('dn-state'));

    // STATE = 0 → Already Cancelled
    if (dnState === 0) {
        Swal.fire({
            icon: 'info',
            title: 'Already Cancelled',
            text: 'This Delivery Note is already cancelled.'
        });
        return;
    }

    // STATE = 2 → Invoice Created
    if (dnState === 2) {
        Swal.fire({
            icon: 'warning',
            title: 'Cannot Cancel',
            text: 'Invoice already created. Cancellation not allowed.'
        });
        return;
    }

    // STATE = 3 → Pending Approval
    if (dnState === 3) {
        Swal.fire({
            icon: 'info',
            title: 'Pending Approval',
            text: 'Cancel request already sent. Awaiting admin approval.'
        });
        return;
    }

    // STATE = 1 → Allow request
    if (dnState === 1) {

        Swal.fire({
            title: 'Request Cancellation?',
            text: 'Reqest to cancel Delivery Note?',
            icon: 'question',
            reverseButtons: true,
            showCancelButton: true,
            confirmButtonText: 'Send Request',
            cancelButtonText: 'No, Don\'t Cancel'
        }).then((result) => {

            if (result.isConfirmed) {
                $.ajax({
                    url: 'controllers/sales_controller.php',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'request_dn_cancel',
                        dn_number: dnNumber
                    },
                    success: function (res) {

                        if (res.success) {

                            Swal.fire({
                                icon: 'success',
                                title: 'Request Sent',
                                text: 'Cancellation request sent to admin.'
                            });
                            location.reload();

                            // 🔹 Update button state
                            let button = $('.cancel-dn[data-dn-number="' + dnNumber + '"]');
                            button.attr('data-dn-state', 3);

                            // 🔹 Update row color (remove old classes first)
                            let row = button.closest('tr');
                            row.removeClass('table-warning table-success table-danger');
                            row.addClass('table-secondary'); // Pending style

                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Failed',
                                text: res.message || 'Could not send request.'
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Server Error',
                            text: 'Something went wrong.'
                        });
                    }
                });

            }

        });
    }

});
</script>
</body>
</html>
