<?php
header("Content-Type: text/csv");
header("Content-Disposition: attachment; filename=cash_payments.csv");

include 'model/sales_model.php';

$salesModel = new sales_model();
$location = $_POST['location'] ?? '';
if(isset($_POST['from_date']) && isset($_POST['to_date'])) {
    $start_date = $_POST['from_date'];
    $end_date = $_POST['to_date'];
} else {
    $start_date = date('Y-m-01');
    $end_date = date('Y-m-d');
}   
$payments = $salesModel->getCashPayments($location, $start_date, $end_date);
$output = fopen("php://output", "w");

fputcsv($output, [
    'Date',
    'Sale/Invoice No',
    'Receipt No',
    'Transaction Type',
    'Deposit Status',
    'Customer',
    'Amount'
]);

foreach($payments as $row){
    fputcsv($output, $row);
}

fclose($output);
exit;

?>