<?php
require_once '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('chroot', realpath(__DIR__ . '/../../'));

$dompdf = new Dompdf($options);

$type      = $_REQUEST['document_type'] ?? null;
$reference = $_REQUEST['reference'] ?? null;
$debug = (int) ($_REQUEST['debug'] ?? 0);



if (!$type || !$reference) {
    die('Invalid document request');
}

$document_number = $reference;

ob_start();
switch ($type) {
    case 'invoice':
        include 'documents/invoice.php';
        break;
    
    case 'cash_sale':
        include 'documents/cashsale.php';
        break;

    case 'quotation':
        include 'documents/quotation.php';
        break;

    default:
        echo "<h2>Invalid document type specified.</h2>";
        break;
}

$html = ob_get_clean();
$dompdf->loadHtml($html);
// Render PDF
$dompdf->render();

if ($debug == 1) {
    // Clear all previous output
    while (ob_get_level()) {
        ob_end_clean();
    }


    // Force PDF headers
    header("Content-Type: application/pdf");
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");
    header("Content-Disposition: inline; filename=\"{$type}_{$reference}.pdf\"");

    // Stream PDF inline
    $dompdf->stream("{$type}_{$reference}.pdf", [
        'Attachment' => false
    ]);
    exit;
}


// -----------------------------
// Save PDF locally (WAMP)
// -----------------------------
$localDir = __DIR__ . '/tmp/';
if (!is_dir($localDir)) {
    mkdir($localDir, 0777, true);
}

$filename  = "{$type}_{$reference}.pdf";
$localPath = $localDir . $filename;

file_put_contents($localPath, $dompdf->output());


// -----------------------------
// Upload PDF to LIVE SERVER via FTP
// -----------------------------
$ftpHost = 'poweronline-mw.com';
$ftpUser = 'smplus';
$ftpPass = '0991123495@Tomaida';
$ftpPort = 21;

$ftp = ftp_connect($ftpHost, $ftpPort);
if (!$ftp) {
    die(json_encode(['success' => false, 'error' => 'FTP connection failed']));
}

if (!ftp_login($ftp, $ftpUser, $ftpPass)) {
    ftp_close($ftp);
    die(json_encode(['success' => false, 'error' => 'FTP login failed']));
}

// Passive mode (IMPORTANT)
ftp_pasv($ftp, true);

// Remote path (inside public_html)
$remotePath = '/powertex/cashier/pdf/generated/' . $filename;

// Upload
if (!ftp_put($ftp, $remotePath, $localPath, FTP_BINARY)) {
    ftp_close($ftp);
    die(json_encode(['success' => false, 'error' => 'FTP upload failed']));
}   
ftp_close($ftp);



// -----------------------------
// Return LIVE URL (Twilio-accessible)
// -----------------------------
$webUrl = 'https://poweronline-mw.com/cashier/pdf/generated/' . $filename;

header('Content-Type: application/json');
echo json_encode([
    'success' => true,
     'localPath' => $localPath,
    'path'     => $webUrl
]);
exit;


