        <?php 
            include('menu_cashier.php');
            include_once 'model/sales_model.php';

            $sales_model = new sales_model();

            if(!isset($_GET['start_date']) && !isset($_GET['end_date'])){
                $start_date = date('Y-m-01');
                $end_date = date('Y-m-t');
            }else{
                $start_date = $_GET['start_date'];
                $end_date = $_GET['end_date'];
            }
            $sales = $sales_model->getSales($location, $start_date, $end_date);
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>Powertex || Sales</title>
            <link rel="icon" type="image/png" href="../finance/images/favicon.png">

            
            
            
        </head>

        <body class="hold-transition sidebar-mini layout-fixed">

        <div class="content-wrapper p-4">
            <section class="content">
                <div class="container-fluid">

                    <h4 class="mb-3">
                        Sales Summary
                    </h4>


                    <div class="row mb-3 align-items-center">

    <div class="col-md-3">
        <input type="text"
               id="globalSearch"
               class="form-control"
               placeholder="Search sales...">
    </div>

    <div class="col-md-2">
        <select id="filterSaleType" class="form-control">
            <option value="">All Sale Types</option>
            <option value="Cash Sale">Cash Sale</option>
            <option value="Customer Invoice">Customer Invoices</option>
        </select>
    </div>

    <div class="col-md-2">
        <select id="filterStatus" class="form-control">
            <option value="">All Status</option>
            <option value="Paid">Paid</option>
            <option value="Partial">Partial</option>
            <option value="Unpaid">Unpaid</option>
        </select>
    </div>

    <div class="col-md-5">
    <div id="dateFilterBar" class="d-flex align-items-center">

        <div class="input-group mr-2">
            <input type="text"
                   class="form-control"
                   id="start_date"
                   value="<?= $start_date ?>"
                   autocomplete="off">
            <div class="input-group-append">
                <span class="input-group-text">
                    <i class="far fa-calendar-alt"></i>
                </span>
            </div>
        </div>

        <div class="input-group mr-2">
            <input type="text"
                   class="form-control"
                   id="end_date"
                   value="<?= $end_date ?>"
                   autocomplete="off">
            <div class="input-group-append">
                <span class="input-group-text">
                    <i class="far fa-calendar-alt"></i>
                </span>
            </div>
        </div>

        <button id="applyDateFilter" class="btn btn-primary">
            Filter
        </button>

    </div>
</div>

</div>



</div>



                    <!-- TABLE -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title">Sales Transactions</h5>
                        </div>

                        <div class="card-body table-responsive">
                            <table id="salesTable" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Reference</th>
                                        <th>Type</th>
                                        <th>Customer</th>
                                        <th class="text-right">Amount</th>
                                        <th class="text-right">Paid</th>
                                        <th class="text-right">Discount</th>
                                        <th class="text-right">Balance</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php if (empty($sales)): ?>
                                        <tr>
                                            <td colspan="10" class="text-center text-muted">
                                                No sales records found.
                                            </td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($sales as $row): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($row['date']) ?></td>
                                                <td><?= htmlspecialchars($row['reference']) ?></td>
                                                <td><?= htmlspecialchars($row['sale_type']) ?></td>
                                                <td><?= htmlspecialchars($row['customer']) ?></td>
                                                <td class="text-right"><?= number_format($row['amount'], 2) ?></td>
                                                <td class="text-right"><?= number_format($row['paid'], 2) ?></td>
                                                <td class="text-right"><?= number_format($row['discount'], 2) ?></td>
                                                <td class="text-right"><?= number_format($row['balance'], 2) ?></td>
                                                <td>
                                                    <span class="<?= ($row['status']=='Paid')?'badge badge-success':($row['status']=='Partial'?'badge badge-warning':'badge badge-danger') ?>">
                                                        <?= $row['status'] ?>
                                                    </span>
                                                </td>
                                                <td class="text-center">
                                                    <?php 
                                                    $url = ($row['sale_type']=='Cash Sale')?'cash_sale_receipt.php?id='.$row['reference']:'customer_invoice.php?invoice_number='.$row['reference']; 
                                                    ?>
                                                    <a href="<?= $url ?>" class="btn btn-sm btn-info"><i class="fas fa-receipt"></i></a>
                                                    <!-- Send WhatsApp -->
                                                    <button 
                                                        class="btn btn-success btn-sm send-doc"
                                                        data-channel="whatsapp"
                                                        data-doc-type="<?= ($row['sale_type']=='Cash Sale') ? 'cash_sale' : 'invoice' ?>"
                                                        data-reference="<?= $row['reference'] ?>"
                                                        title="Send via WhatsApp">
                                                        <i class="fab fa-whatsapp"></i>
                                                    </button>

                                                    <!-- Send Email -->
                                                    <button 
                                                        class="btn btn-primary btn-sm send-doc"
                                                        data-channel="email"
                                                        data-doc-type="<?= ($row['sale_type']=='Cash Sale') ? 'cash_sale' : 'invoice' ?>"
                                                        data-reference="<?= $row['reference'] ?>"
                                                        title="Send via Email">
                                                        <i class="fas fa-envelope"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>

                                <tfoot>
                                    <tr style="background:#333;color:#fff;font-weight:bold;">
                                        <td colspan="4" class="text-left">TOTAL</td>
                                        <td class="text-right" id="totalAmount"></td>
                                        <td class="text-right" id="totalPaid"></td>
                                        <td class="text-right" id="totalDiscount"></td>
                                        <td class="text-right" id="totalBalance"></td>
                                        <td colspan="2"></td>
                                    </tr>
                                </tfoot>
                            </table>


                        </div>
                    </div>

                </div>
            </section>
        </div>

        <script src="../includes/plugins/jquery/jquery.min.js"></script>
        <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="../includes/dist/js/adminlte.js"></script>
        
        <script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
        <link rel="stylesheet" href="../includes/plugins/daterangepicker/daterangepicker.css">
        <script src="../includes/plugins/moment/moment.min.js"></script>
        <script src="../includes/plugins/daterangepicker/daterangepicker.js"></script>

        <script>
            $('#applyDateFilter').on('click', function () {

                const start = $('#start_date').val();
                const end   = $('#end_date').val();

                if (!start || !end) {
                    alert('Please select both dates');
                    return;
                }

                const params = new URLSearchParams(window.location.search);
                params.set('start_date', start);
                params.set('end_date', end);

                window.location.search = params.toString();
            });
        </script>

        <script>
        function refuse(Role) {
            toastr.options = {
                "closeButton": true,
                "positionClass": "toast-top-right",
                "timeOut": "5000",
                "extendedTimeOut": "3000"
            };
            toastr.error(`You don't have permission to view ${Role} Transactions.`, "Permission Denied");
        }
        </script>
        <script>

            $('#start_date, #end_date').daterangepicker({
    singleDatePicker: true,
    showDropdowns: true,
    autoUpdateInput: true,
    locale: {
        format: 'YYYY-MM-DD'
    }
});

let table;

$(document).ready(function () {

    table = $('#salesTable').DataTable({
        paging: true,
        pageLength: 15,
        lengthChange: false,
        ordering: true,
        order: [[0, 'desc']],
        info: true,
        searching: true,
        responsive: true,
        autoWidth: false,
        dom: 'rtip',
        columnDefs: [
        {
            targets: 8, // Status column
            render: function (data, type) {
                if (type === 'filter' || type === 'search') {
                    // strip HTML and return plain text
                    return $('<div>').html(data).text().trim();
                }
                return data; // display unchanged
            }
        }
    ]
    });

    // INITIAL TOTALS (important)
    calculateTotals();

    // Recalculate totals on every draw
    table.on('draw', function () {
        calculateTotals();
    });

    // Global search
    $('#globalSearch').on('keyup', function () {
        table.search(this.value).draw();
    });

    // Sale Type filter
    $('#filterSaleType').on('change', function () {
        table.column(2).search(this.value).draw();
    });

    $('#filterStatus').on('change', function () {
    let val = this.value;

    if (val) {
        table.column(8)
            .search('^' + val + '$', true, false)
            .draw();
    } else {
        table.column(8).search('').draw();
    }
});




});

function calculateTotals() {

    let totalAmount = 0;
    let totalPaid = 0;
    let totalDiscount =0;
    let totalBalance = 0;

    table.rows({ search: 'applied' }).every(function () {

        let data = this.data();

        totalAmount   += parseFloat(data[5].replace(/,/g, '')) || 0;
        totalPaid     += parseFloat(data[6].replace(/,/g, '')) || 0;
        totalDiscount += parseFloat(data[7].replace(/,/g, '')) || 0;
        totalBalance  += parseFloat(data[8].replace(/,/g, '')) || 0;
    });

    $('#totalAmount').text(totalAmount.toLocaleString(undefined, { minimumFractionDigits: 2 }));
    $('#totalPaid').text(totalPaid.toLocaleString(undefined, { minimumFractionDigits: 2 }));
    $('#totalDiscount').text(totalDiscount.toLocaleString(undefined, { minimumFractionDigits: 2 }));
    $('#totalBalance').text(totalBalance.toLocaleString(undefined, { minimumFractionDigits: 2 }));
}   
</script>
<script>
$(document).on('click', '.send-doc', function () {

    const channel   = $(this).data('channel');     // whatsapp | email
    const docType   = $(this).data('doc-type');    // cash_sale | invoice | quotation
    const reference = $(this).data('reference');

    Swal.fire({
        title: 'Send Document?',
        text: `Send this ${docType.replace('_',' ')} via ${channel}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Proceed To Send',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            sendDocument(channel, docType, reference);
        }
    });
});

function sendDocument(channel, docType, reference) {

    // 🔹 Show loader while server is generating document
    Swal.fire({
        title: 'Please wait...',
        html: 'Processing Data...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: 'controllers/documents_controller.php',
        type: 'POST',
        dataType: 'json',
        data: {
            channel: channel,
            document_type: docType,
            reference: reference
        },
        success: function (res) {
            console.log('WhatsApp URL:', res.debug ? res.debug.url : 'No URL');

            Swal.close(); // 🔹 Close the loader first

            if (res.success) {

                if (channel === 'whatsapp' && res.debug && res.debug.url) {
                    window.open(res.debug.url, '_blank'); // existing WhatsApp behavior
                }

                // ✅ Show success for both WhatsApp and Email
                Swal.fire({
                    icon: 'success',
                    title: 'Ready',
                    html: res.message
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    html: res.message
                });
            }
        },

        error: function () {
            Swal.close(); // 🔹 Close loader even if request fails
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Could not send document.'
            });
        }
    });
}

</script>





        </body>
        </html>
