<?php
session_start();
header('Content-Type: application/json');
include_once 'model/employees_model.php';

// Set the default timezone to Blantyre, Malawi
date_default_timezone_set('Africa/Blantyre'); // Set to Blantyre's timezone

$data = json_decode(file_get_contents('php://input'), true);

$employees_model = new employees_model();

// Extract and validate inputs
$startDate = $data['startDate'] ?? null;
$endDate = $data['endDate'] ?? null;
$numDays = $data['numDays'] ?? null;
$requestId = $data['requestId'] ?? null;
$leave_state = 1;
$approvedBy = $_SESSION['sess_employeecode'] ?? null; // or use your session key
$approvedDate = date('Y-m-d H:i:s');

$leaveDetails = $employees_model->getleaveSlipData($requestId);
$employee_code = $leaveDetails['employee'];

$leave_summary = $employees_model->getleaveSummaryData($employee_code);

 if (!$startDate || !$endDate || !$numDays || !$requestId || !$approvedBy) {
    echo json_encode(['success' => false, 'message' => 'Incomplete data']);
    exit;
}

if (strtotime($startDate) > strtotime($endDate)) {
    echo json_encode(['success' => false, 'message' => 'Start date cannot be after end date.']);
    exit;
}
if($numDays > $leave_summary['total_left']){
    echo json_encode(['success' => false, 'message' => 'Number of days exceed leave days remaining.']);
    exit;
}

try {
    $success = $employees_model->approveLeaveRequest($requestId, $startDate, $endDate, $numDays, $leave_state, $approvedBy, $approvedDate);

    echo json_encode(['success' => $success]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} 
