<!DOCTYPE html>
<html lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" href="images/favicon.png" type="image/ico" />
  <title>Powertex LTD</title>

  <?php include_once 'css_links.php'; ?>
  <style>
    /* Inline filters with DataTables search */
    .dt-filters {
        display: inline-block;
        margin-left: 10px;
    }
    .dt-filters .form-control {
        height: 30px;
        padding: 3px 6px;
        font-size: 12px;
        display: inline-block;
        margin-right: 5px;
    }
    .dt-filters .btn {
        margin-left: 5px;
        height: 30px;
        padding: 4px 10px;
        font-size: 12px;
    }
    #bankTable_wrapper .dataTables_filter {
    text-align: right;
}
  .dataTables_filter { display: block !important; }

#bankTable_wrapper .dataTables_filter input,
#bankTable_wrapper .dataTables_filter select {
    display: inline-block;
    width: auto;
    margin-left: 5px;
}
    #bankTable td:last-child {
        white-space: nowrap;
    }

    .dataTables_wrapper .dt-buttons,
.dataTables_wrapper .dataTables_filter {
    display: inline-block;
    vertical-align: middle;
}
/* Match DataTables search field with custom filters */
/* Force search input to match custom filters */
.dataTables_wrapper .dataTables_filter input,
.dataTables_wrapper .dataTables_filter input.form-control.input-sm {
    height: 30px !important;
    padding: 3px 6px !important;
    font-size: 12px !important;
    line-height: 1.42857143; /* match Bootstrap normal input */
    display: inline-block;
    margin-left: 5px;
}
/* Fix DataTables search input height to match custom filters */
#bankTable_wrapper .dataTables_filter input {
    height: 30px !important;       /* match filter inputs */
    padding: 3px 6px !important;
    font-size: 12px !important;
    line-height: 1.42857143 !important;
    display: inline-block;
    margin-left: 5px;
}

div.dt-container .dt-search input,
div.dt-container .dt-input {
    height: 30px !important;
    padding: 3px 6px !important;
    font-size: 12px !important;
    line-height: 1.42857143 !important;
    border-radius: 3px;
}




  </style>
</head>

<body class="nav-md">
<div class="container body">
  <div class="main_container">

    <?php
    include 'menu_finance.php';
    include_once 'model/banking_model.php';

    $banking_model = new banking_model();
    $accounts = $banking_model->getBankAccounts();

    $selectedMonth = isset($_GET['month']) ? intval($_GET['month']) : date('m');
    $selectedYear  = isset($_GET['year'])  ? intval($_GET['year'])  : date('Y');

    $deposits = $banking_model->getAllDeposits($selectedMonth, $selectedYear);

    $totalApproved = $totalPending = $totalCancelled = 0;
    $countApproved = $countPending = $countCancelled = 0;

    foreach($deposits as $deposit){
        switch($deposit['deposit_state']){
            case 1:
                $totalApproved += $deposit['amount'];
                $countApproved++;
                break;
            case 2:
                $totalPending += $deposit['amount'];
                $countPending++;
                break;
            case 0:
                $totalCancelled += $deposit['amount'];
                $countCancelled++;
                break;
        }
    }

    $totalCashPayments      = $banking_model->getTotalCashPayments();
    $totalCashExpenses      = $banking_model->getTotalApprovedExpenses();
    $totalApprovedDeposits  = $banking_model->getTotalApprovedDeposits();

    $outstandingCash = $totalCashPayments - $totalCashExpenses - $totalApprovedDeposits;
    ?>

    <div class="right_col" role="main">
      <div class="">

        <div class="row mb-4">
            <div class="col-md-3">
                <div class="x_panel bg-primary text-white">
                    <div class="x_title"><h4>Total Cash Received</h4></div>
                    <h3>MK <?php echo number_format($totalCashPayments,2); ?></h3>
                </div>
            </div>

            <div class="col-md-3">
                <div class="x_panel bg-info text-white">
                    <div class="x_title"><h4>Total Cash Expenses</h4></div>
                    <h3>MK <?php echo number_format($totalCashExpenses,2); ?></h3>
                </div>
            </div>

            <div class="col-md-3">
                <div class="x_panel bg-success text-white">
                    <div class="x_title"><h4>Total Deposited</h4></div>
                    <h3>MK <?php echo number_format($totalApprovedDeposits,2); ?></h3>
                </div>
            </div>

            <div class="col-md-3">
                <div class="x_panel <?php echo ($outstandingCash < 0) ? 'bg-red' : 'bg-dark'; ?> text-white">
                    <div class="x_title"><h4>Outstanding Cash</h4></div>
                    <h3>MK <?php echo number_format($outstandingCash,2); ?></h3>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-3">
                <div class="x_panel bg-green text-white">
                    <div class="x_title"><h4>Approved Deposits</h4></div>
                    <h3>MK <?php echo number_format($totalApproved,2); ?></h3>
                    <p><?php echo $countApproved; ?> Transactions</p>
                </div>
            </div>

            <div class="col-md-3">
                <div class="x_panel bg-orange text-white">
                    <div class="x_title"><h4>Pending Deposits</h4></div>
                    <h3>MK <?php echo number_format($totalPending,2); ?></h3>
                    <p><?php echo $countPending; ?> Transactions</p>
                </div>
            </div>

            <div class="col-md-3">
                <div class="x_panel bg-red text-white">
                    <div class="x_title"><h4>Cancelled Deposits</h4></div>
                    <h3>MK <?php echo number_format($totalCancelled,2); ?></h3>
                    <p><?php echo $countCancelled; ?> Transactions</p>
                </div>
            </div>

            <div class="col-md-3">
                <div class="x_panel">
                    <div class="x_title"><h4>Total Deposits</h4></div>
                    <h3><?php echo count($deposits); ?></h3>
                    <p><?php echo date("F Y", mktime(0,0,0,$selectedMonth,1,$selectedYear)); ?></p>
                </div>
            </div>
        </div>

        <!-- Table Filters + DataTables Search -->
        <table id="bankTable" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Reference</th>
                    <th>Bank</th>
                    <th>Account Name</th>
                    <th>Account</th>
                    <th>Amount</th>
                    <th>Deposited By</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php $i=1; foreach($deposits as $row): ?>
                <tr>
                    <td><?php echo $i++; ?></td>
                    <td data-order="<?php echo $row['date_deposited']; ?>">
                        <?php echo date('d M Y', strtotime($row['date_deposited'])); ?>
                    </td>
                    <td><strong><?php echo $row['deposit_reference']; ?></strong></td>
                    <td><?php echo $row['bank_name']; ?></td>
                    <td><?php echo $row['account_name']; ?></td>
                    <td><?php echo $row['account_number']; ?></td>
                    <td class="text-success font-weight-bold"><?php echo number_format($row['amount'],2); ?></td>
                    <td><?php echo $row['operator_name']; ?></td>
                    <td>
                        <?php
                            if($row['deposit_state'] == 1) echo '<span class="label label-success">Approved</span>';
                            elseif($row['deposit_state'] == 0) echo '<span class="label label-danger">Cancelled</span>';
                            else echo '<span class="label label-warning">Pending</span>';
                        ?>
                    </td>
                    <td>
                        <div class="btn-group">
                            <a href="deposit_slip.php?id=<?php echo $row['deposit_id']; ?>" class="btn btn-info btn-sm">
                                <i class="fa fa-eye"></i>
                            </a>
                            <?php if($row['deposit_state'] != 0): ?>
                            <button class="btn btn-danger btn-sm cancel-deposit-btn" data-id="<?php echo $row['deposit_id']; ?>">
                                <i class="fa fa-times"></i>
                            </button>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>

      </div>
    </div>
  </div>
</div>

<?php include_once 'footer.php'; ?>
<?php include_once 'libraries.php'; ?>

<script>
$(document).ready(function(){

    var table = $('#bankTable').DataTable({
    responsive: true,
    pageLength: 10,
    ordering: true,
    dom:
      "<'row'<'col-sm-4'B><'col-sm-8 text-right'f>>" +
      "<'row'<'col-sm-12'tr>>" +
      "<'row'<'col-sm-4'i><'col-sm-8'p>>",
    buttons: [
    { 
        extend: 'excelHtml5', 
        className: 'btn btn-success', 
        text: '<i class="fa fa-file-excel-o"></i> Excel', 
        title: 'Bank_Deposits_<?php echo date("F_Y"); ?>' 
    },
    { 
        extend: 'pdfHtml5', 
        className: 'btn btn-danger', 
        text: '<i class="fa fa-file-pdf-o"></i> PDF', 
        title: 'Bank Deposits Report', 
        orientation: 'landscape', 
        pageSize: 'A4' 
    },
    { 
        extend: 'print', 
        className: 'btn btn-primary', 
        text: '<i class="fa fa-print"></i> Print', 
        title: 'Bank Deposits Report' 
    }
],
    initComplete: function () {
        var wrapper = $(this.api().table().container());
        var searchContainer = wrapper.find('.dt-search');

        console.log(wrapper.html());

        var extraFilters = `
            <span style="margin-left:15px;">
                <input type="date" id="fromDate" class="form-control input-sm" style="width:180px; display:inline-block; margin-right:5px;">
                <input type="date" id="toDate" class="form-control input-sm" style="width:180px; display:inline-block; margin-right:5px;">
                <select id="statusFilter" class="form-control input-sm" style="width:200px; height:33px;border:1px solid #ccc; border-radius:3px; display:inline-block; margin-right:5px;">
                    <option value="">All Status</option>
                    <option value="Approved">Approved</option>
                    <option value="Pending">Pending</option>
                    <option value="Cancelled">Cancelled</option>
                </select>
                <button id="applyFilters" class="btn btn-primary btn-sm">Apply</button>
                <button id="resetFilters" class="btn btn-secondary btn-sm">Reset</button>
            </span>
        `;

        searchContainer.append(extraFilters);
    }
});

});
</script>

<script>
$(document).on('click', '.cancel-deposit-btn', function(){
    let id = $(this).data('id');
    Swal.fire({
        title: 'Cancel Deposit?',
        text: 'This action is used for duplicated or fraudulent deposits.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        confirmButtonText: 'Yes, Cancel',
        reverseButtons: true
    }).then((result) => {
        if(result.isConfirmed){
            $.post('controllers/banks_controller.php', { action: 'cancel_deposit', id: id }, function(response){
                let data = JSON.parse(response);
                if(data.success){
                    Swal.fire('Cancelled!', data.message, 'success').then(()=> location.reload());
                } else {
                    Swal.fire('Error', data.message, 'error');
                }
            });
        }
    });
});

// Custom filtering
$.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {

    var fromDate = $('#fromDate').val();
    var toDate   = $('#toDate').val();
    var status   = $('#statusFilter').val();

    // Table columns (based on your markup)
    var date = data[1];   // Date column
    var rowStatus = data[8]; // Status column (Approved / Pending / Cancelled)

    // Convert displayed date (e.g., 23 Jan 2026) to real Date
    var parsedDate = new Date(date);

    if (fromDate) {
        if (parsedDate < new Date(fromDate)) {
            return false;
        }
    }

    if (toDate) {
        if (parsedDate > new Date(toDate)) {
            return false;
        }
    }

    if (status) {
        if (rowStatus.indexOf(status) === -1) {
            return false;
        }
    }

    return true;
});

// Apply
$(document).on('click', '#applyFilters', function() {
    table.draw();
});

// Reset
$(document).on('click', '#resetFilters', function() {
    $('#fromDate').val('');
    $('#toDate').val('');
    $('#statusFilter').val('');
    table.draw();
});
</script>

</body>
</html>