<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                    include 'menu_finance.php';
                    include_once 'model/stock_model.php';
                    $product_id = $_GET['product_id'];

                    $stock_model = new stock_model();
                    $productDetails = $stock_model->getProductDetailsbyID($product_id);

                    $stock_data = $stock_model->getStockByProductId($product_id);

                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center">
                                            <!-- Left Title -->
                                            <h2 class="mb-0">Manage Products</h2>

                                            <!-- Center Title -->
                                            <h2 class="mb-0 text-center flex-grow-1">Product Breakdown - <?php echo $productDetails['product_name']?></h2>

                                            <li>
                                                <button class="btn btn-info" onclick="history.back();">Back</button>
                                            </li>
                                        </div>

                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box">

                                                        <?php if (!empty($stock_data)): ?>

                                                            <!-- 1. Table View -->  
                                                            <div class="table-responsive mb-4">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Product Name</th>
                                                                            <th>Location</th>
                                                                            <th>Type</th>
                                                                            <th>Date Added</th>
                                                                            <th style="text-align: center;">Minimum Level</th>
                                                                            <th style="text-align: center;">Quantity</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <?php foreach ($stock_data as $item): 
                                                                            // Determine row class
                                                                            $rowClass = '';
                                                                            if ($item['quantity'] == 0) {
                                                                                $rowClass = 'bg-danger text-white';
                                                                            } elseif ($item['quantity'] <= $item['min_order_level']) {
                                                                                $rowClass = 'bg-warning';
                                                                            }
                                                                        ?>
                                                                            <tr class="<?= $rowClass ?>">
                                                                                <td><?= htmlspecialchars($item['product_name']) ?></td>
                                                                                <td><?= htmlspecialchars($item['name']) ?></td>
                                                                                <td><?= ucfirst($item['type']) ?></td>
                                                                                <td><?= !empty($item['date_added']) ? date('d M Y', strtotime($item['date_added'])) : 'N/A' ?></td>
                                                                                <td style="text-align: center;"><?= $item['min_order_level'] ?></td>
                                                                                <td style="text-align: center;"><?= $item['quantity'] ?></td>
                                                                                
                                                                            </tr>
                                                                        <?php endforeach; ?>
                                                                    </tbody>

                                                                </table>
                                                            </div>

                                                            <!-- 2. Cards View -->
                                                            <div class="row mb-4">
                                                                <?php foreach ($stock_data as $item): ?>
                                                                    <?php
                                                                        // Determine styling class based on quantity
                                                                        if ($item['quantity'] == 0) {
                                                                            $statusClass = 'bg-danger text-white';
                                                                        } elseif ($item['quantity'] <= $item['min_order_level']) {
                                                                            $statusClass = 'bg-warning text-dark';
                                                                        } else {
                                                                            $statusClass = ($item['type'] == 'branch') ? 'bg-primary text-white' : 'bg-success text-white';
                                                                        }
                                                                    ?>
                                                                    <div class="col-md-3 mb-3">
                                                                        <div class="card shadow-sm h-100">
                                                                            <div class="card-body <?= $statusClass ?> rounded">
                                                                                <h5 class="card-title">
                                                                                    <i class="fa <?= $item['type'] == 'branch' ? 'fa-building' : 'fa-warehouse' ?>"></i>
                                                                                    <?= htmlspecialchars($item['name']) ?>
                                                                                </h5>
                                                                                <p class="card-text mb-1">
                                                                                    <strong>Product:</strong> <?= htmlspecialchars($item['product_name']) ?>
                                                                                </p>
                                                                                <p class="card-text mb-1">
                                                                                    <strong>Quantity:</strong> 
                                                                                    <?= $item['quantity'] ?>
                                                                                </p>
                                                                                <p class="card-text mb-1">Type: <?= ucfirst($item['type']) ?></p>
                                                                                <p class="card-text mb-0">Min Stock Level: <?= $item['min_order_level'] ?? 'N/A' ?></p>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                <?php endforeach; ?>
                                                            </div>



                                                            <!-- 3. Chart View -->
                                                            <canvas id="stockChart" height="80" class="mb-4"></canvas>
                                                            

                                                        <?php else: ?>
                                                            <div class="alert alert-warning text-center">
                                                                <i class="fa fa-info-circle"></i> No stock records to show.
                                                            </div>
                                                        <?php endif; ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>

            <?php
                include_once 'libraries.php';
            ?>
            <script>
                const ctx = document.getElementById('stockChart').getContext('2d');
                const stockChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: <?= json_encode(array_column($stock_data, 'name')) ?>,
                        datasets: [{
                            label: 'Product Quantity',
                            data: <?= json_encode(array_column($stock_data, 'quantity')) ?>,
                            backgroundColor: <?= json_encode(array_map(fn($item) => $item['type'] == 'branch' ? 'rgba(54, 162, 235, 0.7)' : 'rgba(75, 192, 192, 0.7)', $stock_data)) ?>,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        scales: { y: { beginAtZero: true } }
                    }
                });
            </script>
        </body>
        
    </html>
