<?php
	session_start();
	include 'model/users_model.php';
	include_once 'model/common_model.php';
	include_once 'model/employees_model.php';
	
?>
<html>
	<head>
		<title>Users</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 20px;
				color: #069;
				text-transform:uppercase;
			}
			 /* Set font size and width for Select2 */
			.select2 {
				font-size: 18px;   /* Adjust font size */
				height: 40px; 
				}     /* Optional: height */
			.select2 {
				display: block;
				width: 100%;
				height: calc(1.5em + .75rem + 2px);
				font-size: 1rem;
				font-weight: 400;
				background-color: #fff;
				background-clip: padding-box;
				border-radius: .25rem;
				transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;

			}

			.select2{
				width: 320px !important;  /* Adjust width */
			}
			/* Align selected option text and set font color */
			.select2-selection__rendered {
				text-align: left !important;
				color: #495057 !important;
			}

			/* Align dropdown items text and set font color */
			.select2-results__option {
				text-align: left !important;
				color: #495057 !important;
			}
		</style>
	</head>
	<body>
		<?php
			$users_model = new users_model();
			$common_model =new common_model();
			$employees_model = new employees_model();

            $employee_code = $_GET['employee_code'];
            $username = $_GET['username'];
            $userDetails = $users_model->getuserDetails($username);

			$roleDetails = $employees_model->getRoleDetails($employee_code);
			$locations = $common_model->getAllLocations();
            

		?>
		
		<form action="controllers/users_controller.php" method="post">
			<center>
				<h2 class="page_titles">CHANGE LOCATION FOR <br><?php echo $userDetails['fullname'] ?> <i class="fa fa-mug-hot"></i></h2>
				<hr>

				<span style="float:left;margin-left:20px;font-size:16px;">Fullname</span>
				<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="employee_name" name="employee_name" value="<?php echo $userDetails['fullname']?>" class="form-control" readonly>
                <input type="hidden" name="action" value="change_location" readonly>
                <input type="hidden" name="employee_code" value="<?= $userDetails['employee_code']?>" readonly>
                <br>
					
				<span style="float:left;margin-left:20px;font-size:16px;">Assigned Role(s)</span>
				<?php if (!empty($roleDetails['roles'])): ?>
					<?php foreach($roleDetails['roles'] as $role): ?>
						<input type="text" style="width: 320px; height:40px;" autocomplete="off" class="form-control" value="<?= htmlspecialchars($role) ?>" readonly>
					<?php endforeach; ?>
				<?php else: ?>
					<input type="text" style="width: 320px; height:40px;" class="form-control text-muted" value="No role assigned" readonly>
					<br>
				<?php endif; ?>

				<span style="float:left;margin-left:20px;font-size:16px;">Current Location</span>
				<input type="text" style="width: 320px; height:40px;" autocomplete="off" class="form-control" value="<?= htmlspecialchars($roleDetails['location'] ?? 'N/A') ?>" readonly>
				<input type="hidden" name="current_location" value="<?= $roleDetails['location_id']?>">
				<br>
				
				<span style="float:left;margin-left:20px;font-size:16px;">Select New Location</span>
                <select name="new_location" style="width: 320px; height:40px;" class="form-control" required>
					<option value="<?= $roleDetails['location_id']?>" selected><?= $roleDetails['location'] ?></option>
					<?php
						foreach($locations as $loca):
							if($roleDetails['location_id']!==$loca['loc_id']):
					?>
						<option value="<?php echo $loca['loc_id']?>"><?= $loca['location_name']?></option>
					<?php
							endif;
						endforeach;
					?>
				</select>
				<br>

				
				<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:322px;font-size: 18px;">UPDATE LOCATION <i class="fa fa-save"></i></button>
			</center>
		</form>
	</body>
</html>