<?php
    header('Content-Type: application/json');
    session_start();

    include_once 'model/customers_model.php';

    $customers_model = new customers_model();

    $phone_number = isset($_POST['phone_number']) ? trim($_POST['phone_number']) : '';

    $response = ['exists' => false];

    if (!empty($phone_number)) {
        // Remove non-digit characters and any leading zero
        $cleaned = preg_replace('/\D/', '', $phone_number);
        if (substr($cleaned, 0, 1) === '0') {
            $cleaned = substr($cleaned, 1);
        }

        // Prepend +265
        $formatted = '+265' . $cleaned;

        // Check in DB
        $exists = $customers_model->checkphoneExists($formatted);
        $response['exists'] = $exists;
    }

    echo json_encode($response);
