<?php
    session_start();
    include_once '../model/company_model.php';
    $company_model = new company_model();
    date_default_timezone_set('Africa/Blantyre');

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {

        $post_action = $_POST['action'];

        switch ($post_action) {
            case 'update_company_details':
                updateCompanyDetails($company_model);
            break;
            
            case 'add_new_third_party_company':
                addnewThirdPartyCompany($company_model);
            break;
            
            case 'update_third_party_company_details':
                updateThirdPartyCompanyDetails($company_model);
            break;
            
            case 'add_supplier':
                addNewSupplier($company_model);
            break;

            case 'update_supplier':
                updateSupplier($company_model);
            break;

            case 'toggle_supplier':
                toggleSupplier($company_model);
            break;

            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Unknown Action',
                    'message' => 'The requested action is not recognized.'
                ];
                header('Location: ../company_details.php');
                exit();
        }
    }else{
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Unknown Action',
            'message' => 'The requested action is not recognized.'
        ];
        header('Location: ../company_details.php');
        exit();
    }

    function toggleSupplier($company_model) {
        $id = $_POST['supplier_id'];
        $current_state = $_POST['supplier_state'];

        // Determine the new state
        $new_state = ($current_state == 1) ? 0 : 1;

        // Call the model to update the supplier state
        $success = $company_model->updateSupplierState($id, $new_state);

        // Handle success or failure
        if ($success) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'SUCCESS',
                'message' => 'Supplier state successfully updated.'
            ];
            header("Location: ../suppliers.php");
            exit();
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED',
                'message' => 'Failed to update supplier state. Please try again.'
            ];
            header("Location: ../suppliers.php");
            exit();
        } 
    }

    function updateSupplier($company_model) {
        $id = $_POST['supplier_id'];
        $supplier_name = trim($_POST['supplier_name']);
        $contact_person = trim($_POST['contact_person']);
        $phone_number = trim($_POST['phone']);
        $email = trim($_POST['email']);

        // Prepare data for update
        $data = [
            'supplier_name' => $supplier_name,
            'contact_person' => $contact_person,
            'phone_number' => $phone_number,
            'email' => $email
        ];

        // Call the model to update the supplier
        $success = $company_model->updateSupplier($id, $data);

        // Handle success or failure
        if ($success) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'SUCCESS',
                'message' => 'Supplier details successfully updated.'
            ];
            header("Location: ../suppliers.php");
            exit();
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED',
                'message' => 'Failed to update supplier details. Please try again.'
            ];
            header("Location: ../suppliers.php");
            exit();
        } 
    }

    function addNewSupplier($company_model) {
        $supplier_name = trim($_POST['supplier_name']);
        $contact_person = trim($_POST['contact_person']);
        $phone_number = trim($_POST['phone']);
        $email = trim($_POST['email']);

        // Prepare data for insertion
        $data = [
            'supplier_name' => $supplier_name,
            'contact_person' => $contact_person,
            'phone_number' => $phone_number,
            'email' => $email,
            'datecreated' => date('Y-m-d H:i:s'),
            'operator' => $_SESSION['sess_employeecode'],
            'state' => 1
        ];

        // Call the model to insert the new supplier
        $success = $company_model->addNewSupplier($data);

        // Handle success or failure
        if ($success) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'SUCCESS',
                'message' => 'New supplier successfully added.'
            ];
            header("Location: ../suppliers.php");
            exit();
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED',
                'message' => 'Failed to add new supplier. Please try again.'
            ];
            header("Location: ../suppliers.php");
            exit();
        } 
    }

    function updateThirdPartyCompanyDetails($company_model) {
        // Get the POST data
        $company_id = $_POST['company_id'];
        $company_name = $_POST['company_name'];
        $contact_person = $_POST['contact_person'];
        $phone_number = $_POST['phone_number'];
        $email_address = $_POST['email_address'];
        $location_id = $_POST['location'];  // The selected location ID
        $company_state = $_POST['company_state'];  // 1 for enabled, 0 for disabled

        // Validate the data (check if required fields are not empty)
        if (empty($company_id) || empty($company_name) || empty($contact_person) || empty($phone_number) || empty($email_address) || empty($location_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Information',
                'message' => 'All fields are required to update the company details.'
            ];
            header('Location: ../third_party_companies.php');
            exit();
        }


        if ($company_model->isCompanyNameExists($company_name, $company_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Company Name',
                'message' => 'The company name already exists. Please choose a different name.'
            ];
            header('Location: ../third_party_companies.php');
            exit();
        }

        if ($company_model->isEmailExists($email_address, $company_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Email Address',
                'message' => 'The email address is already registered. Please use a different Company.'
            ];
            header('Location: ../third_party_companies.php');
            exit();
        }


        // Call the update method from your company model to update the company details in the database
        try {
            $result = $company_model->update_third_party_company_details(
                $company_id, 
                $company_name, 
                $contact_person, 
                $phone_number, 
                $email_address, 
                $location_id, 
                $company_state
            );

            if ($result) {
                // If update is successful
                $_SESSION['notification'] = [
                    'type' => 'success',
                    'title' => 'Company Details Updated',
                    'message' => 'The company details have been successfully updated.'
                ];
            } else {
                // If update fails
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Update Failed',
                    'message' => 'There was an error updating the company details.'
                ];
            }

            header('Location: ../view_third_company_details.php?id='.$company_id);
            exit();
            
        } catch (Exception $e) {
            // Catch any exception during the update
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Error',
                'message' => 'An error occurred while updating company details: ' . $e->getMessage()
            ];
            header('Location: ../company_details.php');
            exit();
        }
    }


    function addnewThirdPartyCompany($company_model) {
        // Sanitize inputs
        $company_name = trim($_POST['company_name']);
        $contact_person = trim($_POST['contact_person']);
        $phone_number = trim($_POST['phone_number']);
        $email = trim($_POST['email']);
        $location = trim($_POST['location']);
        $company_state = 1;

        // Check if Company Name or Email Already Exists
        $existingEmail = $company_model->checkEmail($email);
        if ($existingEmail) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Verification Error',
                'message' => 'This email address is already registered with a different company.'
            ];
            header("Location: ../third_party_companies.php");
            exit();
        }
        
        $existingName = $company_model->checkCompanyName($company_name);
        if ($existingName) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Verification Error',
                'message' => 'Company name already exists in the database.'
            ];
            header("Location: ../third_party_companies.php");
            exit();
        }

        // Generate a New Company ID (we assume the ID is auto-increment in the DB)
        $company_id = generateNewCompanyId();

        // Prepare data for insertion
        $data = [
            'company_id' => $company_id,
            'company_name' => $company_name,
            'contact_person' => $contact_person,
            'phone_number' => $phone_number,
            'email_address' => $email,
            'location' => $location,
            'datecreated' => date('Y-m-d H:i:s'),
            'operator' => $_SESSION['sess_employeecode'],
            'company_state' => $company_state
        ];

        // Call the model to insert the new company
        $success = $company_model->addNewCompany($data);

        // Handle success or failure
        if ($success) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'SUCCESS',
                'message' => 'New company successfully added.'
            ];
            header("Location: ../third_party_company_details.php?id=".$company_id);
            exit();
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED',
                'message' => 'Failed to add new company. Please try again.'
            ];
            header("Location: ../third_party_companies.php");
            exit();
        } 
    }
    
    function generateNewCompanyId() {
        global $company_model;
        return $company_model->getNextCompanyId();
    }

    function updateCompanyDetails($company_model){
        $id = $_POST['id'];

        // Sanitize inputs

        $mainPhone = trim($_POST['phone_number']);
        $altPhone  = trim($_POST['company_phone2']);

        if (!empty($mainPhone) && strpos($mainPhone, '+265') !== 0) {
            $mainPhone = '+265' . $mainPhone;
        }
        if (!empty($altPhone) && strpos($altPhone, '+265') !== 0) {
            $altPhone = '+265' . $altPhone;
        }

        $data = [
            'company_id' => trim($_POST['company_id']),
            'company_name' => trim($_POST['company_name']),
            'tpin' => trim($_POST['tpin']),
            'location' => trim($_POST['location']),
            'address' => trim($_POST['address']),
            'phone_number' => $mainPhone,
            'company_phone2' => $altPhone,
            'email' => trim($_POST['email']),
            'website' => trim($_POST['website']),
            'logo' => '',
            'directors_signature' => ''
        ];

        // Handle file upload: logo
        if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
            $logo_name = basename($_FILES['logo']['name']);
            $logo_tmp = $_FILES['logo']['tmp_name'];
            $logo_dest = "../images/" . $logo_name;
            if (move_uploaded_file($logo_tmp, $logo_dest)) {
                $data['logo'] = $logo_name;
            }
        }

        // Handle file upload: directors_signature
        if (isset($_FILES['directors_signature']) && $_FILES['directors_signature']['error'] === UPLOAD_ERR_OK) {
            $sig_name = basename($_FILES['directors_signature']['name']);
            $sig_tmp = $_FILES['directors_signature']['tmp_name'];
            $sig_dest = "../signatures/" . $sig_name;
            if (move_uploaded_file($sig_tmp, $sig_dest)) {
                $data['directors_signature'] = $sig_name;
            }
        }

        // Call model to update company
        $success = $company_model->updateCompanyDetails($id, $data);

        if ($success) {
            $_SESSION['notification']=[
                'type'=> 'success',
                'title'=> 'SUCCESS',
                'message' => 'Successfully updated company details'
            ];
            header("Location: ../company_details.php");
            exit();
        } else {
            $_SESSION['notification']=[
                'type'=> 'error',
                'title'=> 'FAILED',
                'message' => 'Failed to updated company details<br>Try Again'
            ];
            header("Location: ../company_details.php");
            exit();
        }   
    }



        
    
