<?php
    session_start();
    include_once '../model/users_model.php';
    include_once '../model/sales_model.php';
    include_once '../model/orders_model.php';

    $sales_model = new sales_model();
    $users_model = new users_model();
    $orders_model = new orders_model();

    // ✅ Handle POST request
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
        $action = $_POST['action'];
    
        switch($action){
            
            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FATAL ERROR!!',
                    'message' => 'Undefined action!!!'
                ];
                header('location:../dashboard.php');
                exit();
        }

    // ✅ Optionally handle GET actions (if needed in the future)
    } elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action'])) {
        $action = $_GET['action'];

        switch($action){
            case 'cancelcashsalepayment':
                cancelcashsalepayment($sales_model, $users_model);
            break;

            case 'cancelinvoicepayment':
                cancelinvoicepayment($sales_model, $users_model, $orders_model);
            break;


            case 'restorepayment':
                restorecancelledpayment($sales_model, $orders_model);
            break;

            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FATAL ERROR!!',
                    'message' => 'Undefined action!!!'
                ];
                header('location:../dashboard.php');
                exit();
        }

    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FATAL ERROR!!',
            'message' => 'UNRECOGNISED SERVER REQUEST!!!'
        ];
        header('location:../dashboard.php');
        exit(); 
    }
    

    //Main function to cancel invoice payment
    function cancelinvoicepayment($sales_model, $users_model, $orders_model) {
        $invoice_id = $_GET['invoice_id'] ?? null;
        $status = $_GET['status'] ?? null;
        $reason = trim($_GET['reason'] ?? '');
        $operator = $_SESSION['sess_employeecode'] ?? 0;
        $timestamp = date('Y-m-d H:i:s');
        $receipt_number = $_GET['receipt_number'] ?? null;

        // Step 0: Validate input
        if (empty($invoice_id) || !isset($status) || empty($reason) || empty($receipt_number)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Data',
                'message' => 'Missing relevant data for cancelling the payment.'
            ];
            header("Location: ../invoice_payments.php");
            exit();
        }

        $checkifcancelledPaymentExistsalready = $sales_model->checkcancelledpayment($receipt_number);

        if($checkifcancelledPaymentExistsalready){
            
            if (!$users_model->isValidUser($operator)) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Unauthorized',
                    'message' => 'Access denied. Invalid user.'
                ];
                header("Location: ../../index.php");
                exit();
            }

            $updateCancelledData = $sales_model->cancelcancelledRecord($receipt_number, 1, $reason);

            if(!$updateCancelledData){
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Cancel Failed',
                    'message' => 'Failed to cancel payment, Try again later.'
                ];
                header("Location: ../invoice_payments.php");
                exit();
            }

            $cancelledData = $sales_model->getPaymentDetails($invoice_id);

            $updateSuccess = $sales_model->updateSaleStatus($invoice_id, $status);
            
            if(!$updateSuccess){
                $sales_model->cancelcancelledRecord($receipt_number, 0);
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Cancel Failed',
                    'message' => 'Failed to cancel payment, Try again later.'
                ];
                header("Location: ../invoice_payments.php");
                exit();  
            }

            $transaction_type = $cancelledData['payment_type'];
            $invoiceNumber = $cancelledData['sale_id'];
                if($transaction_type == 'Customer Order'){
                    $invoiceDetails = $sales_model->getInvoiceDetails($invoiceNumber);
                    if (!$invoiceDetails) {
                    
                        $sales_model->cancelcancelledRecord($receipt_number, 0);
                        $sales_model->restoreSaleStatusAndTransaction($invoice_id, 1, $cancelledData['transction_id']);

                        $_SESSION['notification'] = [
                            'type' => 'error',
                            'title' => 'Order Not Found',
                            'message' => 'Order details not found. Action rolled back.'
                        ];
                        header("Location: ../invoice_payments.php");
                        exit();
                    }
                    $totalAmount = $invoiceDetails['total_bill'];
                    $total_paid = $orders_model->getTotalPaymentsForInvoice($invoiceNumber);
                    $remainingBalance = $totalAmount - $total_paid;

                    if ($remainingBalance == $totalAmount) {
                        $orderState = 0;
                    } elseif ($remainingBalance > 0) {
                        $orderState = 1;
                    } else {
                        $orderState = 2;
                    }

                $updateOrderSuccess = $orders_model->updateOrderState($invoiceNumber, $orderState);
                if (!$updateOrderSuccess) {
                    // Full rollback if order update fails
                    $sales_model->cancelcancelledRecord($receipt_number, 0);
                    $sales_model->restoreSaleStatusAndTransaction($invoice_id, 1, $cancelledData['transction_id']);

                    $_SESSION['notification'] = [
                        'type' => 'error',
                        'title' => 'FAILED!!!',
                        'message' => 'Failed to cancel payment.'
                    ];
                    header("Location: ../invoice_payments.php");
                    exit();
                }else{
                    $_SESSION['notification'] = [
                        'type' => 'success',
                        'title' => 'Success',
                        'message' => 'Invoice payment cancelled successfully.'
                    ];
                    header("Location: ../invoice_payment_receipt.php?receipt_number=".$cancelledData['receipt_number']);
                    exit();
                }
            }

        }else{
            // Step 1: Validate user
            if (!$users_model->isValidUser($operator)) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Unauthorized',
                    'message' => 'Access denied. Invalid user.'
                ];
                header("Location: ../../index.php");
                exit();
            }

            // Step 2: Get original payment details
            $payment = $sales_model->getPaymentDetails($invoice_id);
            if (!$payment) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Not Found',
                    'message' => 'Original payment record not found.'
                ];
                header("Location: ../invoice_payments.php");
                exit();
            }

            // Step 3: Prepare cancel data
            $cancelData = [
                'tx_id'            => $payment['tx_id'],
                'sale_id'          => $payment['sale_id'],
                'customer'         => $payment['customer'],
                'receipt_number'   => $payment['receipt_number'],
                'payment_method'   => $payment['payment_method'],
                'payment_type'     => $payment['payment_type'],
                'transction_id'    => $payment['transction_id'],
                'payment_date'     => $payment['payment_date'],
                'amount'           => $payment['amount_paid'],
                'datecaptured'     => $payment['datecaptured'],
                'reason'           => $reason,
                'date_cancelled'   => $timestamp,
                'cancelled_by'     => $operator,
                'operator'         => $payment['operator'],
                'cancel_state'     => 1
            ];

            $invoice_number = $payment['sale_id'];

            // Step 4: Log cancellation first
            $logSuccess = $sales_model->logCancelledPayment($cancelData);
            if (!$logSuccess) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Failed',
                    'message' => 'Could not process transaction. Action aborted.'
                ];
                header("Location: ../invoice_payments.php");
                exit();
            }

            // Step 5: Update payment status & transaction_id
            $updateSuccess = $sales_model->updateSaleStatus($invoice_id, $status); // this will also update transction_id to invoice_id
            if (!$updateSuccess) {
                // Rollback: delete from cancelled_payments
                $sales_model->deleteCancelledPayment($payment['receipt_number']);

                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Update Failed',
                    'message' => 'Payment status update failed. Action was reversed.'
                ];
                header("Location: ../invoice_payments.php");
                exit();
            }

            // Step 6: Update order state based on remaining balance
            $invoiceDetails = $sales_model->getInvoiceDetails($invoice_number);
            if (!$invoiceDetails) {
                // Rollback everything if order details not found
                $sales_model->deleteCancelledPayment($payment['receipt_number']);
                $sales_model->restoreSaleStatusAndTransaction($invoice_id, 1, $payment['transction_id']);

                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Order Not Found',
                    'message' => 'Order details not found. Action rolled back.'
                ];
                header("Location: ../invoice_payments.php");
                exit();
            }
            $totalAmount = $invoiceDetails['total_bill'];
            $total_paid = $orders_model->getTotalPaymentsForInvoice($invoice_number);
            $remainingBalance = $totalAmount - $total_paid;

            if ($remainingBalance == $totalAmount) {
                $orderState = 0;
            } elseif ($remainingBalance > 0) {
                $orderState = 1;
            } else {
                $orderState = 2;
            }

            $updateOrderSuccess = $orders_model->updateOrderState($invoice_number, $orderState);
            if (!$updateOrderSuccess) {
                // Full rollback if order update fails
                $sales_model->deleteCancelledPayment($payment['receipt_number']);
                $sales_model->restoreSaleStatusAndTransaction($invoice_id, 1, $payment['transction_id']); // revert

                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Failed to Update Order',
                    'message' => 'Failed to cancel payment.'
                ];
                header("Location: ../invoice_payments.php");
                exit();
            }else{
                $_SESSION['notification'] = [
                    'type' => 'success',
                    'title' => 'Success',
                    'message' => 'Invoice payment cancelled successfully.'
                ];
                header("Location: ../invoice_payment_receipt.php?receipt_number=".$payment['receipt_number']);
                exit();
            }
        }

        

    }

    // ✅ Function to cancel cash sale payment
    function cancelcashsalepayment($sales_model, $users_model) {
        $sale_id = $_GET['sale_id'] ?? null;
        $status = $_GET['status'] ?? null;
        $reason = $_GET['reason'] ?? null;
        $operator = $_SESSION['sess_employeecode'] ?? 0;
        $timestamp = date('Y-m-d H:i:s');
        $receipt_number = $_GET['receipt_number'] ?? null;

        if (empty($reason)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Reason',
                'message' => 'Cancellation reason is required.'
            ];
            header('location:../cash_sales.php');
            exit();
        }


        if (empty($operator) || !$users_model->isValidUser($operator)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Unauthorized',
                'message' => 'Access denied. Invalid user session.'
            ];
            header('location:../../index.php');
            exit();
        }

        if (empty($sale_id) || ($status !== '0' && $status !== '1')) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Invalid Input',
                'message' => 'Invalid or missing sale ID or status.'
            ];
            header('location:../cash_sales.php');
            exit();
        }

        $payment = $sales_model->getPaymentDetails($sale_id);
        if (!$payment) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Not Found',
                'message' => 'Original payment record not found.'
            ];
            header('location:../cash_sales.php');
            exit();
        }

        // Don't cancel an already cancelled payment
        if ($payment['payment_state'] == 0) {
            $_SESSION['notification'] = [
                'type' => 'info',
                'title' => 'Already Cancelled',
                'message' => 'This payment has already been cancelled.'
            ];
            header('location:../cash_sales.php');
            exit();
        }

        // Build cancelData once
        $cancelData = [
            'tx_id'            => $payment['tx_id'],
            'sale_id'          => $payment['sale_id'],
            'customer'         => $payment['customer'],
            'receipt_number'   => $payment['receipt_number'],
            'payment_method'   => $payment['payment_method'],
            'payment_type'     => $payment['payment_type'],
            'transction_id'    => $payment['transction_id'],
            'payment_date'     => $payment['payment_date'],
            'amount'           => $payment['amount_paid'],
            'datecaptured'     => $payment['datecaptured'],
            'reason'           => $reason,
            'date_cancelled'   => $timestamp,
            'cancelled_by'     => $operator,
            'operator'         => $payment['operator'],
            'cancel_state'     => 1
        ];

        $cancelExists = $sales_model->checkCancelledPayment($receipt_number);
        $logSuccess = false;

        if ($cancelExists) {
            // Update cancel_state back to 1
            $logSuccess = $sales_model->cancelcancelledRecord($receipt_number, 1, $reason);
        } else {
            // Fresh cancellation log
            $logSuccess = $sales_model->logCancelledPayment($cancelData);
        }

        if (!$logSuccess) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Failed',
                'message' => 'Could not cancel payment. Please try again.'
            ];
            header('location:../cash_sales.php');
            exit();
        }

        // Final step: update sales status
        $success = $sales_model->updateSaleStatus($sale_id, $status);
        if (!$success) {
            // Rollback if status update fails
            $sales_model->cancelcancelledRecord($receipt_number, 0, $reason);

            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Database Error',
                'message' => 'Failed to cancel payment. Changes rolled back.'
            ];
            header('location:../cash_sales.php');
            exit();
        }

        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'SUCCESS',
            'message' => 'Successfully cancelled payment.'
        ];
        header('location:../cash_sale_receipt.php?id=' . $payment['tx_id']);
        exit();
    }


    function restorecancelledpayment($sales_model, $orders_model) {
        $receipt_number = $_GET['receipt_number'] ?? null;
        $payment_state = $_GET['status'] ?? null;

        if (empty($receipt_number) || $payment_state === null) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Data',
                'message' => 'Missing payment details, reload the page.'
            ];
            header("Location: ../cancelled_payments.php");
            exit();
        }

        // Step 1: Get original + cancelled details
        $currentData = $sales_model->getCurrentDetailsBeforeupdate($receipt_number);
        $cancelData = $sales_model->getCancelledPaymentData($receipt_number);
        
        if (!$cancelData) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Not Found',
                'message' => 'Cancellation record not found.'
            ];
            header("Location: ../cancelled_paymentss.php");
            exit();
        }

        // Step 2: Attempt to reverse payment
        $restoreSuccess = $sales_model->reverseCancelledPayment($receipt_number, $cancelData['transction_id'], $payment_state);

        if (!$restoreSuccess) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Restore Failed',
                'message' => 'Failed to restore payment.'
            ];
            header("Location: ../invoice_payments.php");
            exit();
        }

        // Step 3: Deactivate cancellation record
        $removecancelledstate = $sales_model->cancelcancelledRecord($receipt_number, 0, $cancelData['reason']);

        if (!$removecancelledstate) {
            // Rollback the reversal to avoid inconsistency
            $sales_model->reverseCancelledPayment($receipt_number, $currentData['transction_id'], 0);

            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Restore Failed',
                'message' => 'Failed to restore payment. Reversed changes.'
            ];
            header("Location: ../invoice_payments.php");
            exit();
        }

        // Step 4: Restore order state and balance — only for Customer Orders
        if (strtolower($cancelData['payment_type']) === 'customer order') {
            $total_bill = $orders_model->getInvoiceTotal($cancelData['sale_id']);
            $total_paid = $orders_model->getTotalPaymentsForInvoice($cancelData['sale_id']);
            $balance = $total_bill - $total_paid;

            if ($total_paid >= $total_bill) {
                $order_state = 2; // fully paid
            } elseif ($total_paid > 0) {
                $order_state = 1; // partially paid
            } else {
                $order_state = 0; // unpaid
            }

            // Apply updates
            $orders_model->updateOrderStatewithBalance($cancelData['sale_id'], $order_state, $balance);
            $sales_model->updateInvoiceBalance($cancelData['sale_id'], $balance);

            // Final success redirect
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Success',
                'message' => 'Payment successfully restored.'
            ];
            header("Location: ../invoice_payment_receipt.php?receipt_number=$receipt_number");
            exit(); 
        }else{
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Success',
                'message' => 'Payment successfully restored.'
            ];
            header("Location: ../cash_sale_receipt.php?id=" . $currentData['tx_id']);
            exit(); 
        }

    }

