<?php
    date_default_timezone_set('Africa/Blantyre'); // Set your preferred timezone

    session_start();
    include_once '../model/transfers_model.php';
    include_once '../model/stock_model.php';

    $stock_model = new stock_model();
    $transfers_model = new transfers_model();

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['receive_stock']) && $_POST['receive_stock'] === 'receive_stock') {
            $order_number = $_POST['order_number'] ?? '';
            $product_code = $_POST['product_code'] ?? '';
            $quantity = $_POST['quantity'] ?? 0;
            $remaining = $_POST['remaining'] ?? 0;
            $operator = $_SESSION['sess_employeecode'] ?? '';
            $transaction_date = $_POST['transaction_date'];
            $datecaptured = date('Y-m-d H:i:s');
    
            // Parse location_from
            $raw_location_from = $_POST['location_from'] ?? '';
            $location_from_type = strtoupper(substr($raw_location_from, 0, 1)); // 'W' or 'B'
            $location_from_id = substr($raw_location_from, 2);
    
            // Parse final_destination
            $raw_final_destination = $_POST['final_destination'] ?? '';
            $final_destination_type = strtoupper(substr($raw_final_destination, 0, 1)); // 'W' or 'B'
            $final_destination_id = substr($raw_final_destination, 2);
    
            $movement_out = 'out';
            $movement_in = 'in';
            $closing_stock_out = $remaining - $quantity;
            $movement_state = 1; //pending Transfer
    
            // Get final destination stock details
            $remaining_income = $stock_model->getLocationStockDetails($final_destination_id, $final_destination_type, $product_code);
            $closing_stock_in = $remaining_income + $quantity;
    
            if (empty($order_number) || empty($location_from_id) || empty($product_code) || empty($final_destination_id)) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED',
                    'message' => 'Missing required fields'
                ];
                header("Location: ../receive_stock.php?order_number={$order_number}");
                exit();
            }
    
            // ✅ Product existence check at destination
            if (!$transfers_model->productExistsInLocation($product_code, $final_destination_id, $final_destination_type)) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED',
                    'message' => 'The Selected product is not attached to The final destination'
                ];
                header("Location: ../receive_stock.php?order_number={$order_number}");
                exit(); 
            }
    
            if ($quantity > $remaining) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED',
                    'message' => 'Quantity Entered cannot be greater than Stock remaining'
                ];
                header("Location: ../receive_stock.php?order_number={$order_number}");
                exit(); 
            }
    
            // Process stock transfer
            $process_result = $transfers_model->process_stock_transfer(
                $order_number, $product_code, $location_from_id, $final_destination_id, $movement_out, $movement_in,
                $remaining, $quantity, $closing_stock_out, $remaining_income, $closing_stock_in,
                $transaction_date, $datecaptured, $operator, $movement_state, $location_from_type, $final_destination_type
            );
    
            if (!$process_result) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED',
                    'message' => 'Failed To Process Transaction, Try Again'
                ];
            } else {
                $_SESSION['notification'] = [
                    'type' => 'info',
                    'title' => 'SUCCESS',
                    'message' => 'Successfully Captured Order Item'
                ];
            }
    
            header("Location: ../receive_stock.php?order_number={$order_number}");
            exit();
        }
    }
    
?>
