<?php
session_start();
include_once '../model/warehouse_model.php';
include_once '../model/employees_model.php';

$employees_model = new employees_model();
$warehouse_model = new warehouse_model();

// Check if form was submitted and action is set
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['edit_warehouse']) && $_POST['edit_warehouse'] === 'edit_warehouse') {
        editWarehouse($warehouse_model, $employees_model);
    }

}

function editWarehouse($warehouse_model, $employees_model) {
    $warehouse_id   = $_POST['warehouse_id'] ?? null;
    $warehouse_name = trim(htmlspecialchars($_POST['warehouse_name'] ?? ''));
    $supervisor     = $_POST['supervisor'] ?? null;
    $location       = $_POST['location'] ?? null;

    if ($warehouse_id && $warehouse_name && $supervisor && $location) {

        // Check location uniqueness excluding current warehouse
        if ($warehouse_model->doesLocationExistExcludingWarehouse($location, $warehouse_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Location',
                'message' => 'We already Have a warehouse in the selected location.'
            ];
            header('Location: ../manage_warehouses.php');
            exit();
        }

        // Check supervisor uniqueness excluding current warehouse
        if ($warehouse_model->isSupervisorInAnotherWarehouseExcludingCurrent($supervisor, $warehouse_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Supervisor',
                'message' => 'This supervisor is already assigned to a different warehouse.'
            ];
            header('Location: ../manage_warehouses.php');
            exit();
        }

        if (!$employees_model->isActiveEmployee($supervisor)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Inactive Employee',
                'message' => 'Selected supervisor is not an active employee.'
            ];
            header('Location: ../manage_branches.php');
            exit();
        }


        $branchData = $warehouse_model->getBranchByShopManager($supervisor);

        if ($branchData) {
            $branchLocation = $branchData['location'];
            $branchState = $branchData['branch_state'];

            // If branch is active but location differs, block the update
            if ($branchState == 1 && $branchLocation !== $location) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Supervisor Conflict',
                    'message' => 'This employee is already a Branch Manager in a different location. A supervisor/shop manager must belong to the same location.'
                ];
                header('Location: ../manage_warehouses.php');
                exit();
            }
        }

        if ($warehouse_model->doesWarehouseNameExistExcludingCurrent($warehouse_name, $warehouse_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Warehouse Name',
                'message' => 'This warehouse name is already in use. Please choose a different name.'
            ];
            header('Location: ../manage_warehouses.php');
            exit();
        }



        // Update warehouse
        $success = $warehouse_model->updateWarehouse($warehouse_id, $warehouse_name, $supervisor, $location);

        $_SESSION['notification'] = $success
            ? ['type' => 'success', 'title' => 'Success', 'message' => 'Warehouse details updated successfully.']
            : ['type' => 'error', 'title' => 'Failed', 'message' => 'Failed to update warehouse details.'];

    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Invalid Input',
            'message' => 'Please fill in all required fields.'
        ];
    }


    header('Location: ../manage_warehouses.php');
    exit();
}

