<?php 

    include_once 'model/customers_model.php';

    $customer_id = isset($_GET['customer_id']) ? $_GET['customer_id'] : '';

    $customers_model = new customers_model();

    $financialData = $customers_model->getFinancialData($customer_id);
    
    $months = $financialData['months']; 
    $loaded = $financialData['loaded'];
    $spent = $financialData['spent'];

    $purchasedItems = $customers_model->getMostPurchasedItems($customer_id);

    $itemNames = [];
    $purchaseCounts = [];
    
    foreach ($purchasedItems as $item) {
        $itemNames[] = $item['item_name'];
        $purchaseCounts[] = $item['purchase_count'];
    }
    $customerDetails = $customers_model->getCustomerDetails($customer_id);
    $customer_state =$customerDetails['customer_state'];
    $customer_name = $customerDetails['customer_name'];
    $phone = $customerDetails['phone_number'];
    $email = $customerDetails['email'];
    $gender = $customerDetails['gender'];
    $cust_address = $customerDetails['cust_address'];
    $customer_status = $customerDetails['customer_status'];
    $location = $customerDetails['location_name'];
    $date_created = $customerDetails['datecreated'];
    $openedby = $customerDetails['operator'];
    $country = $customerDetails['country_name'];
    $nationality = $customerDetails['nationality'];

    $lastdate = $customers_model->getLastTransactionDate($customer_id);
    $transactions = $customers_model->getCustomerTransactions($customer_id);
    



?>

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body>
            <?php include('menu_cashier.php'); ?>
            <div class="content-wrapper">
                <section class="content">
                    <form><INPUT class="btn btn-info" style="float:right;margin-right:5px" Type="button" VALUE="Back" class="btn    btn-primary btn-sm btn-flat" onClick="history.go(-1);return true;">
                    </form>
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-6">
                                <h4>Financial Transactions</h4>
                                <canvas id="financialChart" width="350" height="160"></canvas>
                            </div>

                            <div class="col-md-6">
                                <h4>Most Purchased Items</h4>
                                <canvas id="mostSold" width="350" height="160"></canvas>
                            </div>
                        </div>

                        
                        
                        <div class="row">
                            <div class="col-md-6" style="font-family: Times;">
                                <h2>Customer Details</h2>
                            </div>
                            <div class="col-md-6 text-right">
                                
                                

                                    <a rel="facebox" title="Edit Customer Details" href="edit_customer.php?cust_id=<?php echo $customer_id?>">
                                        <button class="btn btn-warning">Edit Data <i class="fa fa-edit"></i></button>
                                    </a>
                                

                                    
                                                              
                            </div>
                            
                            
                            
                                
                            
                        </div>
                    </div>
                </section>
            </div>
            <script src="plugins/jquery/jquery.min.js"></script>
            <script src="plugins/jquery-ui/jquery-ui.min.js"></script>
            <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="dist/js/adminlte.js"></script> 
            <script src="plugins/jquery/jquery.min.js"></script>
            <script src="plugins/chart.js/Chart.min.js"></script>
            <script src="js/script.js"></script>

            <script>
    $(document).ready(function() {
        // Data for Most Purchased Items
        var itemNames = <?php echo json_encode($itemNames); ?>;
        var purchaseCounts = <?php echo json_encode($purchaseCounts); ?>;

        function getRandomColor() {
            var letters = '0123456789ABCDEF';
            var color = '#';
            for (var i = 0; i < 6; i++) {
                color += letters[Math.floor(Math.random() * 16)];
            }
            return color;
        }
        var backgroundColors = [];
        var borderColors = [];

        for (var i = 0; i < itemNames.length; i++) {
            var randomColor = getRandomColor();
            backgroundColors.push(randomColor + '33'); // Add transparency to the background color
            borderColors.push(randomColor); // Solid color for the border
        }

        // Bar Chart for Most Purchased Items
        var ctxItems = document.getElementById('mostSold').getContext('2d');
        var itemsChart = new Chart(ctxItems, {
            type: 'bar',
            data: {
                labels: itemNames, // Item names as labels
                datasets: [{
                    label: 'Most Purchased Items',
                    data: purchaseCounts, // Number of purchases for each item
                    backgroundColor: backgroundColors,
                    borderColor: borderColors,
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true // Ensures the Y-axis starts at zero
                        }
                    }],
                    xAxes: [{
                        ticks: {
                            autoSkip: false // Ensures all labels are shown (optional)
                        }
                    }]
                }
            }
        });
    });
</script>


            <script>
                $(document).ready(function() {
                    // Data from PHP
                    var months = <?php echo json_encode($months); ?>;
                    var loadedData = <?php echo json_encode($loaded); ?>;
                    var spentData = <?php echo json_encode($spent); ?>;

                    // Financial Chart
                    var ctxFinancial = document.getElementById('financialChart').getContext('2d');
                    var financialChart = new Chart(ctxFinancial, {
                        type: 'bar',
                        data: {
                            labels: months, // Use months as the labels
                            datasets: [
                                {
                                    label: 'Total Loaded',
                                    data: loadedData, // Data for total loaded
                                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                                    borderColor: 'rgba(54, 162, 235, 1)',
                                    borderWidth: 1
                                },
                                {
                                    label: 'Total Spent',
                                    data: spentData, // Data for total spent
                                    backgroundColor: 'rgba(255, 99, 132, 0.2)',
                                    borderColor: 'rgba(255, 99, 132, 1)',
                                    borderWidth: 1
                                }
                            ]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                x: {
                                    beginAtZero: true,
                                    title: {
                                        display: true,
                                        text: 'Month'
                                    }
                                },
                                y: {
                                    beginAtZero: true,
                                    title: {
                                        display: true,
                                        text: 'Amount'
                                    }
                                }
                            }
                        }
                    });
                });
            </script>

            <script type="text/javascript">
                $(document).ready(function() {
                    <?php if (isset($_SESSION['notification'])) { ?>
                        var toastrType = "<?php echo $_SESSION['notification']['type']; ?>";
                        var toastrTitle = "<?php echo $_SESSION['notification']['title']; ?>";
                        var toastrMessage = "<?php echo $_SESSION['notification']['message']; ?>";
                            
                        toastr[toastrType](toastrMessage, toastrTitle);

                        <?php unset($_SESSION['notification']); ?>
                    <?php } ?>
                });
            </script>   
        </body>
    </html>
