<?php

include_once 'model/employees_model.php';

$employeeCode = $_GET['employee_code'] ?? '';

// If employee code is provided
if ($employeeCode) {
    // Initialize the model
    $employees_model = new employees_model();

    // Fetch employee details (for example, postname)
    $employeeDetails = $employees_model->getEmployeeDetails($employeeCode);
    $leaveDetails = $employees_model->getleaveSummaryData($employeeCode);

    // If the employee and leave details are found
    if ($employeeDetails && $leaveDetails) {
        // Return the employee and leave details as JSON
        echo json_encode([
            'success' => true,
            'employee' => $employeeDetails,
            'leaveDetails' => $leaveDetails
        ]);
    } else {
        // If no data found, return an error message
        echo json_encode([
            'success' => false,
            'message' => 'No employee or leave details found.'
        ]);
    }
} else {
    // If no employee code is provided, return an error message
    echo json_encode([
        'success' => false,
        'message' => 'Employee code is required.'
    ]);
}
?>
