<?php
include_once 'model/transfers_model.php';
$transfers_model = new transfers_model();

$transfer_id = $_POST['transfer_id'] ?? '';

if (!empty($transfer_id)) {
    $items = $transfers_model->getTransferItems($transfer_id);

    if ($items) {
        ob_start(); // Buffer output
        ?>
        <table class="table table-bordered table-striped">
            <thead class="bg-info text-white">
                <tr>
                    <th>Transfer Date</th>
                    <th>Product Name</th>
                    <th style="text-align:center;">Transfer From</th>
                    <th>Transfer To</th>
                    <th>Quantity</th>

                </tr>
            </thead>
            <tbody>
                <?php foreach ($items as $item): 
                    ?>
                    <tr>
                        <td><?= date('d M Y',strtotime(htmlspecialchars($item['transfer_date']))) ?></td>
                        <td style="text-align:left;"><?= $item['product_name'] ?></td>
                        <td><?= $item['company_name'] ?></td>
                        <td><?= $item['destination']?></td>
                        <td style="text-align:center;"><?= number_format($item['quantity'],0) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
            
        </table>
        <?php
        echo ob_get_clean();
    } else {
        echo "<p class='text-muted text-center mt-3'>No items found for this transaction.</p>";
    }
} else {
    echo "<div class='alert alert-warning text-center mt-3'>Invalid Transfer ID.</div>";
}
