<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.png" type="image/ico" />
    <title>Powertex LTD - Employee Leave Data</title>
    <?php include_once 'css_links.php'; ?>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <?php 
                include 'menu_finance.php'; 
                include_once 'model/employees_model.php';  

                $employee_code = $_GET['employee_code'] ?? null;

                $employees_model = new employees_model();
                $employeeDetails = $employees_model->getEmployeeDetails($employee_code);
                $leave_data = $employees_model->getLeaveData();
            ?>

            <!-- page content -->
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title">
                        <div class="title_left">
                            <h3><small>Employee Leave Records</small></h3>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <div class="x_panel">
                                <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                    <!-- Left side: Title -->
                                    <div>
                                        <h2 class="mb-0">Employee Leave Details </h2>
                                    </div>

                                    <!-- Center: Title -->
                                    <div class="text-center flex-grow-1">
                                        <h5 class="mb-0">Annual Leave Breakdown for <?php echo $employeeDetails['fullname']?></h5>
                                    </div>

                                    <!-- Right side: Back Button -->
                                    <ul class="nav navbar-right panel_toolbox mb-0">
                                        <li>
                                            <button class="btn btn-secondary btn-sm" style="float: right;" onclick="history.back();">
                                                <i class="fa fa-arrow-left"></i> Back
                                            </button>

                                            <button class="btn btn-info btn-sm" style="float: right;">
                                                 <a rel="facebox" style="color: #fff;" href="new_leave_special.php?employee=<?php echo $employee_code ?>"> Apply For Leave <i class="fa fa-receipt"></i></a>
                                            </button> 
                                            
                                        </li>
                                    </ul>
                                </div>
                                <div class="clearfix"></div>

                                <div class="x_content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card-box table-responsive">                                                
                                                <?php   
                                                    if ($employee_code) {
                                                        $leave_data = $employees_model->getLeaveDetails($employee_code);
                                                    }
                                                    ?>

                                                    <?php if (!empty($leave_data)): ?>
                                                        <table class="table table-striped table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>Leave Type</th>
                                                                    <th>Date Requested</th>
                                                                    <th>Requested Start Date</th>
                                                                    <th>Requsted End Date</th>
                                                                    <th>Requested Number of Days</th>
                                                                    <th>Requested By</th>
                                                                    <th>Status</th>
                                                                    <th>Action</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach ($leave_data as $leave): ?>
                                                                    <tr>
                                                                        <td><?= htmlspecialchars($leave['leave_type']) ?></td>
                                                                        <td><?= date('d M Y H:i', strtotime($leave['datecaptured'])) ?></td>
                                                                        <td><?= date('d M Y', strtotime($leave['start_date'])) ?></td>
                                                                        <td><?= date('d M Y', strtotime($leave['end_date'])) ?></td>
                                                                        <td><?= htmlspecialchars($leave['total_days']) ?></td>
                                                                        <td><?= htmlspecialchars($leave['operator']) ?></td>
                                                                        <?php
                                                                            $status_class = '';
                                                                            switch ($leave['leaave_state']) {
                                                                                case '0':
                                                                                    $status_class = 'bg-warning';
                                                                                    break;
                                                                                case '1':
                                                                                    $status_class = 'bg-success';
                                                                                    break;
                                                                                case '3':
                                                                                    $status_class = 'bg-danger';
                                                                                    break;
                                                                                default:
                                                                                    $status_class = 'bg-primary';
                                                                                    break;
                                                                            }
                                                                        ?>
                                                                        <td class="<?= $status_class ?>" style="color: white;">
                                                                            <?= ucfirst($leave['leave_status']) ?>
                                                                        </td>

                                                                        <td>
                                                                            <a href="leave_slip.php?id=<?php echo $leave['id']?>">
                                                                                <button class="btn btn-info btn-sm">
                                                                                    <i class="fa fa-receipt"></i>
                                                                                </button>
                                                                            </a>
                                                                        </td>

                                                                    </tr>
                                                                <?php endforeach; ?>
                                                            </tbody>
                                                        </table>
                                                    <?php else: ?>
                                                        <div class="alert alert-warning">
                                                            No leave records found for this employee.
                                                        </div>
                                                    <?php endif; ?>


                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /page content -->

            <?php include_once 'footer.php'; ?>
        </div>
    </div>

    <?php include_once 'libraries.php'; ?>
</body>
</html>
