<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.png" type="image/ico" />
    <title>Powertex LTD - Employee Leave Data</title>
    <?php include_once 'css_links.php'; ?>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <?php 
                include 'menu_finance.php'; 
                include_once 'model/employees_model.php';  

                $employees_model = new employees_model();
                $leave_data = $employees_model->getLeaveData();
            ?>

            <!-- page content -->
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title">
                        <div class="title_left">
                            <h3><small>Employee Leave Records</small></h3>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <div class="x_panel">
                                <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                    <!-- Left side: Title -->
                                    <div>
                                        <h2 class="mb-0">Employee Leave Details</h2>
                                    </div>

                                    <!-- Center: Title -->
                                    <div class="text-center flex-grow-1">
                                        <h5 class="mb-0">Annual Leave Summary</h5>
                                    </div>

                                    <!-- Right side: Back Button -->
                                    <ul class="nav navbar-right panel_toolbox mb-0" style="display: flex; align-items: center; gap: 10px; list-style: none; padding-left: 0;">
                                        <li>
                                            <form action="generate_pdf.php" method="post" style="margin: 0;">
                                                <input type="hidden" value="leave_summary" name="leave_summary">
                                                <button class="btn btn-danger btn-sm">Generate PDF <i class="fa fa-file-pdf"></i></button>
                                            </form>
                                        </li>

                                        <li>
                                            <a rel="facebox" href="new_leave.php" class="btn btn-info btn-sm" style="color: #fff;">
                                                Apply For Leave <i class="fa fa-receipt"></i>
                                            </a>
                                        </li>

                                        
                                        <li>
                                            <button class="btn btn-secondary btn-sm" onclick="history.back();">
                                                <i class="fa fa-arrow-left"></i> Back
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="clearfix"></div>

                                <div class="x_content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card-box table-responsive">                                                
                                                <?php
                                                    if (!empty($leave_data)) { ?>
                                                    <table id="datatable-buttons" class="table table-striped table-sm table-bordered" style="width:100%">
                                                        <thead>
                                                            <tr>
                                                                <th>Employee Name</th>
                                                                <th style="text-align: center;">Number of Leaves Requested</th>
                                                                <th style="text-align: center;">Total Number of Days</th>
                                                                <th style="text-align: center;">Days Taken</th>
                                                                <th style="text-align: center;">Days Remaining</th>
                                                                <th style="width:20%;text-align:center;">Status</th>
                                                                <th style="text-align: center;width:6%">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($leave_data as $leave): ?>
                                                                <tr>
                                                                    <td><?= htmlspecialchars($leave['fullname']) ?></td>
                                                                    <td style="text-align: center;"><?= htmlspecialchars($leave['leave_requests_count']) ?></td>
                                                                    <td style="text-align: center;"><?= htmlspecialchars($leave['total_days']) ?></td>
                                                                    <td style="text-align: center;"><?= htmlspecialchars($leave['total_taken']) ?></td>
                                                                    <td style="text-align: center;"><?= htmlspecialchars($leave['total_left']) ?></td>
                                                                    <?php
                                                                        $percent_left = 0;
                                                                        $total_days = $leave['total_days'] ?? 0;
                                                                        $total_left = $leave['total_left'] ?? 0;

                                                                        if ($total_days > 0) {
                                                                            $percent_left = ($total_left / $total_days) * 100;
                                                                            $percent_used = 100 - $percent_left;
                                                                        }else{
                                                                            $percent_used = 0;
                                                                        }
                                                                        

                                                                        // Determine background color and status message
                                                                        if($total_days >0){
                                                                            if ($percent_left > 70) {
                                                                                $bg_class = 'bg-success';

                                                                                if ($total_left >= 30) {
                                                                                    $status_message = 'Plenty of Days Available';
                                                                                } elseif ($total_left >= 18) {
                                                                                    $status_message = 'Comfortable Leave Balance';
                                                                                } else {
                                                                                    $status_message = 'Good Balance';
                                                                                }

                                                                            } elseif ($percent_left > 50) {
                                                                                $bg_class = 'bg-info';
                                                                                $status_message = 'Leave Days Available';

                                                                            } elseif ($percent_left > 20) {
                                                                                $bg_class = 'bg-warning';
                                                                                $status_message = 'Start Planning Leave Usage';

                                                                            } elseif ($percent_left > 5) {
                                                                                $bg_class = 'bg-secondary';
                                                                                $status_message = 'Few Days Remaining';

                                                                            } else {
                                                                                $bg_class = 'bg-danger';
                                                                                $status_message = 'Leave Days Exhausted';
                                                                            }
                                                                        }else{
                                                                            $bg_class = 'bg-danger';
                                                                            $status_message = 'No Leave days accumulated so far';
                                                                        }
                                                                        

                                                                    ?>

                                                                    <td class="<?= $bg_class ?>" style="color: white;">
                                                                        <strong>
                                                                        <?= number_format($percent_used, 2) ?>% used - 
                                                                        <em><?= $status_message ?></em>
                                                                    </td>

                                                                    <td style="text-align: center;">
                                                                        <a title="Employee Details" href="employee_details.php?employee_code=<?= $leave['employee_code']?>">
                                                                            <button class="btn btn-info btn-sm">
                                                                                <i class="fa fa-info-circle"></i>
                                                                            </button>
                                                                        </a>

                                                                        <a title="leave Breakdown" href="leave_breakdown.php?employee_code=<?php echo $leave['employee_code']?>">
                                                                            <button class="btn btn-info btn-sm">
                                                                                <i class="fa fa-list"></i>
                                                                            </button>
                                                                        </a>
                                                                    </td>

                                                                </tr>
                                                            <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                <?php } else { ?>
                                                    <div class="alert alert-warning">
                                                        No leave data available.
                                                    </div>
                                                <?php } ?>

                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /page content -->

            <?php include_once 'footer.php'; ?>
        </div>
    </div>

    <?php include_once 'libraries.php'; ?>
</body>
</html>
