<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD - Employee Leave Data</title>
        <?php include_once 'css_links.php'; ?> <!-- Keep your CSS links -->
    </head>
    <body class="nav-md">
        <div class="container body">
            <div class="main_container">

                <?php 
                    include 'menu_finance.php';
                    include_once 'model/employees_model.php';

                    $employees_model = new employees_model();

                    $leave_id = $_GET['id'];
                    $leaveDetails = $employees_model->getleaveSlipData($leave_id);
                    $employee_code = $leaveDetails['employee'];

                    
                    $employeeDetails = $employees_model->getEmployeeDetails($employee_code);
                ?> <!-- Keep the menu -->

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="page-title">
                            <div class="title_left">
                                <h3><small>Employee Leave Records</small></h3>
                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="x_panel">
                                    <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                        <!-- Left side: Title -->
                                        <div>
                                            <h2 class="mb-0">Employee Leave Details</h2>
                                        </div>

                                        <!-- Center: Title -->
                                        <div class="text-center flex-grow-1">
                                            <h5 class="mb-0">Employee Leave Slip</h5>
                                        </div>

                                        <!-- Right side: Back Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            <li>
                                                <button class="btn btn-secondary btn-sm" onclick="history.back();">
                                                    <i class="fa fa-arrow-left"></i> Back
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="clearfix"></div>

                                    <div class="x_content">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="card-box card-info table-responsive">
                                                    <div class="leave-info" style="padding: 30px; background: #f9f9f9; border-radius: 10px; box-shadow: 0 8px 20px rgba(0,0,0,0.1);">
                                                        <h4 class="text-center mb-4" style="font-weight: bold; color: #34495e;">📄 Employee Leave Slip</h4>

                                                        <table class="table table-bordered table-hover" style="background-color: white;">
                                                            <tbody>
                                                                <tr class="table-primary">
                                                                    <th>Employee Name</th>
                                                                    <td><?= htmlspecialchars($employeeDetails['fullname']) ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Leave ID</th>
                                                                    <td>#<?= htmlspecialchars($leaveDetails['id']) ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Leave Type</th>
                                                                    <td><?= htmlspecialchars($leaveDetails['leave_type']) ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Requested Start Date</th>
                                                                    <td><?= date('d M Y', strtotime($leaveDetails['start_date'])) ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Requested End Date</th>
                                                                    <td><?= date('d M Y', strtotime($leaveDetails['end_date'])) ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Requested Number of Days</th>
                                                                    <td><?= htmlspecialchars($leaveDetails['requested_numdays']) ?> day(s)</td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Leave Status</th>
                                                                    <?php
                                                                        $status_class = '';
                                                                        $status_text = '';
                                                                        switch ($leaveDetails['leaave_state']) {
                                                                            case 0:
                                                                                $status_class = 'bg-warning';
                                                                                $status_text = 'Pending';
                                                                                break;
                                                                            case 1:
                                                                                $status_class = 'bg-success';
                                                                                $status_text = 'Approved';
                                                                                break;
                                                                            case 3:
                                                                                $status_class = 'bg-danger';
                                                                                $status_text = 'Disapproved';
                                                                                break;
                                                                            default:
                                                                                $status_class = 'bg-primary';
                                                                                $status_text = 'Unknown';
                                                                                break;
                                                                        }
                                                                    ?>
                                                                    <td class="<?= $status_class ?>" style="color: white; font-weight: bold;">
                                                                        <?= $status_text ?>
                                                                    </td>
                                                                </tr>

                                                                <?php if ($leaveDetails['leaave_state'] == 1): ?>
                                                                    <tr>
                                                                        <th>Approved Start Date</th>
                                                                        <td><?= date('d M Y', strtotime($leaveDetails['approved_start_date'])) ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Approved End Date</th>
                                                                        <td><?= date('d M Y', strtotime($leaveDetails['approved_end_date'])) ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Approved Number of Days</th>
                                                                        <td><?= htmlspecialchars($leaveDetails['approved_numdays']) ?> day(s)</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Approved By</th>
                                                                        <td><?= htmlspecialchars($leaveDetails['approver']) ?></td>
                                                                    </tr>
                                                                <?php elseif ($leaveDetails['leaave_state'] == 3): ?>
                                                                    <tr>
                                                                        <th>Disapproved By</th>
                                                                        <td><?= htmlspecialchars($leaveDetails['disapprover']) ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Disapproved Date</th>
                                                                        <td><?= date('d M Y', strtotime($leaveDetails['disapproved_date'])) ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Reason for Disapproval Date</th>
                                                                        <td><?= $leaveDetails['reason']?></td>
                                                                    </tr>
                                                                <?php endif; ?>
                                                                <tr>
                                                                    <?php if ($leaveDetails['leaave_state'] == 0): ?>
                                                                        
                                                                        <div class="text-center mt-4">
                                                                            <td>
                                                                               <button type="button" class="btn btn-info action-approve" data-start-date="<?= $leaveDetails['start_date']?>" data-end-date="<?= $leaveDetails['end_date']?>" data-employee-name="<?= $leaveDetails['fullname']?>" data-request-id="<?= $leaveDetails['id'] ?>"  data-num-days="<?= $leaveDetails['requested_numdays'] ?>">Approve Leave
                                                                                <i class="fa fa-check-circle"></i>
                                                                            </button>
                                                                            </td>
                                                                            <td>
                                                                                <button type="button" title="Disapprove Leave" class="btn btn-danger action-disapprove" data-start-date="<?= $leaveDetails['start_date']?>" data-end-date="<?= $leaveDetails['end_date']?>" data-employee-name="<?= $leaveDetails['fullname']?>" data-request-id="<?= $leaveDetails['id'] ?>"  data-num-days="<?= $leaveDetails['requested_numdays'] ?>">Disapprove Leave
                                                                                <i class="fa fa-times-circle"></i>
                                                                            </button>
                                                                        </td>
                                                                            
                                                                        </div>
                                                                    <?php endif; ?>

                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->

                <?php include_once 'footer.php'; ?> <!-- Footer -->
            </div>
        </div>

        <?php include_once 'libraries.php'; ?> <!-- Include your JS libraries -->
        
        <script>
    function formatDate(dateStr) {
        const options = { year: 'numeric', month: 'long', day: 'numeric' };
        return new Date(dateStr).toLocaleDateString('en-GB', options);
    }

    document.querySelectorAll('.action-disapprove').forEach(button => {
        button.addEventListener('click', function () {
            const requestId = button.getAttribute('data-request-id');
            const employeeName = button.getAttribute('data-employee-name');
            const requestedStartDate = button.getAttribute('data-start-date');
            const requestedEndDate = button.getAttribute('data-end-date');
            const requestedNumDays = button.getAttribute('data-num-days');

            Swal.fire({
                title: 'Disapprove Leave',
                icon: 'warning',
                html: `
                    <div style="padding: 10px; font-size: 18px;">
                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Employee Name:</label>
                            <input type="text" class="form-control" value="${employeeName}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Requested Start Date:</label>
                            <input type="text" class="form-control" value="${formatDate(requestedStartDate)}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Requested End Date:</label>
                            <input type="text" class="form-control" value="${formatDate(requestedEndDate)}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label style="width: 200px; text-align: right; margin-right: 40px;">Number of Days:</label>
                            <input type="text"  class="form-control" value="${requestedNumDays}" readonly style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="margin-top: 20px;">
                            <label for="disapproval_reason" style="display: block; margin-bottom: 5px;">Reason for Disapproval:</label>
                            <textarea class="form-control" id="disapproval_reason" class="swal2-textarea" placeholder="Enter reason..." style="width: 100%; height: 100px;"></textarea>
                        </div>
                    </div>
                `,
                focusConfirm: false,
                showCancelButton: true,
                confirmButtonText: 'Submit Disapproval',
                cancelButtonText: 'Cancel',
                customClass: {
                    confirmButton: 'swal2-disapprove-btn'
                },
                preConfirm: () => {
                    const reason = document.getElementById('disapproval_reason').value.trim();

                    if (!reason) {
                        Swal.showValidationMessage('Please enter a reason for disapproval.');
                        return false;
                    }

                    return {
                        requestId,
                        reason
                    };
                }
            }).then(result => {
                if (result.isConfirmed) {
                    const data = result.value;

                    // Confirm message
                    Swal.fire({
                        icon: 'success',
                        title: 'Leave Disapproved',
                        html: `<strong>Reason:</strong> ${data.reason}`
                    });

                    // Send disapproval to backend
                    fetch('disapprove_leave.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(data)
                    })
                    .then(response => response.json())
                    .then(result => {
                        if (result.success) {
                            Swal.fire('Success', 'Leave disapproved successfully.', 'success');
                            setTimeout(() => { window.location.reload(); }, 3000);
                        } else {
                            Swal.fire('Error', result.message || 'Disapproval failed.', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        Swal.fire('Error', 'An error occurred while submitting.', 'error');
                    });
                }
            });
        });
    });
</script>
        <script>
    function formatDate(dateStr) {
        const options = { year: 'numeric', month: 'long', day: 'numeric' };
        return new Date(dateStr).toLocaleDateString('en-GB', options);
    }

    document.querySelectorAll('.action-approve').forEach(button => {
        button.addEventListener('click', function () {
            const requestId = button.getAttribute('data-request-id');
            const employeeName = button.getAttribute('data-employee-name');
            const requestedStartDate = button.getAttribute('data-start-date');
            const requestedEndDate = button.getAttribute('data-end-date');
            const requestedNumDays = button.getAttribute('data-num-days');

            Swal.fire({
                title: 'Approve Leave',
                icon: 'info',
                html: `
                    <div style="padding: 10px; font-size: 18px;">

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="employee_name" style="width: 200px; text-align: right; margin-right: 40px;">Employee Name:</label>
                            <input type="text" id="employee_name" class="form-control" value="${employeeName}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="start_date" style="width: 200px; text-align: right; margin-right: 40px;">Requested Start Date:</label>
                            <input type="text" id="start_date" class="form-control" value="${formatDate(requestedStartDate)}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="end_date" style="width: 200px; text-align: right; margin-right: 40px;">Requested End Date:</label>
                            <input type="text" id="end_date" class="form-control" value="${formatDate(requestedEndDate)}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="num_days" style="width: 200px; text-align: right; margin-right: 40px;">Requested Number of Days:</label>
                            <input type="text" id="num_days" class="form-control" value="${requestedNumDays}" readonly 
                                style="width: 230px; height: 38px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="approved_start_date" style="width: 200px; text-align: right; margin-right: 40px;">Approved Start Date:</label>
                            <input type="date" id="approved_start_date" class="form-control" min="<?= date('Y-m-d') ?>" 
                                style="width: 250px; height: 40px;">
                        </div>

                        <div style="display: flex; align-items: center; margin-bottom: 12px;">
                            <label for="approved_end_date" style="width: 200px; text-align: right; margin-right: 40px;">Approved End Date:</label>
                            <input type="date" id="approved_end_date" class="form-control" min="<?= date('Y-m-d') ?>" 
                                style="width: 250px; height: 40px;">
                        </div>

                        <div style="display: flex; align-items: center;">
                            <label for="approved_num_days" style="width: 200px; text-align: right; margin-right: 40px;">Number of Approved Days:</label>
                            <input type="text" id="approved_num_days" class="form-control" readonly 
                                style="width: 230px; height: 40px; background-color: #f1f1f1; cursor: not-allowed;">
                        </div>

                    </div>`,
                focusConfirm: false,
                showCancelButton: true,
                confirmButtonText: 'Confirm Approval',
                cancelButtonText: 'Cancel',
                didOpen: () => {
                    const startInput = document.getElementById('approved_start_date');
                    const endInput = document.getElementById('approved_end_date');
                    const daysInput = document.getElementById('approved_num_days');

                    function countWeekdays(startDate, endDate) {
                        let count = 0;
                        const current = new Date(startDate);

                        while (current <= endDate) {
                            const day = current.getDay();
                            if (day !== 0 && day !== 6) { // Exclude Sunday(0) & Saturday(6)
                                count++;
                            }
                            current.setDate(current.getDate() + 1);
                        }
                        return count;
                    }

                    function updateApprovedDays() {
                        const start = new Date(startInput.value);
                        const end = new Date(endInput.value);

                        if (!isNaN(start) && !isNaN(end) && end >= start) {
                            const diff = countWeekdays(start, end);
                            daysInput.value = diff;
                        } else {
                            daysInput.value = '';
                        }
                    }

                    startInput.addEventListener('change', updateApprovedDays);
                    endInput.addEventListener('change', updateApprovedDays);
                },
                preConfirm: () => {
                    const startDate = document.getElementById('approved_start_date').value;
                    const endDate = document.getElementById('approved_end_date').value;
                    const numDays = document.getElementById('approved_num_days').value;

                    if (!startDate || !endDate || !numDays) {
                        Swal.showValidationMessage('All fields must be completed and valid.');
                        return false;
                    }

                    return {
                        startDate,
                        endDate,
                        numDays,
                        requestId
                    };
                }
            }).then(result => {
                if (result.isConfirmed) {
                    const data = result.value;

                    Swal.fire({
                        icon: 'success',
                        title: 'Leave Approved',
                        html: `
                            <strong>Approved Start Date:</strong> ${data.startDate}<br>
                            <strong>Approved End Date:</strong> ${data.endDate}<br>
                            <strong>Total Days Approved:</strong> ${data.numDays}
                        `
                    });

                    fetch('approve_leave.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(data)
                    })
                        .then(response => response.json())
                        .then(result => {
                            if (result.success) {
                                Swal.fire('Success', 'Leave request approved successfully.', 'success');
                                setTimeout(() => { window.location.reload(); }, 4000);
                            } else {
                                Swal.fire('Error', result.message || 'Failed to approve leave.', 'error');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            Swal.fire('Error', 'An error occurred while saving.', 'error');
                        });
                }
            });
        });
    });
</script>

    </body>
</html>
