<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
            
          <?php
            include 'menu_finance.php';
            include_once 'model/employees_model.php';

            $employees_model = new employees_model();

            $employees = $employees_model->getActiveEmployees();
          ?>
            <!-- page content -->
          <div class="right_col" role="main">
            <div class="">
              <div class="page-title">
                <div class="title_left">
                  <h3><small>Employees </small></h3>
                </div>

                <div class="title_right">
                  <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  </div>
                </div>
              </div>

              <div class="clearfix"></div>

              <div class="row">
                <div class="col-md-12 col-sm-12 ">
                  <div class="x_panel">
                    <div class="x_title">
                      <h2>Manage Employees</h2>
                      <ul class="nav navbar-right panel_toolbox">
                        <li>
                          <a class="dropdown-item" href="register_employee.php">
                            <button class="btn btn-info">Register Employee</button>
                          </a>
                        </li>
                        <li>
                          <a href="import_employees.php" rel="facebox">
                            <button class="btn btn-info">Import Employees</button>
                          </a>
                        </li>
                      </ul>
                      <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                      <div class="row">
                        <div class="col-sm-12">
                          <div class="card-box table-responsive">
                            <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
                              <thead>
                                <tr>
                                  <th style="text-align: left;">Fullname</th>
                                  <th style="text-align: center;">National ID</th>
                                  <th style="text-align: center;">Post</th>
                                  <th style="text-align: center;">Department</th>
                                  <th style="text-align: center;">Phone Number</th>
                                  <th style="text-align: center;">Email Address</th>
                                  <th style="text-align: center;">Location of Stay</th>
                                  <th style="text-align: center;">Gender</th>
                                  <th style="text-align: center;">Action</th>
                                </tr>
                              </thead>
                              <tbody>
                                <?php
                                  foreach($employees as $employee):
                                ?>
                                  <tr>
                                    <td><?php echo $employee['fullname']?></td>
                                    <td><?php echo $employee['national_id_number']?></td>
                                    <td><?php echo $employee['postname']?></td>
                                    <td><?php echo $employee['department_name']?></td>
                                    <td><?php echo $employee['phone_number']?></td>
                                    <td><?php echo $employee['email_address']?></td>
                                    <td><?php echo $employee['location_name']?></td>
                                    <td><?php echo $employee['gender']?></td>
                                    <td>
                                      <a href="employee_details.php?employee_code=<?php echo $employee['employee_code']?>">
                                        <button class="btn btn-info btn-sm">
                                          <i class="fa fa-eye"></i>
                                        </button>
                                      </a>

                                      <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editEmployeeModal" onclick="loadEmployeeDetails('<?php echo $employee['employee_code']; ?>')">
                                        <i class="fa fa-edit"></i>
                                      </button>

                                    </td>
                                  </tr>
                                <?php
                                  endforeach;
                                ?>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /page content -->

          <div class="modal fade" id="editEmployeeModal" tabindex="-1" role="dialog" aria-labelledby="editEmployeeModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
              <div class="modal-content">
                <form method="POST" action="controllers/employees_controller.php">
                  <div class="modal-header">
                    <h5 class="modal-title">Edit Employee Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span>&times;</span>
                    </button>
                  </div>

                  <div class="modal-body">
                    <!-- Hidden inputs -->
                    <input type="hidden" name="action" value="update_employee_details">
                    <input type="hidden" name="employee_code" id="employee_code">

                    <!-- National ID & Full Name -->
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="national_id_number">National ID</label>
                        <input type="text" class="form-control" name="national_id_number" id="national_id_number" required>
                      </div>
                      <div class="form-group col-md-6">
                        <label for="fullname">Full Name</label>
                        <input type="text" class="form-control" name="fullname" id="fullname" required>
                      </div>
                    </div>

                    <!-- Phone Number & Email Address -->
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="phone_number">Phone Number</label>
                        <input type="text" class="form-control" name="phone_number" id="phone_number" required>
                      </div>
                      <div class="form-group col-md-6">
                        <label for="email_address">Email Address</label>
                        <input type="email" class="form-control" name="email_address" id="email_address" required>
                      </div>
                    </div>

                    <!-- Gender & Date of Birth -->
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="gender">Gender</label>
                        <select class="form-control" name="gender" id="gender" required>
                          <option value="">-- Select --</option>
                          <option value="Male">Male</option>
                          <option value="Female">Female</option>
                        </select>
                      </div>
                      <div class="form-group col-md-6">
                        <label for="date_of_birth">Date of Birth</label>
                        <input type="date" class="form-control" name="date_of_birth" id="date_of_birth" required>
                      </div>
                    </div>

                    <!-- Current Location (dropdown) & Nationality (dropdown) -->
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="current_location">Current Location</label>
                        <select class="form-control" name="current_location" id="current_location" required>
                          <!-- Options populated dynamically -->
                        </select>
                      </div>
                      <div class="form-group col-md-6">
                        <label for="nationality">Nationality</label>
                        <select class="form-control" name="nationality" id="nationality" required>
                          <!-- Options populated dynamically -->
                        </select>
                      </div>
                    </div>

                    <!-- Home Village & Home District (dropdown) -->
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <label for="home_village">Home Village</label>
                        <input type="text" class="form-control" name="home_village" id="home_village" required>
                      </div>
                      <div class="form-group col-md-6">
                        <label for="home_district">Home District</label>
                        <select class="form-control" name="home_district" id="home_district" required>
                          <!-- Options populated dynamically -->
                        </select>
                      </div>
                    </div>
                  </div>

                  <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update Employee</button>
                  </div>
                </form>
              </div>
            </div>
          </div>


          <?php
            include_once 'footer.php';
          ?>
        </div>
      </div>

      <?php
        include_once 'libraries.php';
      ?>
      <script>
        $(document).ready(function () {
          if (!$.fn.DataTable.isDataTable('#datatable-buttons')) {
            $('#datatable-buttons').DataTable({
              order: [[0, 'asc']],         // Sort by Fullname ASC
              responsive: true,
              searching: true,
              paging: true,
              pageLength: 50               // 👈 Default rows per page
            });
          }
        });
      </script>
      <script>
        function loadEmployeeDetails(employee_code) {
          $.ajax({
            url: 'get_employee_edit_data.php',
            type: 'POST',
            data: { employee_code: employee_code },
            success: function(response) {
              const emp = JSON.parse(response);

              if (emp.error) {
                alert(emp.error);
                return;
              }

              $('#employee_code').val(emp.employee_code);
              $('#national_id_number').val(emp.national_id_number);
              $('#fullname').val(emp.fullname);
              $('#phone_number').val(emp.phone_number);
              $('#email_address').val(emp.email_address);
              $('#gender').val(emp.gender);
              $('#date_of_birth').val(emp.date_of_birth);
              $('#home_village').val(emp.home_village);

              // Populate dropdowns with helper function
              populateDropdown('get_districts.php', 'home_district', emp.home_district, emp.district_name);
              populateDropdown('get_nationalities.php', 'nationality', emp.nationality_id , emp.nationality);
              populateDropdown('get_locations.php', 'current_location', emp.current_location, emp.location_name);


              $('#editEmployeeModal').modal('show');
            },
            error: function(xhr) {
              console.error('Error:', xhr);
              alert('Failed to fetch employee details.');
            }
          });
        }

        function populateDropdown(url, elementId, selectedId, selectedName) {
          $.ajax({
            url: url,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
              const $dropdown = $('#' + elementId);
              $dropdown.empty();

              // Add selected value first
              if (selectedId && selectedName) {
                $dropdown.append(`<option value="${selectedId}" selected>${selectedName}</option>`);
              } else {
                $dropdown.append('<option value="" selected>-- Select --</option>');
              }

              // Determine field keys based on dropdown ID
              let idKey, nameKey;

              switch (elementId) {
                case 'home_district':
                  idKey = 'id';         // from get_districts.php
                  nameKey = 'district'; // from get_districts.php
                  break;
                case 'nationality':
                  idKey = 'id';            // from get_nationalities.php
                  nameKey = 'nationality'; // from get_nationalities.php
                  break;
                case 'current_location':
                  idKey = 'loc_id';         // from get_locations.php
                  nameKey = 'location_name'; // from get_locations.php
                  break;
                default:
                  console.warn(`Unknown dropdown type: ${elementId}`);
                  return;
              }

              // Append all other options
              data.forEach(item => {
                if (item[idKey] != selectedId) {
                  $dropdown.append(`<option value="${item[idKey]}">${item[nameKey]}</option>`);
                }
              });
            },
            error: function(err) {
              console.error(`Failed loading ${elementId}:`, err);
            }
          });
        }

      </script>





    </body>
  </html>
