<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
      </head>

      <body class="nav-md">
        <div class="container body">
          <div class="main_container">
            
            <?php
              include 'menu_finance.php';
              include_once 'model/warehouse_model.php';

              $warehouse_model = new warehouse_model();
              $warehouses = $warehouse_model->getWarehouses();

            ?>
            <!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3><small>Warehouse </small></h3>
              </div>

              <div class="title_right">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  
                </div>
              </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">
              

              

              <div class="col-md-12 col-sm-12 ">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Manage Warehouses</h2>
                    <ul class="nav navbar-right panel_toolbox">
                        <li>
                            <a class="dropdown-item" rel="facebox" href="new_warehouse.php">
                                <button class="btn btn-info">New Warehouse</button>
                            </a>
                        </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                      <div class="row">
                          <div class="col-sm-12">
                            <div class="card-box table-responsive">
                    
                    <table id="warehouses-table" class="table table-striped table-bordered" style="width:100%">
                      <thead>
                        <tr>
                          <th>Name</th>
                          <th>Location</th>
                          <th>Supervisors</th>
                          <th>Phone Number</th>
                          <th style="text-align: center;">Num Items</th>
                          <th style="text-align: center;">Warehouse Status</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                            foreach($warehouses as $data):
                        ?>
                          <tr>
                            <td><?php echo $data['warehouse_name']?></td>
                            <td><?php echo $data['location_name']?></td>
                            <td><?php echo $data['supervisor_name']?></td>
                            <td><?php echo $data['phone_number']?></td>
                            <td style="text-align: center;"><?php echo $data['product_count']?></td>
                            <td class="<?php
                              $status = $data['warehouse_state'];
                              switch ($status) {
                                case '1':
                                  echo 'bg-success text-white';
                                break;
                                
                                case '0':
                                  echo 'bg-danger text-white';
                                break;

                                default:
                                  echo '';
                                
                                }
                              ?>">
                              <?php echo htmlspecialchars(ucfirst($data['warehouse_status'])); ?>
                            </td>
                            <td>
                                <a href="warehouse_stock.php?id=<?php echo $data['warehouse_id']?>">
                                    <button class="btn btn-info btn-sm" title="View Items in warehouse">
                                      <i class="fa fa-list"></i>
                                    </button>
                                </a>

                                <a rel="facebox" href="edit_warehouse.php?id=<?php echo $data['warehouse_id']?>">
                                    <button class="btn btn-info btn-sm" title="Edit warehouse details">
                                      <i class="fa fa-edit"></i>
                                    </button>
                                </a>

                                <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                      <button class="btn btn-info btn-sm" title="Warehouse settings">
                                        <i class="fa fa-cog"></i>
                                      </button>
                                    </a>
                            </td>
                          </tr>
                        <?php
                            endforeach;
                        ?>
                        
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
                </div>
              </div>

              

              
            </div>
          </div>
        </div>
        <!-- /page content -->
          </div>
          <!-- /page content -->

        <?php
          include_once 'footer.php';
        ?>
      </div>
    </div>

    <?php
      include_once 'libraries.php';
    ?>
    <script>
            function showDisabledNotification() {
            const type = 'warning';
            const title = 'Feature Disabled';
            const message = 'This feature is currently disabled.';

            toastr[type](message, title);
          }
        </script>
    <script>
      $(document).ready(function () {
          let table = $('#warehouses-table').DataTable({
              responsive: true,
              ordering: true,
              pageLength: 10,
              columnDefs: [
                  {
                      targets: -1, // Assuming "Action" is the last column; use correct index if different
                      width: "150px",
                      className: "text-center",
                      orderable: false // Usually actions shouldn't affect sorting
                  }
              ]
          });

          // Search across all columns using external input
          $('#search_query').on('keyup', function () {
              table.search(this.value).draw();
          });
      });
  </script>
    
	
  </body>
</html>
