<?php

include_once 'config.php';

class banking_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function getBankAccounts(){
        $sql = 'SELECT * FROM bank_accounts order by account_state DESC';
        $smtp = $this->link->prepare($sql);
        $smtp->execute();
        $data = $smtp->fetchAll(PDO::FETCH_ASSOC);

        return $data;
    }

    public function addBankAccount($bank_name, $account_name, $account_number, $bank_state, $datecreated, $operator){
        $sql = "INSERT INTO bank_accounts(bank_name, account_name, account_number, account_state, datecreated, operator)
                VALUES (?, ?, ?, ?, ?, ?)";

        $stmt = $this->link->prepare($sql);
        return $stmt->execute([
            $bank_name,
            $account_name,
            $account_number,
            $bank_state,
            $datecreated,
            $operator
        ]);
    }

    public function updateBank($id, $bank_name, $account_name, $account_number) {
        $sql = "UPDATE bank_accounts SET bank_name = ?, account_name = ?, account_number = ? WHERE account_id = ?";
        $stmt = $this->link->prepare($sql);
        return $stmt->execute([$bank_name, $account_name, $account_number, $id]);
    }

    public function updateBankState($id, $state) {
        $sql = "UPDATE bank_accounts SET account_state = ? WHERE account_id = ?";
        $stmt = $this->link->prepare($sql);
        return $stmt->execute([$state, $id]);
    }

    public function getAllDeposits($month = null, $year = null, $account = null){
        $sql = "SELECT 
                    d.deposit_id,
                    d.reference_number as deposit_reference,
                    d.date_deposited,
                    d.amount_deposited as amount,
                    d.deposit_state,    
                    b.bank_name,
                    b.account_name,
                    b.account_number,
                    COALESCE(u.fullname, 'Default Account') as operator_name
                FROM 
                    cash_deposits d
                JOIN 
                    bank_accounts b ON d.account = b.account_id
                LEFT JOIN 
                    employees u ON d.operator = u.employee_code
                WHERE 1=1";

        if($month){
            $sql .= " AND MONTH(d.date_deposited) = :month";
        }

        if($year){
            $sql .= " AND YEAR(d.date_deposited) = :year";
        }

        if($account){
            $sql .= " AND d.account = :account";
        }

        $sql .= " ORDER BY d.date_deposited DESC";

        $stmt = $this->link->prepare($sql);

        if($month)  $stmt->bindValue(':month', $month);
        if($year)   $stmt->bindValue(':year', $year);
        if($account)$stmt->bindValue(':account', $account);

        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function cancelDeposit($id){

        $stmt = $this->link->prepare("UPDATE 
                cash_deposits
            SET 
                deposit_state = 0
            WHERE 
                deposit_id = :id
                AND deposit_state != 0");

        $stmt->bindValue(':id', $id);

        return $stmt->execute();
    }   

    public function getRequiredCashTotal($month, $year){
        $sql = "SELECT 
                    SUM(amount_paid) as total_cash
                FROM 
                    payments
                WHERE 
                    payment_state = 1
                    AND payment_method = 'Cash'
                    AND MONTH(payment_date) = ?
                    AND YEAR(payment_date) = ?";

        $stmt = $this->link->prepare($sql);
        $stmt->execute([$month, $year]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row['total_cash'] ?? 0;
    }

    public function getTotalCashPayments(){
        $sql = "SELECT 
                    SUM(amount_paid) as total
                FROM 
                    payments
                WHERE 
                    payment_state = 1
                    AND payment_method = 'Cash'";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row['total'] ?? 0;
    }

    public function getTotalApprovedExpenses(){
        $sql = "SELECT 
                    SUM(amount_paid) as total
                FROM 
                    recorded_expenses
                WHERE 
                    expense_state = 2";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row['total'] ?? 0;
    }

    public function getTotalApprovedDeposits(){
        $sql = "SELECT 
                    SUM(amount_deposited) as total
                FROM 
                    cash_deposits
                WHERE 
                    deposit_state = 1";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row['total'] ?? 0;
    }
    
}