<?php

include_once 'config.php';

class companies_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }
    
    public function getThirdpartyCompanies() {
        $sql = "SELECT company_name, company_id FROM third_party_companies WHERE company_state = 1";
        
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_third_parties() {
        $sql = "SELECT 
                    company_id as id, 
                    company_name, 
                    contact_person, 
                    phone_number as phone, 
                    email_address as email, 
                    location,
                    company_state,
                    CASE 
                        WHEN company_state = 1 THEN 'Active Company'
                        WHEN company_state = 0 THEN 'Inactive Company'
                    END as company_status
                FROM 
                    third_party_companies 
                WHERE 
                    company_state IN (0,1)";
        
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_suppliers() {
        $sql = "SELECT 
                    supplier_id as id, 
                    supplier_name, 
                    contact_person, 
                    contact_number as phone, 
                    email_address as email, 
                    supplier_state,
                    CASE 
                        WHEN supplier_state = 1 THEN 'Active Supplier'
                        WHEN supplier_state = 0 THEN 'Inactive Supplier'
                    END as supplier_status
                FROM 
                    suppliers 
                WHERE 
                    supplier_state IN (0,1)";
        
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getThirdPartyCompanyDetails($company_id) {

        $sql = "SELECT 
                c.id,
                c.company_name,
                c.contact_person,
                c.phone_number as contact_number,
                c.email_address as email,
                ll.location_name as address
            FROM 
                third_party_companies c
            LEFT JOIN 
                third_party_products p ON p.company_id = c.company_id
            LEFT JOIN
                locations ll ON c.location = ll.loc_id 
            WHERE 
                c.company_id = :company_id
            GROUP BY 
                c.company_id
            LIMIT 1
        ";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':company_id', $company_id, PDO::PARAM_STR);
        $stmt->execute();

        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getThirdPartyCompanyProducts($company_id) {
        $sql = "SELECT 
                tp.product_id,
                pp.product_name,
                pc.categoryname AS category,
                tp.opening_stock,
                tp.quantity,
                tp.product_state,
                tp.min_level,

                CASE 
                    WHEN tp.product_state = 1 THEN 'Active Product'
                    WHEN tp.product_state = 0 THEN 'Deactivated Product'
                END as product_status,

                IFNULL((
                    SELECT 
                        SUM(sti.quantity)
                    FROM 
                        stock_transfer_in sti
                    WHERE 
                        sti.product_id = tp.product_id 
                        AND sti.company_id = tp.company_id
                        AND sti.transfer_state =2
                ), 0) AS total_received,

                IFNULL((
                    SELECT 
                        SUM(sto.qty_initiated)
                    FROM 
                        stock_transfer_items sto
                    WHERE 
                        sto.product_id = tp.product_id 
                        AND sto.transfer_from = tp.company_id
                        AND sto.transfer_state IN(1,2)
                ), 0) AS total_released,

                IFNULL((
                    SELECT 
                        SUM(sto.qty_initiated)
                    FROM 
                        stock_transfer_items sto
                    WHERE 
                        sto.product_id = tp.product_id 
                        AND sto.transfer_to = tp.company_id
                        AND sto.transfer_state = 1
                ), 0) AS total_pending_in,

                IFNULL((
                    SELECT 
                        SUM(sto.qty_initiated)
                    FROM 
                        stock_transfer_items sto
                    WHERE 
                        sto.product_id = tp.product_id 
                        AND sto.transfer_from = tp.company_id
                        AND sto.transfer_state = 1
                ), 0) AS total_pending_out
            FROM 
                third_party_products tp

            LEFT JOIN products pp ON tp.product_id = pp.product_id
            LEFT JOIN product_categories pc ON pp.category = pc.category_id

            WHERE 
                tp.company_id = :company_id
            GROUP BY
                tp.product_id
            ORDER BY
                tp.product_state DESC, 
                pp.product_name ASC
        ";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':company_id', $company_id, PDO::PARAM_STR);
        $stmt->execute();

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $rows;
    }


    public function getUnlinkedProducts($id) {
        
            $sql = "SELECT p.*,
                    pc.categoryname,
                    pu.unitname
                FROM 
                    products p
                LEFT JOIN 
                    product_categories pc ON p.category = pc.category_id
                LEFT JOIN
                    product_units pu ON p.unit = pu.unit_id
                    WHERE product_id NOT IN (
                        SELECT product_id FROM third_party_products WHERE company_id = ?
                    )";
        
    
        $stmt = $this->link->prepare($sql);
        $stmt->bindValue(1, $id, PDO::PARAM_STR); // Use bindValue with positional placeholder
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC); // Use PDO::FETCH_ASSOC instead of MYSQLI_ASSOC
    }

    public function linkSingleProductToLocation($company_id, $product, $opening_stock, $quantity, $min_level, $order_price, $datecaptured, $operator, $product_state) {
        $sql = "INSERT INTO third_party_products (company_id, product_id, opening_stock, quantity, min_level, order_price, datecaptured, operator, product_state) 
                VALUES (:company_id, :product_id, :opening_stock, :quantity, :min_level, :order_price, :datecaptured, :operator, :product_state)";

        $stmt = $this->link->prepare($sql);

        $stmt->bindParam(':company_id', $company_id, PDO::PARAM_STR);
        $stmt->bindParam(':product_id', $product, PDO::PARAM_INT);
        $stmt->bindParam(':opening_stock', $opening_stock, PDO::PARAM_STR); 
        $stmt->bindParam(':quantity', $quantity, PDO::PARAM_STR);           
        $stmt->bindParam(':min_level', $min_level, PDO::PARAM_STR);         
        $stmt->bindParam(':order_price', $order_price, PDO::PARAM_STR);     
        $stmt->bindParam(':datecaptured', $datecaptured, PDO::PARAM_STR);
        $stmt->bindParam(':operator', $operator, PDO::PARAM_INT);
        $stmt->bindParam(':product_state', $product_state, PDO::PARAM_INT);

        return $stmt->execute();
    }


    public function getProductBreakdown($company_id, $product_id){
        $sql ="SELECT
                    tcp.datecaptured AS date,
                    p.product_name,
                    pc.categoryname,
                    0 AS opening_stock,
                    tcp.opening_stock AS quantity,
                    tcp.opening_stock AS closing_stock,
                    'Initial Opening' AS direction
                FROM
                    third_party_products tcp
                LEFT JOIN
                    products p ON tcp.product_id = p.product_id
                LEFT JOIN
                    product_categories pc ON p.category = pc.category_id
                WHERE
                    tcp.company_id = :company_id
                    AND tcp.product_id = :product_id
    
            UNION ALL
            SELECT
                sti.datecaptured as date,
                p.product_name,
                pc.categoryname,
                sti.opening_balance as opening_stock,
                sti.approved_quantity as quantity,
                sti.closing_stock,
                'Transfer In' as direction
                
            FROM
                stock_transfer_in sti
            LEFT JOIN
                products p ON sti.product_id = p.product_id
            LEFT JOIN
                product_categories pc ON p.category = pc.category_id
            WHERE
                sti.company_id = :company_id
                AND sti.product_id = :product_id
                AND sti.transfer_state  = 2
                
            UNION ALL
            
            
            SELECT
                sto.datecaptured as date,
                p.product_name,
                pc.categoryname,
                sto.sender_opening_stock as opening_stock,
                sto.qty_initiated as quantity,
                sto.sender_closing_stock as closing_stock,
                'Transfer Out' as direction

            FROM
                stock_transfer_items sto
            LEFT JOIN
                products p ON sto.product_id = p.product_id
            LEFT JOIN
                product_categories pc ON p.category = pc.category_id
            WHERE
                sto.transfer_from = :company_id
                AND sto.product_id = :product_id
                AND sto.transfer_state IN(1,2)
            ORDER BY
                date DESC
                ";
        $smtp = $this->link->prepare($sql);
        $smtp->bindParam(':company_id', $company_id, PDO::PARAM_STR);
        $smtp->bindParam(':product_id', $product_id, PDO::PARAM_INT);

        $smtp->execute();

        $list = $smtp->fetchAll(PDO::FETCH_ASSOC);

        return $list;
    }



    
    
    

    

}